/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public class NSDate
extends NSObject {
    private final Date date;
    private static final long EPOCH = 978307200000L;
    private static final SimpleDateFormat sdfDefault = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat sdfGnuStep = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public NSDate(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public NSDate(byte[] bytes, int startIndex, int endIndex) {
        this.date = new Date(978307200000L + (long)(1000.0 * BinaryPropertyListParser.parseDouble(bytes, startIndex, endIndex)));
    }

    public NSDate(String textRepresentation) throws ParseException {
        this.date = NSDate.parseDateString(textRepresentation);
    }

    public NSDate(Date d2) {
        if (d2 == null) {
            throw new IllegalArgumentException("Date cannot be null");
        }
        this.date = d2;
    }

    private static synchronized Date parseDateString(String textRepresentation) throws ParseException {
        try {
            return sdfDefault.parse(textRepresentation);
        }
        catch (ParseException ex2) {
            return sdfGnuStep.parse(textRepresentation);
        }
    }

    private static synchronized String makeDateString(Date date) {
        return sdfDefault.format(date);
    }

    private static synchronized String makeDateStringGnuStep(Date date) {
        return sdfGnuStep.format(date);
    }

    public Date getDate() {
        return this.date;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().equals(this.getClass()) && this.date.equals(((NSDate)obj).getDate());
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    @Override
    public NSDate clone() {
        return new NSDate((Date)this.getDate().clone());
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<date>");
        xml.append(NSDate.makeDateString(this.date));
        xml.append("</date>");
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        out.write(51);
        out.writeDouble((double)(this.date.getTime() - 978307200000L) / 1000.0);
    }

    public String toString() {
        return this.date.toString();
    }

    @Override
    public Object toJavaObject() {
        return this.date;
    }

    @Override
    public int compareTo(NSObject o2) {
        Objects.requireNonNull(o2);
        if (o2 == this) {
            return 0;
        }
        if (o2 instanceof NSDate) {
            return this.getDate().compareTo(((NSDate)o2).getDate());
        }
        return this.getClass().getName().compareTo(o2.getClass().getName());
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append('\"');
        ascii.append(NSDate.makeDateString(this.date));
        ascii.append('\"');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append("<*D");
        ascii.append(NSDate.makeDateStringGnuStep(this.date));
        ascii.append('>');
    }

    static {
        sdfDefault.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdfGnuStep.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

