/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;

public class UID
extends NSObject {
    private final BigInteger uid;
    private final String name;

    public UID(String name, BigInteger value) {
        this.name = name;
        this.uid = Objects.requireNonNull(value);
        if (this.uid.bitLength() > 128) {
            throw new IllegalArgumentException("The specified UID exceeds the maximum length of 128-bit.");
        }
        if (this.uid.signum() < 0) {
            throw new IllegalArgumentException("The specified value is negative.");
        }
    }

    public UID(String name, byte[] bytes) {
        this(name, new BigInteger(1, Objects.requireNonNull(bytes)));
    }

    public byte[] getBytes() {
        byte[] data = this.uid.toByteArray();
        if (data.length == 3) {
            byte[] paddedData = new byte[4];
            System.arraycopy(data, 0, paddedData, 1, 3);
            data = paddedData;
        } else if (data.length > 4 && data.length < 8) {
            byte[] paddedData = new byte[8];
            System.arraycopy(data, 0, paddedData, 8 - data.length, data.length);
            data = paddedData;
        } else if (data.length > 8 && data.length < 16) {
            byte[] paddedData = new byte[16];
            System.arraycopy(data, 0, paddedData, 16 - data.length, data.length);
            data = paddedData;
        }
        return data;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public UID clone() {
        return new UID(this.name, this.uid.toByteArray());
    }

    @Override
    public Object toJavaObject() {
        return this.getBytes();
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        NSDictionary uidDict = new NSDictionary();
        uidDict.put("CF$UID", new NSNumber(this.uid.longValue()));
        uidDict.toXML(xml, level);
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        byte[] bytes = this.getBytes();
        out.write(128 + bytes.length - 1);
        out.write(bytes);
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        new NSString(this.uid.toString(16)).toASCII(ascii, level);
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        new NSString(this.uid.toString(16)).toASCIIGnuStep(ascii, level);
    }

    @Override
    public int compareTo(NSObject o2) {
        Objects.requireNonNull(o2);
        if (o2 == this) {
            return 0;
        }
        if (o2 instanceof UID) {
            UID other = (UID)o2;
            int diff = this.uid.compareTo(other.uid);
            if (diff == 0) {
                if (this.name == null) {
                    return other.name != null ? 1 : 0;
                }
                if (other.name == null) {
                    return -1;
                }
                return this.name.compareTo(other.name);
            }
            return diff;
        }
        return this.getClass().getName().compareTo(o2.getClass().getName());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UID uid2 = (UID)o2;
        return this.uid.equals(((UID)o2).uid) && Objects.equals(this.name, uid2.name);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.name);
        result2 = 31 * result2 + this.uid.hashCode();
        return result2;
    }

    public String toString() {
        return this.uid.toString(16) + (this.name != null ? " (" + this.name + ")" : "");
    }
}

