/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSObject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public class XMLPropertyListWriter {
    public static void write(NSObject root, File out) throws IOException {
        Objects.requireNonNull(root, "The root object is null.");
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        XMLPropertyListWriter.write(root, out.toPath());
    }

    public static void write(NSObject root, Path path) throws IOException {
        try (OutputStream fileOutputStream = Files.newOutputStream(path, new OpenOption[0]);){
            XMLPropertyListWriter.write(root, fileOutputStream);
        }
    }

    public static void write(NSObject root, OutputStream out) throws IOException {
        Objects.requireNonNull(root, "The root object is null.");
        OutputStreamWriter w2 = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        w2.write(root.toXMLPropertyList());
        w2.flush();
    }
}

