/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.objenesis.instantiator.sun;

import com.esotericsoftware.kryo.kryo5.objenesis.ObjenesisException;
import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.ObjectInstantiator;
import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.SerializationInstantiatorHelper;
import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.annotations.Instantiator;
import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.annotations.Typology;
import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.sun.SunReflectionFactoryHelper;
import java.io.NotSerializableException;
import java.lang.reflect.Constructor;

@Instantiator(value=Typology.SERIALIZATION)
public class SunReflectionFactorySerializationInstantiator<T>
implements ObjectInstantiator<T> {
    private final Constructor<T> mungedConstructor;

    public SunReflectionFactorySerializationInstantiator(Class<T> type) {
        Constructor<T> nonSerializableAncestorConstructor;
        Class<T> nonSerializableAncestor = SerializationInstantiatorHelper.getNonSerializableSuperClass(type);
        try {
            nonSerializableAncestorConstructor = nonSerializableAncestor.getDeclaredConstructor(null);
        }
        catch (NoSuchMethodException e2) {
            throw new ObjenesisException(new NotSerializableException(type + " has no suitable superclass constructor"));
        }
        this.mungedConstructor = SunReflectionFactoryHelper.newConstructorForSerialization(type, nonSerializableAncestorConstructor);
        this.mungedConstructor.setAccessible(true);
    }

    @Override
    public T newInstance() {
        try {
            return this.mungedConstructor.newInstance(null);
        }
        catch (Exception e2) {
            throw new ObjenesisException(e2);
        }
    }
}

