/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.reflectasm.MethodAccess;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class BeanSerializer<T>
extends Serializer<T> {
    static final Object[] noArgs = new Object[0];
    private CachedProperty[] properties;
    Object access;

    public BeanSerializer(Kryo kryo, Class type) {
        BeanInfo info;
        try {
            info = Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException ex2) {
            throw new KryoException("Error getting bean info.", ex2);
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        Arrays.sort(descriptors, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList cachedProperties = new ArrayList(descriptors.length);
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            String name = propertyDescriptor.getName();
            if (name.equals("class")) continue;
            Method getMethod = propertyDescriptor.getReadMethod();
            Method setMethod = propertyDescriptor.getWriteMethod();
            if (getMethod == null || setMethod == null) continue;
            Serializer serializer2 = null;
            Class<?> returnType = getMethod.getReturnType();
            if (kryo.isFinal(returnType)) {
                serializer2 = kryo.getRegistration(returnType).getSerializer();
            }
            CachedProperty cachedProperty = new CachedProperty();
            cachedProperty.name = name;
            cachedProperty.getMethod = getMethod;
            cachedProperty.setMethod = setMethod;
            cachedProperty.serializer = serializer2;
            cachedProperty.setMethodType = setMethod.getParameterTypes()[0];
            cachedProperties.add(cachedProperty);
        }
        this.properties = cachedProperties.toArray(new CachedProperty[cachedProperties.size()]);
        try {
            this.access = MethodAccess.get(type);
            for (CachedProperty cachedProperty : this.properties) {
                cachedProperty.getterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.getMethod.getName(), cachedProperty.getMethod.getParameterTypes());
                cachedProperty.setterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.setMethod.getName(), cachedProperty.setMethod.getParameterTypes());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void write(Kryo kryo, Output output2, T object) {
        Class<?> type = object.getClass();
        for (CachedProperty property : this.properties) {
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write property: " + property + " (" + type.getName() + ")");
                }
                Object value = property.get(object);
                Serializer serializer2 = property.serializer;
                if (serializer2 != null) {
                    kryo.writeObjectOrNull(output2, value, serializer2);
                    continue;
                }
                kryo.writeClassAndObject(output2, value);
            }
            catch (IllegalAccessException ex2) {
                throw new KryoException("Error accessing getter method: " + property + " (" + type.getName() + ")", ex2);
            }
            catch (InvocationTargetException ex3) {
                throw new KryoException("Error invoking getter method: " + property + " (" + type.getName() + ")", ex3);
            }
            catch (KryoException ex4) {
                ex4.addTrace(property + " (" + type.getName() + ")");
                throw ex4;
            }
            catch (Throwable t2) {
                KryoException ex5 = new KryoException(t2);
                ex5.addTrace(property + " (" + type.getName() + ")");
                throw ex5;
            }
        }
    }

    @Override
    public T read(Kryo kryo, Input input2, Class<? extends T> type) {
        T object = kryo.newInstance(type);
        kryo.reference(object);
        for (CachedProperty property : this.properties) {
            try {
                Serializer serializer2;
                if (Log.TRACE) {
                    Log.trace("kryo", "Read property: " + property + " (" + object.getClass() + ")");
                }
                Object value = (serializer2 = property.serializer) != null ? kryo.readObjectOrNull(input2, property.setMethodType, serializer2) : kryo.readClassAndObject(input2);
                property.set(object, value);
            }
            catch (IllegalAccessException ex2) {
                throw new KryoException("Error accessing setter method: " + property + " (" + object.getClass().getName() + ")", ex2);
            }
            catch (InvocationTargetException ex3) {
                throw new KryoException("Error invoking setter method: " + property + " (" + object.getClass().getName() + ")", ex3);
            }
            catch (KryoException ex4) {
                ex4.addTrace(property + " (" + object.getClass().getName() + ")");
                throw ex4;
            }
            catch (Throwable t2) {
                KryoException ex5 = new KryoException(t2);
                ex5.addTrace(property + " (" + object.getClass().getName() + ")");
                throw ex5;
            }
        }
        return object;
    }

    @Override
    public T copy(Kryo kryo, T original) {
        Object copy = kryo.newInstance(original.getClass());
        for (CachedProperty property : this.properties) {
            try {
                Object value = property.get(original);
                property.set(copy, value);
            }
            catch (KryoException ex2) {
                ex2.addTrace(property + " (" + copy.getClass().getName() + ")");
                throw ex2;
            }
            catch (Exception ex3) {
                throw new KryoException("Error copying bean property: " + property + " (" + copy.getClass().getName() + ")", ex3);
            }
            catch (Throwable t2) {
                KryoException ex4 = new KryoException(t2);
                ex4.addTrace(property + " (" + copy.getClass().getName() + ")");
                throw ex4;
            }
        }
        return (T)copy;
    }

    class CachedProperty<X> {
        String name;
        Method getMethod;
        Method setMethod;
        Class setMethodType;
        Serializer serializer;
        int getterAccessIndex;
        int setterAccessIndex;

        CachedProperty() {
        }

        public String toString() {
            return this.name;
        }

        Object get(Object object) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                return ((MethodAccess)BeanSerializer.this.access).invoke(object, this.getterAccessIndex, new Object[0]);
            }
            return this.getMethod.invoke(object, noArgs);
        }

        void set(Object object, Object value) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                ((MethodAccess)BeanSerializer.this.access).invoke(object, this.setterAccessIndex, value);
                return;
            }
            this.setMethod.invoke(object, value);
        }
    }
}

