/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.InputChunked;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.io.OutputChunked;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.util.ObjectMap;
import com.esotericsoftware.kryo.kryo5.util.Util;

public class CompatibleFieldSerializer<T>
extends FieldSerializer<T> {
    private static final int binarySearchThreshold = 32;
    private final CompatibleFieldSerializerConfig config;

    public CompatibleFieldSerializer(Kryo kryo, Class type) {
        this(kryo, type, new CompatibleFieldSerializerConfig());
    }

    public CompatibleFieldSerializer(Kryo kryo, Class type, CompatibleFieldSerializerConfig config) {
        super(kryo, type, config);
        this.config = config;
    }

    @Override
    public void write(Kryo kryo, Output output2, T object) {
        Output fieldOutput;
        int pop = this.pushTypeVariables();
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        ObjectMap context = kryo.getGraphContext();
        if (!context.containsKey(this)) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write fields for class: " + this.type.getName());
            }
            context.put(this, null);
            output2.writeVarInt(fields.length, true);
            int n2 = fields.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write field name: " + fields[i2].name + Util.pos(output2.position()));
                }
                output2.writeString(fields[i2].name);
            }
        }
        boolean chunked2 = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownFieldData;
        OutputChunked outputChunked = null;
        if (chunked2) {
            outputChunked = new OutputChunked(output2, this.config.chunkSize);
            fieldOutput = outputChunked;
        } else {
            fieldOutput = output2;
        }
        for (FieldSerializer.CachedField cachedField : fields) {
            if (Log.TRACE) {
                this.log("Write", cachedField, output2.position());
            }
            if (readUnknownTagData) {
                Class<?> valueClass = null;
                try {
                    Object value;
                    if (object != null && (value = cachedField.field.get(object)) != null) {
                        valueClass = value.getClass();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                kryo.writeClass(fieldOutput, valueClass);
                if (valueClass == null) {
                    if (!chunked2) continue;
                    outputChunked.endChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
                cachedField.setReuseSerializer(false);
            }
            cachedField.write(fieldOutput, object);
            if (!chunked2) continue;
            outputChunked.endChunk();
        }
        this.popTypeVariables(pop);
    }

    @Override
    public T read(Kryo kryo, Input input2, Class<? extends T> type) {
        Input fieldInput;
        int pop = this.pushTypeVariables();
        T object = this.create(kryo, input2, type);
        kryo.reference(object);
        FieldSerializer.CachedField[] fields = (FieldSerializer.CachedField[])kryo.getGraphContext().get(this);
        if (fields == null) {
            fields = this.readFields(kryo, input2);
        }
        boolean chunked2 = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownFieldData;
        InputChunked inputChunked = null;
        if (chunked2) {
            inputChunked = new InputChunked(input2, this.config.chunkSize);
            fieldInput = inputChunked;
        } else {
            fieldInput = input2;
        }
        for (FieldSerializer.CachedField cachedField : fields) {
            if (readUnknownTagData) {
                String message;
                Registration registration;
                try {
                    registration = kryo.readClass(fieldInput);
                }
                catch (KryoException ex2) {
                    message = "Unable to read unknown data (unknown type). (" + this.getType().getName() + "#" + cachedField + ")";
                    if (!chunked2) {
                        throw new KryoException(message, ex2);
                    }
                    if (Log.DEBUG) {
                        Log.debug("kryo", message, ex2);
                    }
                    inputChunked.nextChunk();
                    continue;
                }
                if (registration == null) {
                    if (!chunked2) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                Class valueClass = registration.getType();
                if (cachedField == null) {
                    block23: {
                        if (Log.TRACE) {
                            Log.trace("kryo", "Read unknown data, type: " + Util.className(valueClass) + Util.pos(input2.position()));
                        }
                        try {
                            kryo.readObject(fieldInput, valueClass);
                        }
                        catch (KryoException ex3) {
                            String message2 = "Unable to read unknown data, type: " + Util.className(valueClass) + " (" + this.getType().getName() + "#" + cachedField + ")";
                            if (!chunked2) {
                                throw new KryoException(message2, ex3);
                            }
                            if (!Log.DEBUG) break block23;
                            Log.debug("kryo", message2, ex3);
                        }
                    }
                    if (!chunked2) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                if (cachedField.valueClass != null && !Util.isAssignableTo(valueClass, cachedField.field.getType())) {
                    message = "Read type is incompatible with the field type: " + Util.className(valueClass) + " -> " + Util.className(cachedField.valueClass) + " (" + this.getType().getName() + "#" + cachedField + ")";
                    if (!chunked2) {
                        throw new KryoException(message);
                    }
                    if (Log.DEBUG) {
                        Log.debug("kryo", message);
                    }
                    inputChunked.nextChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
                cachedField.setReuseSerializer(false);
            } else if (cachedField == null) {
                if (!chunked2) {
                    throw new KryoException("Unknown field. (" + this.getType().getName() + ")");
                }
                if (Log.TRACE) {
                    Log.trace("kryo", "Skip unknown field.");
                }
                inputChunked.nextChunk();
                continue;
            }
            if (Log.TRACE) {
                this.log("Read", cachedField, input2.position());
            }
            cachedField.read(fieldInput, object);
            if (!chunked2) continue;
            inputChunked.nextChunk();
        }
        this.popTypeVariables(pop);
        return object;
    }

    private FieldSerializer.CachedField[] readFields(Kryo kryo, Input input2) {
        if (Log.TRACE) {
            Log.trace("kryo", "Read fields for class: " + this.type.getName());
        }
        int length = input2.readVarInt(true);
        String[] names = new String[length];
        for (int i2 = 0; i2 < length; ++i2) {
            names[i2] = input2.readString();
            if (!Log.TRACE) continue;
            Log.trace("kryo", "Read field name: " + names[i2]);
        }
        FieldSerializer.CachedField[] fields = new FieldSerializer.CachedField[length];
        FieldSerializer.CachedField[] allFields = this.cachedFields.fields;
        if (length < 32) {
            block1: for (int i3 = 0; i3 < length; ++i3) {
                String schemaName = names[i3];
                int nn = allFields.length;
                for (int ii = 0; ii < nn; ++ii) {
                    if (!allFields[ii].name.equals(schemaName)) continue;
                    fields[i3] = allFields[ii];
                    continue block1;
                }
                if (!Log.TRACE) continue;
                Log.trace("kryo", "Unknown field will be skipped: " + schemaName);
            }
        } else {
            int lastFieldIndex = allFields.length - 1;
            block3: for (int i4 = 0; i4 < length; ++i4) {
                String schemaName = names[i4];
                int low = 0;
                int high = lastFieldIndex;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    int compare = schemaName.compareTo(allFields[mid].name);
                    if (compare < 0) {
                        high = mid - 1;
                        continue;
                    }
                    if (compare > 0) {
                        low = mid + 1;
                        continue;
                    }
                    fields[i4] = allFields[mid];
                    continue block3;
                }
                if (!Log.TRACE) continue;
                Log.trace("kryo", "Unknown field will be skipped: " + schemaName);
            }
        }
        kryo.getGraphContext().put(this, fields);
        return fields;
    }

    public CompatibleFieldSerializerConfig getCompatibleFieldSerializerConfig() {
        return this.config;
    }

    public static class CompatibleFieldSerializerConfig
    extends FieldSerializer.FieldSerializerConfig {
        boolean readUnknownFieldData = true;
        boolean chunked;
        int chunkSize = 1024;

        @Override
        public CompatibleFieldSerializerConfig clone() {
            return (CompatibleFieldSerializerConfig)super.clone();
        }

        public void setReadUnknownFieldData(boolean readUnknownTagData) {
            this.readUnknownFieldData = readUnknownTagData;
        }

        public boolean getReadUnknownTagData() {
            return this.readUnknownFieldData;
        }

        public void setChunkedEncoding(boolean chunked2) {
            this.chunked = chunked2;
            if (Log.TRACE) {
                Log.trace("kryo", "CompatibleFieldSerializerConfig setChunked: " + chunked2);
            }
        }

        public boolean getChunkedEncoding() {
            return this.chunked;
        }

        public void setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            if (Log.TRACE) {
                Log.trace("kryo", "CompatibleFieldSerializerConfig setChunkSize: " + chunkSize);
            }
        }

        public int getChunkSize() {
            return this.chunkSize;
        }
    }
}

