/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.KryoSerializable;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.ImmutableSerializer;
import com.esotericsoftware.kryo.kryo5.serializers.MapSerializer;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class DefaultSerializers {

    public static class AtomicReferenceSerializer
    extends Serializer<AtomicReference> {
        @Override
        public void write(Kryo kryo, Output output2, AtomicReference object) {
            kryo.writeClassAndObject(output2, object.get());
        }

        @Override
        public AtomicReference read(Kryo kryo, Input input2, Class<? extends AtomicReference> type) {
            Object value = kryo.readClassAndObject(input2);
            return new AtomicReference<Object>(value);
        }

        @Override
        public AtomicReference copy(Kryo kryo, AtomicReference original) {
            return new AtomicReference(kryo.copy(original.get()));
        }
    }

    public static class AtomicLongSerializer
    extends Serializer<AtomicLong> {
        @Override
        public void write(Kryo kryo, Output output2, AtomicLong object) {
            output2.writeLong(object.get());
        }

        @Override
        public AtomicLong read(Kryo kryo, Input input2, Class<? extends AtomicLong> type) {
            return new AtomicLong(input2.readLong());
        }

        @Override
        public AtomicLong copy(Kryo kryo, AtomicLong original) {
            return new AtomicLong(original.get());
        }
    }

    public static class AtomicIntegerSerializer
    extends Serializer<AtomicInteger> {
        @Override
        public void write(Kryo kryo, Output output2, AtomicInteger object) {
            output2.writeInt(object.get());
        }

        @Override
        public AtomicInteger read(Kryo kryo, Input input2, Class<? extends AtomicInteger> type) {
            return new AtomicInteger(input2.readInt());
        }

        @Override
        public AtomicInteger copy(Kryo kryo, AtomicInteger original) {
            return new AtomicInteger(original.get());
        }
    }

    public static class AtomicBooleanSerializer
    extends Serializer<AtomicBoolean> {
        @Override
        public void write(Kryo kryo, Output output2, AtomicBoolean object) {
            output2.writeBoolean(object.get());
        }

        @Override
        public AtomicBoolean read(Kryo kryo, Input input2, Class<? extends AtomicBoolean> type) {
            return new AtomicBoolean(input2.readBoolean());
        }

        @Override
        public AtomicBoolean copy(Kryo kryo, AtomicBoolean original) {
            return new AtomicBoolean(original.get());
        }
    }

    public static class UUIDSerializer
    extends ImmutableSerializer<UUID> {
        @Override
        public void write(Kryo kryo, Output output2, UUID uuid) {
            output2.writeLong(uuid.getMostSignificantBits());
            output2.writeLong(uuid.getLeastSignificantBits());
        }

        @Override
        public UUID read(Kryo kryo, Input input2, Class<? extends UUID> uuidClass) {
            return new UUID(input2.readLong(), input2.readLong());
        }
    }

    public static class URISerializer
    extends ImmutableSerializer<URI> {
        @Override
        public void write(Kryo kryo, Output output2, URI uri) {
            output2.writeString(uri.toString());
        }

        @Override
        public URI read(Kryo kryo, Input input2, Class<? extends URI> uriClass) {
            try {
                return new URI(input2.readString());
            }
            catch (URISyntaxException ex2) {
                throw new KryoException(ex2);
            }
        }
    }

    public static class PatternSerializer
    extends ImmutableSerializer<Pattern> {
        @Override
        public void write(Kryo kryo, Output output2, Pattern pattern) {
            output2.writeString(pattern.pattern());
            output2.writeInt(pattern.flags(), true);
        }

        @Override
        public Pattern read(Kryo kryo, Input input2, Class<? extends Pattern> patternClass) {
            String regex2 = input2.readString();
            int flags = input2.readInt(true);
            return Pattern.compile(regex2, flags);
        }
    }

    public static class BitSetSerializer
    extends Serializer<BitSet> {
        @Override
        public void write(Kryo kryo, Output output2, BitSet set2) {
            long[] values = set2.toLongArray();
            output2.writeVarInt(values.length, true);
            output2.writeLongs(values, 0, values.length);
        }

        @Override
        public BitSet read(Kryo kryo, Input input2, Class type) {
            int length = input2.readVarInt(true);
            long[] values = input2.readLongs(length);
            return BitSet.valueOf(values);
        }

        @Override
        public BitSet copy(Kryo kryo, BitSet original) {
            return BitSet.valueOf(original.toLongArray());
        }
    }

    public static class ArraysAsListSerializer
    extends CollectionSerializer<List> {
        @Override
        protected List create(Kryo kryo, Input input2, Class type, int size) {
            return new ArrayList(size);
        }

        @Override
        public List read(Kryo kryo, Input input2, Class type) {
            List list = (List)super.read(kryo, input2, type);
            if (list == null) {
                return null;
            }
            return Arrays.asList(list.toArray());
        }

        @Override
        public List copy(Kryo kryo, List original) {
            Object[] copyArr = new Object[original.size()];
            List<Object> copy = Arrays.asList(copyArr);
            kryo.reference(copy);
            for (int i2 = 0; i2 < original.size(); ++i2) {
                copyArr[i2] = kryo.copy(original.get(i2));
            }
            return copy;
        }
    }

    public static class URLSerializer
    extends ImmutableSerializer<URL> {
        @Override
        public void write(Kryo kryo, Output output2, URL object) {
            output2.writeString(object.toExternalForm());
        }

        @Override
        public URL read(Kryo kryo, Input input2, Class<? extends URL> type) {
            try {
                return new URL(input2.readString());
            }
            catch (MalformedURLException ex2) {
                throw new KryoException(ex2);
            }
        }
    }

    public static class CharsetSerializer
    extends ImmutableSerializer<Charset> {
        @Override
        public void write(Kryo kryo, Output output2, Charset object) {
            output2.writeString(object.name());
        }

        @Override
        public Charset read(Kryo kryo, Input input2, Class<? extends Charset> type) {
            return Charset.forName(input2.readString());
        }
    }

    public static class LocaleSerializer
    extends ImmutableSerializer<Locale> {
        public static final Locale SPANISH = new Locale("es", "", "");
        public static final Locale SPAIN = new Locale("es", "ES", "");

        protected Locale create(String language, String country, String variant) {
            Locale defaultLocale = Locale.getDefault();
            if (LocaleSerializer.isSameLocale(defaultLocale, language, country, variant)) {
                return defaultLocale;
            }
            if (defaultLocale != Locale.US && LocaleSerializer.isSameLocale(Locale.US, language, country, variant)) {
                return Locale.US;
            }
            if (LocaleSerializer.isSameLocale(Locale.ENGLISH, language, country, variant)) {
                return Locale.ENGLISH;
            }
            if (LocaleSerializer.isSameLocale(Locale.GERMAN, language, country, variant)) {
                return Locale.GERMAN;
            }
            if (LocaleSerializer.isSameLocale(SPANISH, language, country, variant)) {
                return SPANISH;
            }
            if (LocaleSerializer.isSameLocale(Locale.FRENCH, language, country, variant)) {
                return Locale.FRENCH;
            }
            if (LocaleSerializer.isSameLocale(Locale.ITALIAN, language, country, variant)) {
                return Locale.ITALIAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.JAPANESE, language, country, variant)) {
                return Locale.JAPANESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.KOREAN, language, country, variant)) {
                return Locale.KOREAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.SIMPLIFIED_CHINESE, language, country, variant)) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.CHINESE, language, country, variant)) {
                return Locale.CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.TRADITIONAL_CHINESE, language, country, variant)) {
                return Locale.TRADITIONAL_CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.UK, language, country, variant)) {
                return Locale.UK;
            }
            if (LocaleSerializer.isSameLocale(Locale.GERMANY, language, country, variant)) {
                return Locale.GERMANY;
            }
            if (LocaleSerializer.isSameLocale(SPAIN, language, country, variant)) {
                return SPAIN;
            }
            if (LocaleSerializer.isSameLocale(Locale.FRANCE, language, country, variant)) {
                return Locale.FRANCE;
            }
            if (LocaleSerializer.isSameLocale(Locale.ITALY, language, country, variant)) {
                return Locale.ITALY;
            }
            if (LocaleSerializer.isSameLocale(Locale.JAPAN, language, country, variant)) {
                return Locale.JAPAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.KOREA, language, country, variant)) {
                return Locale.KOREA;
            }
            if (LocaleSerializer.isSameLocale(Locale.CANADA, language, country, variant)) {
                return Locale.CANADA;
            }
            if (LocaleSerializer.isSameLocale(Locale.CANADA_FRENCH, language, country, variant)) {
                return Locale.CANADA_FRENCH;
            }
            return new Locale(language, country, variant);
        }

        @Override
        public void write(Kryo kryo, Output output2, Locale l2) {
            output2.writeAscii(l2.getLanguage());
            output2.writeAscii(l2.getCountry());
            output2.writeString(l2.getVariant());
        }

        @Override
        public Locale read(Kryo kryo, Input input2, Class<? extends Locale> type) {
            String language = input2.readString();
            String country = input2.readString();
            String variant = input2.readString();
            return this.create(language, country, variant);
        }

        protected static boolean isSameLocale(Locale locale, String language, String country, String variant) {
            return locale.getLanguage().equals(language) && locale.getCountry().equals(country) && locale.getVariant().equals(variant);
        }
    }

    public static class PriorityQueueSerializer
    extends CollectionSerializer<PriorityQueue> {
        @Override
        protected void writeHeader(Kryo kryo, Output output2, PriorityQueue queue) {
            kryo.writeClassAndObject(output2, queue.comparator());
        }

        @Override
        protected PriorityQueue create(Kryo kryo, Input input2, Class<? extends PriorityQueue> type, int size) {
            return this.createPriorityQueue(type, size, (Comparator)kryo.readClassAndObject(input2));
        }

        @Override
        protected PriorityQueue createCopy(Kryo kryo, PriorityQueue original) {
            return this.createPriorityQueue(original.getClass(), original.size(), original.comparator());
        }

        private PriorityQueue createPriorityQueue(Class<? extends Collection> type, int size, Comparator comparator) {
            int initialCapacity = Math.max(size, 1);
            if (type == PriorityQueue.class || type == null) {
                return new PriorityQueue(initialCapacity, comparator);
            }
            try {
                Constructor<? extends Collection> constructor = type.getConstructor(Integer.TYPE, Comparator.class);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return (PriorityQueue)constructor.newInstance(initialCapacity, comparator);
            }
            catch (Exception ex2) {
                throw new KryoException(ex2);
            }
        }
    }

    public static class TreeSetSerializer
    extends CollectionSerializer<TreeSet> {
        @Override
        protected void writeHeader(Kryo kryo, Output output2, TreeSet treeSet) {
            kryo.writeClassAndObject(output2, treeSet.comparator());
        }

        @Override
        protected TreeSet create(Kryo kryo, Input input2, Class<? extends TreeSet> type, int size) {
            return this.createTreeSet(type, (Comparator)kryo.readClassAndObject(input2));
        }

        @Override
        protected TreeSet createCopy(Kryo kryo, TreeSet original) {
            return this.createTreeSet(original.getClass(), original.comparator());
        }

        private TreeSet createTreeSet(Class<? extends Collection> type, Comparator comparator) {
            if (type == TreeSet.class || type == null) {
                return new TreeSet(comparator);
            }
            try {
                Constructor<? extends Collection> constructor = type.getConstructor(Comparator.class);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return (TreeSet)constructor.newInstance(comparator);
            }
            catch (Exception ex2) {
                throw new KryoException(ex2);
            }
        }
    }

    public static class ConcurrentSkipListMapSerializer
    extends MapSerializer<ConcurrentSkipListMap> {
        @Override
        protected void writeHeader(Kryo kryo, Output output2, ConcurrentSkipListMap concurrentSkipListMap) {
            kryo.writeClassAndObject(output2, concurrentSkipListMap.comparator());
        }

        @Override
        protected ConcurrentSkipListMap create(Kryo kryo, Input input2, Class<? extends ConcurrentSkipListMap> type, int size) {
            return this.createConcurrentSkipListMap(type, (Comparator)kryo.readClassAndObject(input2));
        }

        @Override
        protected ConcurrentSkipListMap createCopy(Kryo kryo, ConcurrentSkipListMap original) {
            return this.createConcurrentSkipListMap(original.getClass(), original.comparator());
        }

        private ConcurrentSkipListMap createConcurrentSkipListMap(Class<? extends ConcurrentSkipListMap> type, Comparator comparator) {
            if (type == ConcurrentSkipListMap.class || type == null) {
                return new ConcurrentSkipListMap(comparator);
            }
            try {
                Constructor<? extends ConcurrentSkipListMap> constructor = type.getConstructor(Comparator.class);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return constructor.newInstance(comparator);
            }
            catch (Exception ex2) {
                throw new KryoException(ex2);
            }
        }
    }

    public static class TreeMapSerializer
    extends MapSerializer<TreeMap> {
        @Override
        protected void writeHeader(Kryo kryo, Output output2, TreeMap treeSet) {
            kryo.writeClassAndObject(output2, treeSet.comparator());
        }

        @Override
        protected TreeMap create(Kryo kryo, Input input2, Class<? extends TreeMap> type, int size) {
            return this.createTreeMap(type, (Comparator)kryo.readClassAndObject(input2));
        }

        @Override
        protected TreeMap createCopy(Kryo kryo, TreeMap original) {
            return this.createTreeMap(original.getClass(), original.comparator());
        }

        private TreeMap createTreeMap(Class<? extends TreeMap> type, Comparator comparator) {
            if (type == TreeMap.class || type == null) {
                return new TreeMap(comparator);
            }
            try {
                Constructor<? extends TreeMap> constructor = type.getConstructor(Comparator.class);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return constructor.newInstance(comparator);
            }
            catch (Exception ex2) {
                throw new KryoException(ex2);
            }
        }
    }

    public static class CalendarSerializer
    extends Serializer<Calendar> {
        private static final long DEFAULT_GREGORIAN_CUTOVER = -12219292800000L;
        TimeZoneSerializer timeZoneSerializer = new TimeZoneSerializer();

        @Override
        public void write(Kryo kryo, Output output2, Calendar object) {
            this.timeZoneSerializer.write(kryo, output2, object.getTimeZone());
            output2.writeVarLong(object.getTimeInMillis(), true);
            output2.writeBoolean(object.isLenient());
            output2.writeInt(object.getFirstDayOfWeek(), true);
            output2.writeInt(object.getMinimalDaysInFirstWeek(), true);
            if (object instanceof GregorianCalendar) {
                output2.writeVarLong(((GregorianCalendar)object).getGregorianChange().getTime(), false);
            } else {
                output2.writeVarLong(-12219292800000L, false);
            }
        }

        @Override
        public Calendar read(Kryo kryo, Input input2, Class<? extends Calendar> type) {
            Calendar result2 = Calendar.getInstance((TimeZone)this.timeZoneSerializer.read(kryo, input2, TimeZone.class));
            result2.setTimeInMillis(input2.readVarLong(true));
            result2.setLenient(input2.readBoolean());
            result2.setFirstDayOfWeek(input2.readInt(true));
            result2.setMinimalDaysInFirstWeek(input2.readInt(true));
            long gregorianChange = input2.readVarLong(false);
            if (gregorianChange != -12219292800000L && result2 instanceof GregorianCalendar) {
                ((GregorianCalendar)result2).setGregorianChange(new Date(gregorianChange));
            }
            return result2;
        }

        @Override
        public Calendar copy(Kryo kryo, Calendar original) {
            return (Calendar)original.clone();
        }
    }

    public static class TimeZoneSerializer
    extends ImmutableSerializer<TimeZone> {
        @Override
        public void write(Kryo kryo, Output output2, TimeZone object) {
            output2.writeString(object.getID());
        }

        @Override
        public TimeZone read(Kryo kryo, Input input2, Class<? extends TimeZone> type) {
            return TimeZone.getTimeZone(input2.readString());
        }
    }

    public static class CollectionsSingletonSetSerializer
    extends Serializer<Set> {
        @Override
        public void write(Kryo kryo, Output output2, Set object) {
            kryo.writeClassAndObject(output2, object.iterator().next());
        }

        @Override
        public Set read(Kryo kryo, Input input2, Class<? extends Set> type) {
            return Collections.singleton(kryo.readClassAndObject(input2));
        }

        @Override
        public Set copy(Kryo kryo, Set original) {
            return Collections.singleton(kryo.copy(original.iterator().next()));
        }
    }

    public static class CollectionsSingletonMapSerializer
    extends Serializer<Map> {
        @Override
        public void write(Kryo kryo, Output output2, Map object) {
            Map.Entry entry = object.entrySet().iterator().next();
            kryo.writeClassAndObject(output2, entry.getKey());
            kryo.writeClassAndObject(output2, entry.getValue());
        }

        @Override
        public Map read(Kryo kryo, Input input2, Class<? extends Map> type) {
            Object key = kryo.readClassAndObject(input2);
            Object value = kryo.readClassAndObject(input2);
            return Collections.singletonMap(key, value);
        }

        @Override
        public Map copy(Kryo kryo, Map original) {
            Map.Entry entry = original.entrySet().iterator().next();
            return Collections.singletonMap(kryo.copy(entry.getKey()), kryo.copy(entry.getValue()));
        }
    }

    public static class CollectionsSingletonListSerializer
    extends Serializer<List> {
        @Override
        public void write(Kryo kryo, Output output2, List object) {
            kryo.writeClassAndObject(output2, object.get(0));
        }

        @Override
        public List read(Kryo kryo, Input input2, Class<? extends List> type) {
            return Collections.singletonList(kryo.readClassAndObject(input2));
        }

        @Override
        public List copy(Kryo kryo, List original) {
            return Collections.singletonList(kryo.copy(original.get(0)));
        }
    }

    public static class CollectionsEmptySetSerializer
    extends ImmutableSerializer<Set> {
        @Override
        public void write(Kryo kryo, Output output2, Set object) {
        }

        @Override
        public Set read(Kryo kryo, Input input2, Class<? extends Set> type) {
            return Collections.EMPTY_SET;
        }
    }

    public static class CollectionsEmptyMapSerializer
    extends ImmutableSerializer<Map> {
        @Override
        public void write(Kryo kryo, Output output2, Map object) {
        }

        @Override
        public Map read(Kryo kryo, Input input2, Class<? extends Map> type) {
            return Collections.EMPTY_MAP;
        }
    }

    public static class CollectionsEmptyListSerializer
    extends ImmutableSerializer<Collection> {
        @Override
        public void write(Kryo kryo, Output output2, Collection object) {
        }

        @Override
        public Collection read(Kryo kryo, Input input2, Class<? extends Collection> type) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class KryoSerializableSerializer
    extends Serializer<KryoSerializable> {
        @Override
        public void write(Kryo kryo, Output output2, KryoSerializable object) {
            object.write(kryo, output2);
        }

        @Override
        public KryoSerializable read(Kryo kryo, Input input2, Class<? extends KryoSerializable> type) {
            KryoSerializable object = kryo.newInstance(type);
            kryo.reference(object);
            object.read(kryo, input2);
            return object;
        }
    }

    public static class StringBuilderSerializer
    extends Serializer<StringBuilder> {
        public StringBuilderSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output2, StringBuilder object) {
            output2.writeString(object == null ? null : object.toString());
        }

        @Override
        public StringBuilder read(Kryo kryo, Input input2, Class<? extends StringBuilder> type) {
            return input2.readStringBuilder();
        }

        @Override
        public StringBuilder copy(Kryo kryo, StringBuilder original) {
            return new StringBuilder(original);
        }
    }

    public static class StringBufferSerializer
    extends Serializer<StringBuffer> {
        public StringBufferSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output2, StringBuffer object) {
            output2.writeString(object == null ? null : object.toString());
        }

        @Override
        public StringBuffer read(Kryo kryo, Input input2, Class<? extends StringBuffer> type) {
            String value = input2.readString();
            if (value == null) {
                return null;
            }
            return new StringBuffer(value);
        }

        @Override
        public StringBuffer copy(Kryo kryo, StringBuffer original) {
            return new StringBuffer(original);
        }
    }

    public static class CurrencySerializer
    extends ImmutableSerializer<Currency> {
        public CurrencySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output2, Currency object) {
            output2.writeString(object == null ? null : object.getCurrencyCode());
        }

        @Override
        public Currency read(Kryo kryo, Input input2, Class<? extends Currency> type) {
            String currencyCode = input2.readString();
            if (currencyCode == null) {
                return null;
            }
            return Currency.getInstance(currencyCode);
        }
    }

    public static class EnumSetSerializer
    extends Serializer<EnumSet> {
        @Override
        public void write(Kryo kryo, Output output2, EnumSet object) {
            Serializer serializer2;
            if (object.isEmpty()) {
                EnumSet tmp = EnumSet.complementOf(object);
                if (tmp.isEmpty()) {
                    throw new KryoException("An EnumSet must have a defined Enum to be serialized.");
                }
                serializer2 = kryo.writeClass(output2, tmp.iterator().next().getClass()).getSerializer();
            } else {
                serializer2 = kryo.writeClass(output2, object.iterator().next().getClass()).getSerializer();
            }
            output2.writeVarInt(object.size(), true);
            for (Object element : object) {
                serializer2.write(kryo, output2, element);
            }
        }

        @Override
        public EnumSet read(Kryo kryo, Input input2, Class<? extends EnumSet> type) {
            Registration registration = kryo.readClass(input2);
            EnumSet object = EnumSet.noneOf(registration.getType());
            Serializer serializer2 = registration.getSerializer();
            int length = input2.readVarInt(true);
            for (int i2 = 0; i2 < length; ++i2) {
                object.add(serializer2.read(kryo, input2, null));
            }
            return object;
        }

        @Override
        public EnumSet copy(Kryo kryo, EnumSet original) {
            return EnumSet.copyOf(original);
        }
    }

    public static class EnumSerializer
    extends ImmutableSerializer<Enum> {
        private Object[] enumConstants;

        public EnumSerializer(Class<? extends Enum> type) {
            this.setAcceptsNull(true);
            this.enumConstants = type.getEnumConstants();
            if (this.enumConstants == null && !Enum.class.equals(type)) {
                throw new IllegalArgumentException("The type must be an enum: " + type);
            }
        }

        @Override
        public void write(Kryo kryo, Output output2, Enum object) {
            if (object == null) {
                output2.writeVarInt(0, true);
                return;
            }
            output2.writeVarInt(object.ordinal() + 1, true);
        }

        @Override
        public Enum read(Kryo kryo, Input input2, Class<? extends Enum> type) {
            int ordinal = input2.readVarInt(true);
            if (ordinal == 0) {
                return null;
            }
            if (--ordinal < 0 || ordinal > this.enumConstants.length - 1) {
                throw new KryoException("Invalid ordinal for enum \"" + type.getName() + "\": " + ordinal);
            }
            Object constant = this.enumConstants[ordinal];
            return (Enum)constant;
        }
    }

    public static class TimestampSerializer
    extends Serializer<Timestamp> {
        @Override
        public void write(Kryo kryo, Output output2, Timestamp object) {
            output2.writeVarLong(this.integralTimeComponent(object), true);
            output2.writeVarInt(object.getNanos(), true);
        }

        @Override
        public Timestamp read(Kryo kryo, Input input2, Class<? extends Timestamp> type) {
            return this.create(input2.readVarLong(true), input2.readVarInt(true));
        }

        @Override
        public Timestamp copy(Kryo kryo, Timestamp original) {
            return this.create(this.integralTimeComponent(original), original.getNanos());
        }

        private long integralTimeComponent(Timestamp object) {
            return object.getTime() - (long)(object.getNanos() / 1000000);
        }

        private Timestamp create(long time2, int nanos) {
            Timestamp t2 = new Timestamp(time2);
            t2.setNanos(nanos);
            return t2;
        }
    }

    public static class DateSerializer
    extends Serializer<Date> {
        private Date create(Kryo kryo, Class<? extends Date> type, long time2) throws KryoException {
            if (type == Date.class || type == null) {
                return new Date(time2);
            }
            if (type == Timestamp.class) {
                return new Timestamp(time2);
            }
            if (type == java.sql.Date.class) {
                return new java.sql.Date(time2);
            }
            if (type == Time.class) {
                return new Time(time2);
            }
            try {
                Constructor<? extends Date> constructor = type.getConstructor(Long.TYPE);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return constructor.newInstance(time2);
            }
            catch (Exception ex2) {
                Date d2 = kryo.newInstance(type);
                d2.setTime(time2);
                return d2;
            }
        }

        @Override
        public void write(Kryo kryo, Output output2, Date object) {
            output2.writeVarLong(object.getTime(), true);
        }

        @Override
        public Date read(Kryo kryo, Input input2, Class<? extends Date> type) {
            return this.create(kryo, type, input2.readVarLong(true));
        }

        @Override
        public Date copy(Kryo kryo, Date original) {
            return this.create(kryo, original.getClass(), original.getTime());
        }
    }

    public static class ClassSerializer
    extends ImmutableSerializer<Class> {
        public ClassSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output2, Class type) {
            kryo.writeClass(output2, type);
            if (type != null && (type.isPrimitive() || Util.isWrapperClass(type))) {
                output2.writeBoolean(type.isPrimitive());
            }
        }

        @Override
        public Class read(Kryo kryo, Input input2, Class<? extends Class> ignored) {
            Registration registration = kryo.readClass(input2);
            if (registration == null) {
                return null;
            }
            Class type = registration.getType();
            if (!type.isPrimitive() || input2.readBoolean()) {
                return type;
            }
            return Util.getWrapperClass(type);
        }
    }

    public static class BigDecimalSerializer
    extends ImmutableSerializer<BigDecimal> {
        public BigDecimalSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output2, BigDecimal object) {
            boolean compactForm;
            if (object == null) {
                output2.writeByte((byte)0);
                return;
            }
            if (object == BigDecimal.ZERO) {
                output2.writeVarInt(2, true);
                output2.writeByte((byte)0);
                output2.writeInt(0, false);
                return;
            }
            if (object == BigDecimal.ONE) {
                output2.writeVarInt(2, true);
                output2.writeByte((byte)1);
                output2.writeInt(0, false);
                return;
            }
            BigInteger unscaledBig = null;
            boolean bl2 = compactForm = object.precision() < 19;
            if (!compactForm) {
                unscaledBig = object.unscaledValue();
                boolean bl3 = compactForm = unscaledBig.bitLength() <= 63;
            }
            if (!compactForm) {
                byte[] bytes = unscaledBig.toByteArray();
                output2.writeVarInt(bytes.length + 1, true);
                output2.writeBytes(bytes);
            } else {
                long unscaledLong = object.scaleByPowerOfTen(object.scale()).longValue();
                BigDecimalSerializer.writeUnscaledLong(output2, unscaledLong);
            }
            output2.writeInt(object.scale(), false);
        }

        private static void writeUnscaledLong(Output output2, long unscaledLong) {
            int insignificantBits = unscaledLong >= 0L ? Long.numberOfLeadingZeros(unscaledLong) : Long.numberOfLeadingZeros(unscaledLong ^ 0xFFFFFFFFFFFFFFFFL);
            int significantBits = 64 - insignificantBits + 1;
            int length = significantBits + 7 >> 3;
            output2.writeByte(length + 1);
            output2.writeLong(unscaledLong, length);
        }

        @Override
        public BigDecimal read(Kryo kryo, Input input2, Class<? extends BigDecimal> type) {
            BigInteger unscaledBig = null;
            long unscaledLong = 0L;
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            if (--length > 8) {
                byte[] bytes = input2.readBytes(length);
                unscaledBig = new BigInteger(bytes);
            } else {
                unscaledLong = input2.readLong(length);
            }
            int scale = input2.readInt(false);
            if (type != BigDecimal.class && type != null) {
                return BigDecimalSerializer.newBigDecimalSubclass(type, unscaledBig != null ? unscaledBig : BigInteger.valueOf(unscaledLong), scale);
            }
            if (unscaledBig != null) {
                return new BigDecimal(unscaledBig, scale);
            }
            if (scale == 0) {
                if (unscaledLong == 0L) {
                    return BigDecimal.ZERO;
                }
                if (unscaledLong == 1L) {
                    return BigDecimal.ONE;
                }
            }
            return BigDecimal.valueOf(unscaledLong, scale);
        }

        private static BigDecimal newBigDecimalSubclass(Class<? extends BigDecimal> type, BigInteger unscaledValue, int scale) {
            try {
                Constructor<? extends BigDecimal> constructor = type.getConstructor(BigInteger.class, Integer.TYPE);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return constructor.newInstance(unscaledValue, scale);
            }
            catch (Exception ex2) {
                throw new KryoException(ex2);
            }
        }
    }

    public static class BigIntegerSerializer
    extends ImmutableSerializer<BigInteger> {
        public BigIntegerSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output2, BigInteger object) {
            if (object == null) {
                output2.writeByte((byte)0);
                return;
            }
            if (object == BigInteger.ZERO) {
                output2.writeByte(2);
                output2.writeByte(0);
                return;
            }
            byte[] bytes = object.toByteArray();
            output2.writeVarInt(bytes.length + 1, true);
            output2.writeBytes(bytes);
        }

        @Override
        public BigInteger read(Kryo kryo, Input input2, Class<? extends BigInteger> type) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            byte[] bytes = input2.readBytes(length - 1);
            if (type != BigInteger.class && type != null) {
                return BigIntegerSerializer.newBigIntegerSubclass(type, bytes);
            }
            if (length == 2) {
                switch (bytes[0]) {
                    case 0: {
                        return BigInteger.ZERO;
                    }
                    case 1: {
                        return BigInteger.ONE;
                    }
                    case 10: {
                        return BigInteger.TEN;
                    }
                }
            }
            return new BigInteger(bytes);
        }

        private static BigInteger newBigIntegerSubclass(Class<? extends BigInteger> type, byte[] bytes) {
            try {
                Constructor<? extends BigInteger> constructor = type.getConstructor(byte[].class);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return constructor.newInstance(new Object[]{bytes});
            }
            catch (Exception ex2) {
                throw new KryoException(ex2);
            }
        }
    }

    public static class StringSerializer
    extends ImmutableSerializer<String> {
        public StringSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output2, String object) {
            output2.writeString(object);
        }

        @Override
        public String read(Kryo kryo, Input input2, Class<? extends String> type) {
            return input2.readString();
        }
    }

    public static class DoubleSerializer
    extends ImmutableSerializer<Double> {
        @Override
        public void write(Kryo kryo, Output output2, Double object) {
            output2.writeDouble(object);
        }

        @Override
        public Double read(Kryo kryo, Input input2, Class<? extends Double> type) {
            return input2.readDouble();
        }
    }

    public static class FloatSerializer
    extends ImmutableSerializer<Float> {
        @Override
        public void write(Kryo kryo, Output output2, Float object) {
            output2.writeFloat(object.floatValue());
        }

        @Override
        public Float read(Kryo kryo, Input input2, Class<? extends Float> type) {
            return Float.valueOf(input2.readFloat());
        }
    }

    public static class LongSerializer
    extends ImmutableSerializer<Long> {
        @Override
        public void write(Kryo kryo, Output output2, Long object) {
            output2.writeVarLong(object, false);
        }

        @Override
        public Long read(Kryo kryo, Input input2, Class<? extends Long> type) {
            return input2.readVarLong(false);
        }
    }

    public static class IntSerializer
    extends ImmutableSerializer<Integer> {
        @Override
        public void write(Kryo kryo, Output output2, Integer object) {
            output2.writeInt((int)object, false);
        }

        @Override
        public Integer read(Kryo kryo, Input input2, Class<? extends Integer> type) {
            return input2.readInt(false);
        }
    }

    public static class ShortSerializer
    extends ImmutableSerializer<Short> {
        @Override
        public void write(Kryo kryo, Output output2, Short object) {
            output2.writeShort(object.shortValue());
        }

        @Override
        public Short read(Kryo kryo, Input input2, Class<? extends Short> type) {
            return input2.readShort();
        }
    }

    public static class CharSerializer
    extends ImmutableSerializer<Character> {
        @Override
        public void write(Kryo kryo, Output output2, Character object) {
            output2.writeChar(object.charValue());
        }

        @Override
        public Character read(Kryo kryo, Input input2, Class<? extends Character> type) {
            return Character.valueOf(input2.readChar());
        }
    }

    public static class ByteSerializer
    extends ImmutableSerializer<Byte> {
        @Override
        public void write(Kryo kryo, Output output2, Byte object) {
            output2.writeByte(object);
        }

        @Override
        public Byte read(Kryo kryo, Input input2, Class<? extends Byte> type) {
            return input2.readByte();
        }
    }

    public static class BooleanSerializer
    extends ImmutableSerializer<Boolean> {
        @Override
        public void write(Kryo kryo, Output output2, Boolean object) {
            output2.writeBoolean(object);
        }

        @Override
        public Boolean read(Kryo kryo, Input input2, Class<? extends Boolean> type) {
            return input2.readBoolean();
        }
    }

    public static class VoidSerializer
    extends ImmutableSerializer {
        @Override
        public void write(Kryo kryo, Output output2, Object object) {
        }

        @Override
        public Object read(Kryo kryo, Input input2, Class type) {
            return null;
        }
    }
}

