/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.KryoObjectInput;
import com.esotericsoftware.kryo.kryo5.io.KryoObjectOutput;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.JavaSerializer;
import com.esotericsoftware.kryo.kryo5.util.ObjectMap;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;

public class ExternalizableSerializer
extends Serializer {
    private ObjectMap<Class, JavaSerializer> javaSerializerByType;
    private KryoObjectInput objectInput = null;
    private KryoObjectOutput objectOutput = null;

    public void write(Kryo kryo, Output output2, Object object) {
        JavaSerializer serializer2 = this.getJavaSerializerIfRequired(object.getClass());
        if (serializer2 == null) {
            this.writeExternal(kryo, output2, object);
        } else {
            serializer2.write(kryo, output2, object);
        }
    }

    public Object read(Kryo kryo, Input input2, Class type) {
        JavaSerializer serializer2 = this.getJavaSerializerIfRequired(type);
        if (serializer2 == null) {
            return this.readExternal(kryo, input2, type);
        }
        return serializer2.read(kryo, input2, type);
    }

    private void writeExternal(Kryo kryo, Output output2, Object object) {
        try {
            ((Externalizable)object).writeExternal(this.getObjectOutput(kryo, output2));
        }
        catch (Exception ex2) {
            throw new KryoException(ex2);
        }
    }

    private Object readExternal(Kryo kryo, Input input2, Class type) {
        try {
            Externalizable object = (Externalizable)kryo.newInstance(type);
            object.readExternal(this.getObjectInput(kryo, input2));
            return object;
        }
        catch (Exception ex2) {
            throw new KryoException(ex2);
        }
    }

    private ObjectOutput getObjectOutput(Kryo kryo, Output output2) {
        if (this.objectOutput == null) {
            this.objectOutput = new KryoObjectOutput(kryo, output2);
        } else {
            this.objectOutput.setOutput(output2);
        }
        return this.objectOutput;
    }

    private ObjectInput getObjectInput(Kryo kryo, Input input2) {
        if (this.objectInput == null) {
            this.objectInput = new KryoObjectInput(kryo, input2);
        } else {
            this.objectInput.setInput(input2);
        }
        return this.objectInput;
    }

    private JavaSerializer getJavaSerializerIfRequired(Class type) {
        JavaSerializer javaSerializer = this.getCachedSerializer(type);
        if (javaSerializer == null && this.isJavaSerializerRequired(type)) {
            javaSerializer = new JavaSerializer();
        }
        return javaSerializer;
    }

    private JavaSerializer getCachedSerializer(Class type) {
        if (this.javaSerializerByType == null) {
            this.javaSerializerByType = new ObjectMap();
            return null;
        }
        return this.javaSerializerByType.get(type);
    }

    private boolean isJavaSerializerRequired(Class type) {
        return ExternalizableSerializer.hasInheritableReplaceMethod(type, "writeReplace") || ExternalizableSerializer.hasInheritableReplaceMethod(type, "readResolve");
    }

    private static boolean hasInheritableReplaceMethod(Class type, String methodName) {
        Method method = null;
        for (Class current = type; current != null; current = current.getSuperclass()) {
            try {
                method = current.getDeclaredMethod(methodName, new Class[0]);
                break;
            }
            catch (NoSuchMethodException ex2) {
                continue;
            }
        }
        return method != null && method.getReturnType() == Object.class;
    }
}

