/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.serializers.ImmutableSerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;

public class RecordSerializer<T>
extends ImmutableSerializer<T> {
    private static final Method IS_RECORD;
    private static final Method GET_RECORD_COMPONENTS;
    private static final Method GET_NAME;
    private static final Method GET_TYPE;
    private static final ClassValue<Constructor<?>> CONSTRUCTOR;
    private static final ClassValue<RecordComponent[]> RECORD_COMPONENTS;
    private boolean fixedFieldTypes = false;

    @Deprecated(forRemoval=true)
    public RecordSerializer() {
    }

    public RecordSerializer(Class<T> clazz) {
        if (!this.isRecord(clazz)) {
            throw new KryoException(clazz + " is not a record");
        }
    }

    @Override
    public void write(Kryo kryo, Output output2, T object) {
        for (RecordComponent rc : RECORD_COMPONENTS.get(object.getClass())) {
            Class<?> type = rc.type();
            String name = rc.name();
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write property: " + name + " (" + type.getName() + ")");
                }
                if (type.isPrimitive()) {
                    kryo.writeObject(output2, rc.getValue(object));
                    continue;
                }
                if (this.fixedFieldTypes || kryo.isFinal(type)) {
                    kryo.writeObjectOrNull(output2, rc.getValue(object), type);
                    continue;
                }
                kryo.writeClassAndObject(output2, rc.getValue(object));
            }
            catch (KryoException ex2) {
                ex2.addTrace(name + " (" + type.getName() + ")");
                throw ex2;
            }
            catch (Throwable t2) {
                KryoException ex3 = new KryoException(t2);
                ex3.addTrace(name + " (" + type.getName() + ")");
                throw ex3;
            }
        }
    }

    @Override
    public T read(Kryo kryo, Input input2, Class<? extends T> type) {
        RecordComponent[] components = RECORD_COMPONENTS.get(type);
        Object[] values = new Object[components.length];
        for (int i2 = 0; i2 < components.length; ++i2) {
            RecordComponent rc = components[i2];
            String name = rc.name();
            Class<?> rcType = rc.type();
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Read property: " + name + " (" + type.getName() + ")");
                }
                if (rcType.isPrimitive()) {
                    values[rc.index()] = kryo.readObject(input2, rcType);
                    continue;
                }
                if (this.fixedFieldTypes || kryo.isFinal(rcType)) {
                    values[rc.index()] = kryo.readObjectOrNull(input2, rcType);
                    continue;
                }
                values[rc.index()] = kryo.readClassAndObject(input2);
                continue;
            }
            catch (KryoException ex2) {
                ex2.addTrace(name + " (" + type.getName() + ")");
                throw ex2;
            }
            catch (Throwable t2) {
                KryoException ex3 = new KryoException(t2);
                ex3.addTrace(name + " (" + type.getName() + ")");
                throw ex3;
            }
        }
        return this.invokeCanonicalConstructor(type, values);
    }

    private boolean isRecord(Class<?> type) {
        try {
            return (Boolean)IS_RECORD.invoke(type, new Object[0]);
        }
        catch (Throwable t2) {
            throw new KryoException("Could not determine type (" + type + ")");
        }
    }

    private static <T> RecordComponent[] recordComponents(Class<T> type, Comparator<RecordComponent> comparator) {
        try {
            Object[] rawComponents = (Object[])GET_RECORD_COMPONENTS.invoke(type, new Object[0]);
            RecordComponent[] recordComponents = new RecordComponent[rawComponents.length];
            for (int i2 = 0; i2 < rawComponents.length; ++i2) {
                Object comp = rawComponents[i2];
                recordComponents[i2] = new RecordComponent(type, (String)GET_NAME.invoke(comp, new Object[0]), (Class)GET_TYPE.invoke(comp, new Object[0]), i2);
            }
            if (comparator != null) {
                Arrays.sort(recordComponents, comparator);
            }
            return recordComponents;
        }
        catch (Throwable t2) {
            KryoException ex2 = new KryoException(t2);
            ex2.addTrace("Could not retrieve record components (" + type.getName() + ")");
            throw ex2;
        }
    }

    private T invokeCanonicalConstructor(Class<? extends T> recordType, Object[] args) {
        try {
            return (T)CONSTRUCTOR.get(recordType).newInstance(args);
        }
        catch (Throwable t2) {
            KryoException ex2 = new KryoException(t2);
            ex2.addTrace("Could not construct type (" + recordType.getName() + ")");
            throw ex2;
        }
    }

    private static <T> Constructor<T> getCanonicalConstructor(Class<T> recordType, RecordComponent[] recordComponents) {
        try {
            Class[] paramTypes = (Class[])Arrays.stream(recordComponents).map(RecordComponent::type).toArray(Class[]::new);
            return RecordSerializer.getCanonicalConstructor(recordType, paramTypes);
        }
        catch (Throwable t2) {
            KryoException ex2 = new KryoException(t2);
            ex2.addTrace("Could not retrieve record canonical constructor (" + recordType.getName() + ")");
            throw ex2;
        }
    }

    private static <T> Constructor<T> getCanonicalConstructor(Class<T> recordType, Class<?>[] paramTypes) throws NoSuchMethodException {
        Constructor<T> canonicalConstructor;
        try {
            canonicalConstructor = recordType.getConstructor(paramTypes);
            if (!canonicalConstructor.canAccess(null)) {
                canonicalConstructor.setAccessible(true);
            }
        }
        catch (Exception e2) {
            canonicalConstructor = recordType.getDeclaredConstructor(paramTypes);
            canonicalConstructor.setAccessible(true);
        }
        return canonicalConstructor;
    }

    public void setFixedFieldTypes(boolean fixedFieldTypes) {
        this.fixedFieldTypes = fixedFieldTypes;
    }

    static {
        Method getType;
        Method getName;
        Method getRecordComponents;
        Method isRecord;
        try {
            Class<?> c2 = Class.forName("java.lang.reflect.RecordComponent");
            isRecord = Class.class.getDeclaredMethod("isRecord", new Class[0]);
            getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
            getName = c2.getMethod("getName", new Class[0]);
            getType = c2.getMethod("getType", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e2) {
            isRecord = null;
            getRecordComponents = null;
            getName = null;
            getType = null;
        }
        IS_RECORD = isRecord;
        GET_RECORD_COMPONENTS = getRecordComponents;
        GET_NAME = getName;
        GET_TYPE = getType;
        CONSTRUCTOR = new ClassValue<Constructor<?>>(){

            @Override
            protected Constructor<?> computeValue(Class<?> clazz) {
                RecordComponent[] components = RecordSerializer.recordComponents(clazz, Comparator.comparing(RecordComponent::index));
                return RecordSerializer.getCanonicalConstructor(clazz, components);
            }
        };
        RECORD_COMPONENTS = new ClassValue<RecordComponent[]>(){

            @Override
            protected RecordComponent[] computeValue(Class<?> type) {
                return RecordSerializer.recordComponents(type, Comparator.comparing(RecordComponent::name));
            }
        };
    }

    static final class RecordComponent {
        private final Class<?> recordType;
        private final String name;
        private final Class<?> type;
        private final int index;
        private final Method getter;

        RecordComponent(Class<?> recordType, String name, Class<?> type, int index) {
            this.recordType = recordType;
            this.name = name;
            this.type = type;
            this.index = index;
            try {
                this.getter = recordType.getDeclaredMethod(name, new Class[0]);
                if (!this.getter.isAccessible()) {
                    this.getter.setAccessible(true);
                }
            }
            catch (Exception t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace("Could not retrieve record component getter (" + recordType.getName() + ")");
                throw ex2;
            }
        }

        String name() {
            return this.name;
        }

        Class<?> type() {
            return this.type;
        }

        int index() {
            return this.index;
        }

        Object getValue(Object recordObject) {
            try {
                return this.getter.invoke(recordObject, new Object[0]);
            }
            catch (Exception t2) {
                KryoException ex2 = new KryoException(t2);
                ex2.addTrace("Could not retrieve record component value (" + this.recordType.getName() + ")");
                throw ex2;
            }
        }
    }
}

