/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.ImmutableSerializer;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class TimeSerializers {
    public static void addDefaultSerializers(Kryo kryo) {
        if (Util.isClassAvailable("java.time.Duration")) {
            kryo.addDefaultSerializer(Duration.class, DurationSerializer.class);
        }
        if (Util.isClassAvailable("java.time.Instant")) {
            kryo.addDefaultSerializer(Instant.class, InstantSerializer.class);
        }
        if (Util.isClassAvailable("java.time.LocalDate")) {
            kryo.addDefaultSerializer(LocalDate.class, LocalDateSerializer.class);
        }
        if (Util.isClassAvailable("java.time.LocalTime")) {
            kryo.addDefaultSerializer(LocalTime.class, LocalTimeSerializer.class);
        }
        if (Util.isClassAvailable("java.time.LocalDateTime")) {
            kryo.addDefaultSerializer(LocalDateTime.class, LocalDateTimeSerializer.class);
        }
        if (Util.isClassAvailable("java.time.ZoneOffset")) {
            kryo.addDefaultSerializer(ZoneOffset.class, ZoneOffsetSerializer.class);
        }
        if (Util.isClassAvailable("java.time.ZoneId")) {
            kryo.addDefaultSerializer(ZoneId.class, ZoneIdSerializer.class);
        }
        if (Util.isClassAvailable("java.time.OffsetTime")) {
            kryo.addDefaultSerializer(OffsetTime.class, OffsetTimeSerializer.class);
        }
        if (Util.isClassAvailable("java.time.OffsetDateTime")) {
            kryo.addDefaultSerializer(OffsetDateTime.class, OffsetDateTimeSerializer.class);
        }
        if (Util.isClassAvailable("java.time.ZonedDateTime")) {
            kryo.addDefaultSerializer(ZonedDateTime.class, ZonedDateTimeSerializer.class);
        }
        if (Util.isClassAvailable("java.time.Year")) {
            kryo.addDefaultSerializer(Year.class, YearSerializer.class);
        }
        if (Util.isClassAvailable("java.time.YearMonth")) {
            kryo.addDefaultSerializer(YearMonth.class, YearMonthSerializer.class);
        }
        if (Util.isClassAvailable("java.time.MonthDay")) {
            kryo.addDefaultSerializer(MonthDay.class, MonthDaySerializer.class);
        }
        if (Util.isClassAvailable("java.time.Period")) {
            kryo.addDefaultSerializer(Period.class, PeriodSerializer.class);
        }
    }

    public static class PeriodSerializer
    extends ImmutableSerializer<Period> {
        @Override
        public void write(Kryo kryo, Output out, Period obj) {
            out.writeVarInt(obj.getYears(), true);
            out.writeVarInt(obj.getMonths(), true);
            out.writeVarInt(obj.getDays(), true);
        }

        @Override
        public Period read(Kryo kryo, Input in, Class type) {
            int years = in.readInt(true);
            int months = in.readInt(true);
            int days = in.readInt(true);
            return Period.of(years, months, days);
        }
    }

    public static class MonthDaySerializer
    extends ImmutableSerializer<MonthDay> {
        @Override
        public void write(Kryo kryo, Output out, MonthDay obj) {
            out.writeByte(obj.getMonthValue());
            out.writeByte(obj.getDayOfMonth());
        }

        @Override
        public MonthDay read(Kryo kryo, Input in, Class type) {
            byte month2 = in.readByte();
            byte day = in.readByte();
            return MonthDay.of(month2, (int)day);
        }
    }

    public static class YearMonthSerializer
    extends ImmutableSerializer<YearMonth> {
        @Override
        public void write(Kryo kryo, Output out, YearMonth obj) {
            out.writeVarInt(obj.getYear(), true);
            out.writeByte(obj.getMonthValue());
        }

        @Override
        public YearMonth read(Kryo kryo, Input in, Class type) {
            int year2 = in.readInt(true);
            byte month2 = in.readByte();
            return YearMonth.of(year2, month2);
        }
    }

    public static class YearSerializer
    extends ImmutableSerializer<Year> {
        @Override
        public void write(Kryo kryo, Output out, Year obj) {
            out.writeVarInt(obj.getValue(), true);
        }

        @Override
        public Year read(Kryo kryo, Input in, Class type) {
            return Year.of(in.readInt(true));
        }
    }

    public static class ZonedDateTimeSerializer
    extends ImmutableSerializer<ZonedDateTime> {
        @Override
        public void write(Kryo kryo, Output out, ZonedDateTime obj) {
            LocalDateSerializer.write(out, obj.toLocalDate());
            LocalTimeSerializer.write(out, obj.toLocalTime());
            ZoneIdSerializer.write(out, obj.getZone());
        }

        @Override
        public ZonedDateTime read(Kryo kryo, Input in, Class type) {
            LocalDate date = LocalDateSerializer.read(in);
            LocalTime time2 = LocalTimeSerializer.read(in);
            ZoneId zone = ZoneIdSerializer.read(in);
            return ZonedDateTime.of(date, time2, zone);
        }
    }

    public static class OffsetDateTimeSerializer
    extends ImmutableSerializer<OffsetDateTime> {
        @Override
        public void write(Kryo kryo, Output out, OffsetDateTime obj) {
            LocalDateSerializer.write(out, obj.toLocalDate());
            LocalTimeSerializer.write(out, obj.toLocalTime());
            ZoneOffsetSerializer.write(out, obj.getOffset());
        }

        @Override
        public OffsetDateTime read(Kryo kryo, Input in, Class type) {
            LocalDate date = LocalDateSerializer.read(in);
            LocalTime time2 = LocalTimeSerializer.read(in);
            ZoneOffset offset = ZoneOffsetSerializer.read(in);
            return OffsetDateTime.of(date, time2, offset);
        }
    }

    public static class OffsetTimeSerializer
    extends ImmutableSerializer<OffsetTime> {
        @Override
        public void write(Kryo kryo, Output out, OffsetTime obj) {
            LocalTimeSerializer.write(out, obj.toLocalTime());
            ZoneOffsetSerializer.write(out, obj.getOffset());
        }

        @Override
        public OffsetTime read(Kryo kryo, Input in, Class type) {
            LocalTime time2 = LocalTimeSerializer.read(in);
            ZoneOffset offset = ZoneOffsetSerializer.read(in);
            return OffsetTime.of(time2, offset);
        }
    }

    public static class ZoneIdSerializer
    extends ImmutableSerializer<ZoneId> {
        @Override
        public void write(Kryo kryo, Output out, ZoneId obj) {
            ZoneIdSerializer.write(out, obj);
        }

        static void write(Output out, ZoneId obj) {
            out.writeString(obj.getId());
        }

        @Override
        public ZoneId read(Kryo kryo, Input in, Class type) {
            return ZoneIdSerializer.read(in);
        }

        static ZoneId read(Input in) {
            String id = in.readString();
            return ZoneId.of(id);
        }
    }

    public static class ZoneOffsetSerializer
    extends ImmutableSerializer<ZoneOffset> {
        @Override
        public void write(Kryo kryo, Output out, ZoneOffset obj) {
            ZoneOffsetSerializer.write(out, obj);
        }

        static void write(Output out, ZoneOffset obj) {
            int offsetSecs = obj.getTotalSeconds();
            int offsetByte = offsetSecs % 900 == 0 ? offsetSecs / 900 : 127;
            out.writeByte(offsetByte);
            if (offsetByte == 127) {
                out.writeInt(offsetSecs);
            }
        }

        @Override
        public ZoneOffset read(Kryo kryo, Input in, Class type) {
            return ZoneOffsetSerializer.read(in);
        }

        static ZoneOffset read(Input in) {
            byte offsetByte = in.readByte();
            return offsetByte == 127 ? ZoneOffset.ofTotalSeconds(in.readInt()) : ZoneOffset.ofTotalSeconds(offsetByte * 900);
        }
    }

    public static class LocalTimeSerializer
    extends ImmutableSerializer<LocalTime> {
        @Override
        public void write(Kryo kryo, Output out, LocalTime time2) {
            LocalTimeSerializer.write(out, time2);
        }

        static void write(Output out, LocalTime time2) {
            if (time2.getNano() == 0) {
                if (time2.getSecond() == 0) {
                    if (time2.getMinute() == 0) {
                        out.writeByte(~time2.getHour());
                    } else {
                        out.writeByte(time2.getHour());
                        out.writeByte(~time2.getMinute());
                    }
                } else {
                    out.writeByte(time2.getHour());
                    out.writeByte(time2.getMinute());
                    out.writeByte(~time2.getSecond());
                }
            } else {
                out.writeByte(time2.getHour());
                out.writeByte(time2.getMinute());
                out.writeByte(time2.getSecond());
                out.writeInt(time2.getNano(), true);
            }
        }

        @Override
        public LocalTime read(Kryo kryo, Input in, Class type) {
            return LocalTimeSerializer.read(in);
        }

        static LocalTime read(Input in) {
            int hour2 = in.readByte();
            int minute2 = 0;
            int second2 = 0;
            int nano = 0;
            if (hour2 < 0) {
                hour2 ^= 0xFFFFFFFF;
            } else {
                minute2 = in.readByte();
                if (minute2 < 0) {
                    minute2 ^= 0xFFFFFFFF;
                } else {
                    second2 = in.readByte();
                    if (second2 < 0) {
                        second2 ^= 0xFFFFFFFF;
                    } else {
                        nano = in.readInt(true);
                    }
                }
            }
            return LocalTime.of(hour2, minute2, second2, nano);
        }
    }

    public static class LocalDateTimeSerializer
    extends ImmutableSerializer<LocalDateTime> {
        @Override
        public void write(Kryo kryo, Output out, LocalDateTime dateTime) {
            LocalDateSerializer.write(out, dateTime.toLocalDate());
            LocalTimeSerializer.write(out, dateTime.toLocalTime());
        }

        @Override
        public LocalDateTime read(Kryo kryo, Input in, Class type) {
            LocalDate date = LocalDateSerializer.read(in);
            LocalTime time2 = LocalTimeSerializer.read(in);
            return LocalDateTime.of(date, time2);
        }
    }

    public static class LocalDateSerializer
    extends ImmutableSerializer<LocalDate> {
        @Override
        public void write(Kryo kryo, Output out, LocalDate date) {
            LocalDateSerializer.write(out, date);
        }

        static void write(Output out, LocalDate date) {
            out.writeInt(date.getYear(), true);
            out.writeByte(date.getMonthValue());
            out.writeByte(date.getDayOfMonth());
        }

        @Override
        public LocalDate read(Kryo kryo, Input in, Class type) {
            return LocalDateSerializer.read(in);
        }

        static LocalDate read(Input in) {
            int year2 = in.readInt(true);
            byte month2 = in.readByte();
            byte dayOfMonth2 = in.readByte();
            return LocalDate.of(year2, month2, (int)dayOfMonth2);
        }
    }

    public static class InstantSerializer
    extends ImmutableSerializer<Instant> {
        @Override
        public void write(Kryo kryo, Output out, Instant instant) {
            out.writeVarLong(instant.getEpochSecond(), true);
            out.writeInt(instant.getNano(), true);
        }

        @Override
        public Instant read(Kryo kryo, Input in, Class type) {
            long seconds = in.readVarLong(true);
            int nanos = in.readInt(true);
            return Instant.ofEpochSecond(seconds, nanos);
        }
    }

    public static class DurationSerializer
    extends ImmutableSerializer<Duration> {
        @Override
        public void write(Kryo kryo, Output out, Duration duration) {
            out.writeLong(duration.getSeconds());
            out.writeInt(duration.getNano(), true);
        }

        @Override
        public Duration read(Kryo kryo, Input in, Class type) {
            long seconds = in.readLong();
            int nanos = in.readInt(true);
            return Duration.ofSeconds(seconds, nanos);
        }
    }
}

