/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.util;

import com.esotericsoftware.kryo.kryo5.ClassResolver;
import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.util.IdentityMap;
import com.esotericsoftware.kryo.kryo5.util.IdentityObjectIntMap;
import com.esotericsoftware.kryo.kryo5.util.IntMap;
import com.esotericsoftware.kryo.kryo5.util.ObjectMap;
import com.esotericsoftware.kryo.kryo5.util.Util;

public class DefaultClassResolver
implements ClassResolver {
    public static final byte NAME = -1;
    protected Kryo kryo;
    protected final IntMap<Registration> idToRegistration = new IntMap();
    protected final IdentityMap<Class, Registration> classToRegistration = new IdentityMap();
    protected IdentityObjectIntMap<Class> classToNameId;
    protected IntMap<Class> nameIdToClass;
    protected ObjectMap<String, Class> nameToClass;
    protected int nextNameId;
    private int memoizedClassId = -1;
    private Registration memoizedClassIdValue;
    private Class memoizedClass;
    private Registration memoizedClassValue;

    @Override
    public void setKryo(Kryo kryo) {
        this.kryo = kryo;
    }

    @Override
    public Registration register(Registration registration) {
        this.memoizedClassId = -1;
        this.memoizedClass = null;
        if (registration == null) {
            throw new IllegalArgumentException("registration cannot be null.");
        }
        if (registration.getId() != -1) {
            if (Log.TRACE) {
                Log.trace("kryo", "Register class ID " + registration.getId() + ": " + Util.className(registration.getType()) + " (" + registration.getSerializer().getClass().getName() + ")");
            }
            this.idToRegistration.put(registration.getId(), registration);
        } else if (Log.TRACE) {
            Log.trace("kryo", "Register class name: " + Util.className(registration.getType()) + " (" + registration.getSerializer().getClass().getName() + ")");
        }
        this.classToRegistration.put(registration.getType(), registration);
        Class wrapperClass = Util.getWrapperClass(registration.getType());
        if (wrapperClass != registration.getType()) {
            this.classToRegistration.put(wrapperClass, registration);
        }
        return registration;
    }

    @Override
    public Registration unregister(int classID) {
        Registration registration = this.idToRegistration.remove(classID);
        if (registration != null) {
            this.classToRegistration.remove(registration.getType());
            this.memoizedClassId = -1;
            this.memoizedClass = null;
            Class wrapperClass = Util.getWrapperClass(registration.getType());
            if (wrapperClass != registration.getType()) {
                this.classToRegistration.remove(wrapperClass);
            }
        }
        return registration;
    }

    @Override
    public Registration registerImplicit(Class type) {
        return this.register(new Registration(type, this.kryo.getDefaultSerializer(type), -1));
    }

    @Override
    public Registration getRegistration(Class type) {
        if (type == this.memoizedClass) {
            return this.memoizedClassValue;
        }
        Registration registration = this.classToRegistration.get(type);
        if (registration != null) {
            this.memoizedClass = type;
            this.memoizedClassValue = registration;
        }
        return registration;
    }

    @Override
    public Registration getRegistration(int classID) {
        return this.idToRegistration.get(classID);
    }

    @Override
    public Registration writeClass(Output output2, Class type) {
        if (type == null) {
            if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                Util.log("Write", null, output2.position());
            }
            output2.writeByte((byte)0);
            return null;
        }
        Registration registration = this.kryo.getRegistration(type);
        if (registration.getId() == -1) {
            this.writeName(output2, type, registration);
        } else {
            if (Log.TRACE) {
                Log.trace("kryo", "Write class " + registration.getId() + ": " + Util.className(type) + Util.pos(output2.position()));
            }
            output2.writeVarInt(registration.getId() + 2, true);
        }
        return registration;
    }

    protected void writeName(Output output2, Class type, Registration registration) {
        int nameId;
        output2.writeByte(1);
        if (this.classToNameId != null && (nameId = this.classToNameId.get(type, -1)) != -1) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write class name reference " + nameId + ": " + Util.className(type) + Util.pos(output2.position()));
            }
            output2.writeVarInt(nameId, true);
            return;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Write class name: " + Util.className(type) + Util.pos(output2.position()));
        }
        nameId = this.nextNameId++;
        if (this.classToNameId == null) {
            this.classToNameId = new IdentityObjectIntMap();
        }
        this.classToNameId.put(type, nameId);
        output2.writeVarInt(nameId, true);
        if (registration.isTypeNameAscii()) {
            output2.writeAscii(type.getName());
        } else {
            output2.writeString(type.getName());
        }
    }

    @Override
    public Registration readClass(Input input2) {
        int classID = input2.readVarInt(true);
        switch (classID) {
            case 0: {
                if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                    Util.log("Read", null, input2.position());
                }
                return null;
            }
            case 1: {
                return this.readName(input2);
            }
        }
        if (classID == this.memoizedClassId) {
            if (Log.TRACE) {
                Log.trace("kryo", "Read class " + (classID - 2) + ": " + Util.className(this.memoizedClassIdValue.getType()) + Util.pos(input2.position()));
            }
            return this.memoizedClassIdValue;
        }
        Registration registration = this.idToRegistration.get(classID - 2);
        if (registration == null) {
            throw new KryoException("Encountered unregistered class ID: " + (classID - 2));
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read class " + (classID - 2) + ": " + Util.className(registration.getType()) + Util.pos(input2.position()));
        }
        this.memoizedClassId = classID;
        this.memoizedClassIdValue = registration;
        return registration;
    }

    protected Registration readName(Input input2) {
        Class type;
        int nameId = input2.readVarInt(true);
        if (this.nameIdToClass == null) {
            this.nameIdToClass = new IntMap();
        }
        if ((type = this.nameIdToClass.get(nameId)) == null) {
            String className = input2.readString();
            type = this.getTypeByName(className);
            if (type == null) {
                try {
                    type = Class.forName(className, false, this.kryo.getClassLoader());
                }
                catch (ClassNotFoundException ex2) {
                    try {
                        type = Class.forName(className, false, Kryo.class.getClassLoader());
                    }
                    catch (ClassNotFoundException ex22) {
                        throw new KryoException("Unable to find class: " + className, ex2);
                    }
                }
                if (this.nameToClass == null) {
                    this.nameToClass = new ObjectMap();
                }
                this.nameToClass.put(className, type);
            }
            this.nameIdToClass.put(nameId, type);
            if (Log.TRACE) {
                Log.trace("kryo", "Read class name: " + className + Util.pos(input2.position()));
            }
        } else if (Log.TRACE) {
            Log.trace("kryo", "Read class name reference " + nameId + ": " + Util.className(type) + Util.pos(input2.position()));
        }
        return this.kryo.getRegistration(type);
    }

    protected Class getTypeByName(String className) {
        return this.nameToClass != null ? this.nameToClass.get(className) : null;
    }

    @Override
    public void reset() {
        if (!this.kryo.isRegistrationRequired()) {
            if (this.classToNameId != null) {
                this.classToNameId.clear(2048);
            }
            if (this.nameIdToClass != null) {
                this.nameIdToClass.clear();
            }
            this.nextNameId = 0;
        }
    }
}

