/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.util;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.util.Generics;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class DefaultGenerics
implements Generics {
    private final Kryo kryo;
    private int genericTypesSize;
    private Generics.GenericType[] genericTypes = new Generics.GenericType[16];
    private int[] depths = new int[16];
    private int argumentsSize;
    private Type[] arguments = new Type[16];

    public DefaultGenerics(Kryo kryo) {
        this.kryo = kryo;
    }

    @Override
    public Generics.GenericsHierarchy buildHierarchy(Class type) {
        return new Generics.GenericsHierarchy(type);
    }

    @Override
    public void pushGenericType(Generics.GenericType fieldType) {
        int size = this.genericTypesSize;
        if (size + 1 == this.genericTypes.length) {
            Generics.GenericType[] genericTypesNew = new Generics.GenericType[this.genericTypes.length << 1];
            System.arraycopy(this.genericTypes, 0, genericTypesNew, 0, size);
            this.genericTypes = genericTypesNew;
            int[] depthsNew = new int[this.depths.length << 1];
            System.arraycopy(this.depths, 0, depthsNew, 0, size);
            this.depths = depthsNew;
        }
        this.genericTypesSize = size + 1;
        this.genericTypes[size] = fieldType;
        this.depths[size] = this.kryo.getDepth();
    }

    @Override
    public void popGenericType() {
        int size = this.genericTypesSize;
        if (size == 0) {
            return;
        }
        if (this.depths[--size] < this.kryo.getDepth()) {
            return;
        }
        this.genericTypes[size] = null;
        this.genericTypesSize = size;
    }

    @Override
    public Generics.GenericType[] nextGenericTypes() {
        int index = this.genericTypesSize;
        if (index > 0) {
            Generics.GenericType genericType = this.genericTypes[--index];
            if (genericType.arguments == null) {
                return null;
            }
            if (this.depths[index] == this.kryo.getDepth() - 1) {
                this.pushGenericType(genericType.arguments[genericType.arguments.length - 1]);
                return genericType.arguments;
            }
        }
        return null;
    }

    @Override
    public Class nextGenericClass() {
        Generics.GenericType[] arguments = this.nextGenericTypes();
        if (arguments == null) {
            return null;
        }
        return arguments[0].resolve(this);
    }

    @Override
    public int pushTypeVariables(Generics.GenericsHierarchy hierarchy, Generics.GenericType[] args) {
        if (hierarchy.total == 0 || hierarchy.rootTotal > args.length || args.length > hierarchy.counts.length) {
            return 0;
        }
        int startSize = this.argumentsSize;
        int sizeNeeded = startSize + hierarchy.total;
        if (sizeNeeded > this.arguments.length) {
            Type[] newArray = new Type[Math.max(sizeNeeded, this.arguments.length << 1)];
            System.arraycopy(this.arguments, 0, newArray, 0, startSize);
            this.arguments = newArray;
        }
        int[] counts = hierarchy.counts;
        TypeVariable[] params = hierarchy.parameters;
        int p2 = 0;
        int n2 = args.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Generics.GenericType arg = args[i2];
            Class resolved = arg.resolve(this);
            if (resolved == null) continue;
            int count = counts[i2];
            if (arg == null) {
                p2 += count;
                continue;
            }
            int nn = p2 + count;
            while (p2 < nn) {
                this.arguments[this.argumentsSize] = params[p2];
                this.arguments[this.argumentsSize + 1] = resolved;
                this.argumentsSize += 2;
                ++p2;
            }
        }
        return this.argumentsSize - startSize;
    }

    @Override
    public void popTypeVariables(int count) {
        int i2;
        int n2 = this.argumentsSize;
        this.argumentsSize = i2 = n2 - count;
        while (i2 < n2) {
            this.arguments[i2++] = null;
        }
    }

    @Override
    public Class resolveTypeVariable(TypeVariable typeVariable) {
        for (int i2 = this.argumentsSize - 2; i2 >= 0; i2 -= 2) {
            Type arg = this.arguments[i2];
            if (arg != typeVariable && !arg.equals(typeVariable)) continue;
            return (Class)this.arguments[i2 + 1];
        }
        return null;
    }

    @Override
    public int getGenericTypesSize() {
        return this.genericTypesSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < this.argumentsSize; i2 += 2) {
            if (i2 != 0) {
                buffer.append(", ");
            }
            buffer.append(((TypeVariable)this.arguments[i2]).getName());
            buffer.append("=");
            buffer.append(((Class)this.arguments[i2 + 1]).getSimpleName());
        }
        return buffer.toString();
    }
}

