/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.asn1.types.primitive;

import com.hierynomus.asn1.ASN1OutputStream;
import com.hierynomus.asn1.ASN1Parser;
import com.hierynomus.asn1.ASN1Serializer;
import com.hierynomus.asn1.encodingrules.ASN1Decoder;
import com.hierynomus.asn1.encodingrules.ASN1Encoder;
import com.hierynomus.asn1.types.ASN1Tag;
import com.hierynomus.asn1.types.primitive.ASN1PrimitiveValue;
import com.hierynomus.asn1.util.Checks;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.StringTokenizer;

public class ASN1ObjectIdentifier
extends ASN1PrimitiveValue<String> {
    private String oid;

    public ASN1ObjectIdentifier(String oid) {
        super(ASN1Tag.OBJECT_IDENTIFIER);
        this.oid = oid;
    }

    private ASN1ObjectIdentifier(byte[] valueBytes, String oid) {
        super(ASN1Tag.OBJECT_IDENTIFIER, valueBytes);
        this.oid = oid;
    }

    @Override
    public String getValue() {
        return this.oid;
    }

    @Override
    protected int valueHash() {
        return this.oid.hashCode();
    }

    public static class Serializer
    extends ASN1Serializer<ASN1ObjectIdentifier> {
        public Serializer(ASN1Encoder encoder) {
            super(encoder);
        }

        @Override
        public int serializedLength(ASN1ObjectIdentifier asn1Object) {
            if (asn1Object.valueBytes == null) {
                this.calculateBytes(asn1Object);
            }
            return asn1Object.valueBytes.length;
        }

        private void calculateBytes(ASN1ObjectIdentifier asn1Object) {
            String oid = asn1Object.oid;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StringTokenizer tokenizer = new StringTokenizer(oid, ".");
            int first2 = Integer.parseInt(tokenizer.nextToken());
            int second2 = Integer.parseInt(tokenizer.nextToken());
            baos.write(first2 * 40 + second2);
            while (tokenizer.hasMoreTokens()) {
                BigInteger token = new BigInteger(tokenizer.nextToken());
                if (token.intValue() > 0 && token.intValue() < 127) {
                    baos.write(token.intValue());
                    continue;
                }
                int neededBytes = token.bitLength() / 7 + (token.bitLength() % 7 > 0 ? 1 : 0);
                for (int i2 = neededBytes - 1; i2 >= 0; --i2) {
                    byte b2 = token.shiftRight(i2 * 7).byteValue();
                    b2 = (byte)(b2 & 0x7F);
                    if (i2 > 0) {
                        b2 = (byte)(b2 | 0x80);
                    }
                    baos.write(b2);
                }
            }
            asn1Object.valueBytes = baos.toByteArray();
        }

        @Override
        public void serialize(ASN1ObjectIdentifier asn1Object, ASN1OutputStream stream) throws IOException {
            if (asn1Object.valueBytes == null) {
                this.calculateBytes(asn1Object);
            }
            stream.write(asn1Object.valueBytes);
        }
    }

    public static class Parser
    extends ASN1Parser<ASN1ObjectIdentifier> {
        public Parser(ASN1Decoder decoder) {
            super(decoder);
        }

        @Override
        public ASN1ObjectIdentifier parse(ASN1Tag<ASN1ObjectIdentifier> asn1Tag, byte[] value) {
            Checks.checkArgument(value.length > 0, "An ASN.1 OBJECT IDENTIFIER should have at least a one byte value", new Object[0]);
            ByteArrayInputStream is = new ByteArrayInputStream(value);
            StringBuilder b2 = new StringBuilder();
            int firstTwo = is.read();
            b2.append(firstTwo / 40);
            b2.append('.').append(firstTwo % 40);
            while (is.available() > 0) {
                int x2 = is.read();
                if (x2 < 127) {
                    b2.append('.').append(x2);
                    continue;
                }
                BigInteger v2 = BigInteger.valueOf(x2 & 0x7F);
                do {
                    x2 = is.read();
                    v2 = v2.shiftLeft(7).add(BigInteger.valueOf(x2 & 0x7F));
                } while (x2 > 127);
                b2.append('.').append(v2);
            }
            return new ASN1ObjectIdentifier(value, b2.toString());
        }
    }
}

