/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.PublicKey;
import net.schmizz.sshj.common.Base64Decoder;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.KeyType;

public class OpenSSHKeyFileUtil {
    private OpenSSHKeyFileUtil() {
    }

    public static File getPublicKeyFile(File privateKeyFile) {
        File pubKey = new File(privateKeyFile + "-cert.pub");
        if (!pubKey.exists()) {
            pubKey = new File(privateKeyFile + ".pub");
        }
        if (pubKey.exists()) {
            return pubKey;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ParsedPubKey initPubKey(Reader publicKey) throws IOException {
        try (BufferedReader br2 = new BufferedReader(publicKey);){
            String keydata;
            do {
                if ((keydata = br2.readLine()) == null) throw new IOException("Public key file is blank");
            } while ((keydata = keydata.trim()).isEmpty());
            String[] parts = keydata.trim().split("\\s+");
            if (parts.length >= 2) {
                byte[] decodedPublicKey = Base64Decoder.decode(parts[1]);
                ParsedPubKey parsedPubKey = new ParsedPubKey(KeyType.fromString(parts[0]), new Buffer.PlainBuffer(decodedPublicKey).readPublicKey());
                return parsedPubKey;
            }
            throw new IOException("Got line with only one column");
        }
    }

    public static class ParsedPubKey {
        private final KeyType type;
        private final PublicKey pubKey;

        public ParsedPubKey(KeyType type, PublicKey pubKey) {
            this.type = type;
            this.pubKey = pubKey;
        }

        public KeyType getType() {
            return this.type;
        }

        public PublicKey getPubKey() {
            return this.pubKey;
        }
    }
}

