/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtil {
    private StringUtil() {
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull List<String> from, @NotNull List<String> to) {
        assert (from.size() == to.size());
        StringBuilder result2 = null;
        block0: for (int i2 = 0; i2 < text.length(); ++i2) {
            for (int j2 = 0; j2 < from.size(); ++j2) {
                String toReplace = from.get(j2);
                String replaceWith = to.get(j2);
                int len = toReplace.length();
                if (len == 0 || !text.regionMatches(i2, toReplace, 0, len)) continue;
                if (result2 == null) {
                    result2 = new StringBuilder(text.length());
                    result2.append(text, 0, i2);
                }
                result2.append(replaceWith);
                i2 += len - 1;
                continue block0;
            }
            if (result2 == null) continue;
            result2.append(text.charAt(i2));
        }
        return result2 == null ? text : result2.toString();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s2) {
        return s2 == null || s2.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s2) {
        if (StringUtil.isEmpty(s2)) {
            return true;
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (s2.charAt(i2) <= ' ') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<String> split(@NotNull String s2, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        return StringUtil.split((CharSequence)s2, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @Contract(pure=true)
    @NotNull
    public static List<CharSequence> split(@NotNull CharSequence s2, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (separator.length() == 0) {
            return Collections.singletonList(s2);
        }
        ArrayList<CharSequence> result2 = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s2, separator, pos, s2.length())) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s2.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result2.add(token);
            }
            pos = nextPos;
        }
        if (pos < s2.length() || !excludeEmptyStrings && pos == s2.length()) {
            result2.add(s2.subSequence(pos, s2.length()));
        }
        return result2;
    }

    @NotNull
    public static List<String> split(@NotNull String text, char separator) {
        ArrayList<String> result2 = new ArrayList<String>();
        int pos = 0;
        int index = text.indexOf(separator, pos);
        while (index >= 0) {
            int nextPos = index + 1;
            String token = text.substring(pos, index);
            if (token.length() != 0) {
                result2.add(token);
            }
            pos = nextPos;
            index = text.indexOf(separator, pos);
        }
        if (pos < text.length()) {
            result2.add(text.substring(pos));
        }
        return result2;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start, int end) {
        for (int i2 = start; i2 <= end - infix.length(); ++i2) {
            if (!StringUtil.startsWith(sequence2, i2, infix)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        int tl = text.length();
        if (startIndex < 0 || startIndex > tl) {
            throw new IllegalArgumentException("Index is out of bounds: " + startIndex + ", length: " + tl);
        }
        int l1 = tl - startIndex;
        int l2 = prefix.length();
        if (l1 < l2) {
            return false;
        }
        for (int i2 = 0; i2 < l2; ++i2) {
            if (text.charAt(i2 + startIndex) == prefix.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(byte @NotNull [] bytes) {
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b2 : bytes) {
            sb.append(digits.charAt(b2 >> 4 & 0xF)).append(digits.charAt(b2 & 0xF));
        }
        return sb.toString();
    }
}

