/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.util.StringUtil;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0004H\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0004H\u0016R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpValidationRule;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/PerformanceCareRule;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/FUSRegexpAwareRule;", "regexp", "", "(Ljava/lang/String;)V", "myPattern", "Ljava/util/regex/Pattern;", "getMyPattern", "()Ljava/util/regex/Pattern;", "myPattern$delegate", "Lkotlin/Lazy;", "asRegexp", "computePattern", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "toString", "Companion", "ap-validation"})
@SourceDebugExtension(value={"SMAP\nRegexpValidationRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexpValidationRule.kt\ncom/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpValidationRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1549#2:56\n1620#2,3:57\n*S KotlinDebug\n*F\n+ 1 RegexpValidationRule.kt\ncom/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpValidationRule\n*L\n48#1:56\n48#1:57,3\n*E\n"})
public final class RegexpValidationRule
extends PerformanceCareRule
implements FUSRegexpAwareRule {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final String regexp;
    @NotNull
    private final Lazy myPattern$delegate;
    @NotNull
    private static final List<String> ESCAPE_FROM;
    @NotNull
    private static final List<String> ESCAPE_TO;

    public RegexpValidationRule(@Nullable String regexp) {
        this.regexp = regexp;
        this.myPattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pattern>(this){
            final /* synthetic */ RegexpValidationRule this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pattern invoke() {
                return RegexpValidationRule.access$computePattern(this.this$0, RegexpValidationRule.access$getRegexp$p(this.this$0));
            }
        }));
    }

    private final Pattern getMyPattern() {
        Lazy lazy = this.myPattern$delegate;
        return (Pattern)lazy.getValue();
    }

    @Override
    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Pattern pattern = this.getMyPattern();
        if (pattern == null) {
            return ValidationResultType.INCORRECT_RULE;
        }
        Pattern pattern2 = pattern;
        String escaped = StatisticsEventEscaper.escapeEventIdOrFieldValue(data);
        if (pattern2.matcher(escaped).matches()) {
            return ValidationResultType.ACCEPTED;
        }
        String legacyData = StatisticsEventEscaper.cleanupForLegacyRulesIfNeeded(escaped);
        return legacyData != null && pattern2.matcher(legacyData).matches() ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
    }

    @Override
    @NotNull
    public String asRegexp() {
        String string2 = this.regexp;
        if (string2 == null) {
            string2 = "<invalid>";
        }
        return string2;
    }

    @NotNull
    public String toString() {
        return "RegexpValidationRule: myRegexp=" + this.asRegexp();
    }

    private final Pattern computePattern(String regexp) {
        Pattern pattern;
        if (regexp == null) {
            return null;
        }
        try {
            pattern = Pattern.compile(regexp);
        }
        catch (Exception ignored) {
            pattern = null;
        }
        return pattern;
    }

    @JvmStatic
    @NotNull
    public static final String escapeText(@NotNull String text) {
        return Companion.escapeText(text);
    }

    public static final /* synthetic */ Pattern access$computePattern(RegexpValidationRule $this, String regexp) {
        return $this.computePattern(regexp);
    }

    public static final /* synthetic */ String access$getRegexp$p(RegexpValidationRule $this) {
        return $this.regexp;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{"\\", "[", "]", "{", "}", "(", ")", "-", "^", "*", "+", "?", ".", "|", "$"};
        ESCAPE_FROM = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = ESCAPE_FROM;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add("\\" + (String)it);
        }
        ESCAPE_TO = (List)var3_3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpValidationRule$Companion;", "", "()V", "ESCAPE_FROM", "", "", "ESCAPE_TO", "escapeText", "text", "ap-validation"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String escapeText(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            String string2 = StringUtil.replace(text, ESCAPE_FROM, ESCAPE_TO);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replace(text, ESCAPE_FROM, ESCAPE_TO)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

