/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.utils;

import com.intellij.internal.statistic.eventLog.util.StringUtil;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.ExpressionValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.UtilValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.BooleanRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.DictionaryValidationRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.EnumReferenceRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.EnumRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.RangeReferenceRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.RangeRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.RegexpReferenceRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.RegexpRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.RejectingUtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationRuleProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationSimpleRuleFactory {
    public static final String UTIL_PREFIX = "util#";
    private static final String START = "{";
    private static final String END = "}";
    private static final List<ValidationRuleProducer<?>> RULE_PRODUCERS = Arrays.asList(new BooleanRuleProducer(), new EnumRuleProducer(), new EnumReferenceRuleProducer(), new RegexpRuleProducer(), new RegexpReferenceRuleProducer(), new RangeRuleProducer(), new RangeReferenceRuleProducer(), new DictionaryValidationRuleProducer());
    public static final UtilRuleProducer REJECTING_UTIL_URL_PRODUCER = new RejectingUtilRuleProducer();
    private final List<ValidationRuleProducer<?>> simpleRulesProducer;
    public static final FUSRule UNPARSED_EXPRESSION = (s2, c2) -> ValidationResultType.INCORRECT_RULE;

    public ValidationSimpleRuleFactory(@NotNull UtilRuleProducer utilRuleProducer) {
        ArrayList producers = new ArrayList(RULE_PRODUCERS);
        producers.add(utilRuleProducer);
        this.simpleRulesProducer = producers;
    }

    public FUSRule @NotNull [] getRules(@Nullable Set<String> rules, @NotNull EventGroupContextData contextData) {
        if (rules == null) {
            return FUSRule.EMPTY_ARRAY;
        }
        ArrayList<FUSRule> fusRules = new ArrayList<FUSRule>();
        for (String rule : rules) {
            fusRules.add(this.createRule(rule, contextData));
        }
        fusRules.sort(ValidationSimpleRuleFactory.getRulesComparator());
        return fusRules.toArray(FUSRule.EMPTY_ARRAY);
    }

    @NotNull
    private static Comparator<FUSRule> getRulesComparator() {
        return (o1, o2) -> {
            if (o1 instanceof EnumValidationRule) {
                return o2 instanceof EnumValidationRule ? 0 : -1;
            }
            return o2 instanceof EnumValidationRule ? 1 : 0;
        };
    }

    @NotNull
    private FUSRule createRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        FUSRule simpleRule = this.createSimpleRule(rule.trim(), contextData);
        return simpleRule != null ? simpleRule : this.createExpressionRule(rule.trim(), contextData);
    }

    @Nullable
    private FUSRule createSimpleRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        for (ValidationRuleProducer<?> builder : this.simpleRulesProducer) {
            String value;
            String prefix = builder.getPrefix();
            if (!rule.startsWith(prefix) || StringUtil.isEmpty(value = rule.substring(prefix.length()))) continue;
            return builder.createValidationRule(value, contextData);
        }
        return null;
    }

    @NotNull
    private FUSRule createExpressionRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        FUSRule simpleRule;
        String n2;
        List<String> nodes2 = ValidationSimpleRuleFactory.parseSimpleExpression(rule);
        if (nodes2.size() == 1 && (n2 = nodes2.get(0)).contains(START) && (simpleRule = this.createSimpleRule(ValidationSimpleRuleFactory.unwrapRuleNode(n2), contextData)) != null) {
            return simpleRule;
        }
        if (rule.contains(UTIL_PREFIX)) {
            return this.createExpressionUtilRule(nodes2);
        }
        return this.createExpressionValidationRule(rule, contextData);
    }

    @NotNull
    private FUSRule createExpressionValidationRule(@NotNull String rule, @NotNull EventGroupContextData contextData) {
        StringBuilder sb = new StringBuilder();
        for (String node : ValidationSimpleRuleFactory.parseSimpleExpression(rule)) {
            if (ValidationSimpleRuleFactory.isExpressionNode(node)) {
                FUSRule fusRule = this.createRule(ValidationSimpleRuleFactory.unwrapRuleNode(node), contextData);
                if (fusRule instanceof FUSRegexpAwareRule) {
                    sb.append("(");
                    sb.append(((FUSRegexpAwareRule)fusRule).asRegexp());
                    sb.append(")");
                    continue;
                }
                return UNPARSED_EXPRESSION;
            }
            sb.append(RegexpValidationRule.escapeText(node));
        }
        return new RegexpValidationRule(sb.toString());
    }

    private FUSRule createExpressionUtilRule(@NotNull List<String> nodes2) {
        FUSRule fusRule = null;
        String suffix = "";
        String prefix = "";
        boolean utilNodeFound = false;
        for (String string2 : nodes2) {
            if (ValidationSimpleRuleFactory.isExpressionNode(string2)) {
                if (!string2.contains(UTIL_PREFIX)) {
                    return UNPARSED_EXPRESSION;
                }
                FUSRule simpleRule = this.createRule(ValidationSimpleRuleFactory.unwrapRuleNode(string2), EventGroupContextData.EMPTY);
                if (!(simpleRule instanceof UtilValidationRule)) {
                    return UNPARSED_EXPRESSION;
                }
                fusRule = simpleRule;
                utilNodeFound = true;
                continue;
            }
            if (utilNodeFound) {
                suffix = string2;
                continue;
            }
            prefix = string2;
        }
        if (fusRule == null) {
            return UNPARSED_EXPRESSION;
        }
        return new ExpressionValidationRule(fusRule, prefix, suffix);
    }

    @NotNull
    public static List<String> parseSimpleExpression(@NotNull String s2) {
        int currentRuleStart = s2.indexOf(START);
        if (StringUtil.isEmptyOrSpaces(s2)) {
            return Collections.emptyList();
        }
        if (currentRuleStart == -1) {
            return Collections.singletonList(s2);
        }
        int lastRuleEnd = -1;
        ArrayList<String> nodes2 = new ArrayList<String>();
        if (currentRuleStart > 0) {
            ValidationSimpleRuleFactory.addNonEmpty(nodes2, s2.substring(0, currentRuleStart));
        }
        while (currentRuleStart >= 0) {
            int nextRule;
            int currentRuleEnd;
            if (s2.startsWith("regexp:", currentRuleStart + START.length()) || s2.startsWith("enum:", currentRuleStart + START.length())) {
                currentRuleEnd = ValidationSimpleRuleFactory.getPairBracket(s2, currentRuleStart);
                nextRule = s2.indexOf(START, currentRuleEnd);
            } else {
                currentRuleEnd = s2.indexOf(END, currentRuleStart);
                nextRule = s2.indexOf(START, currentRuleStart + START.length());
            }
            if (currentRuleEnd == -1) {
                return Collections.emptyList();
            }
            lastRuleEnd = currentRuleEnd + END.length();
            if (nextRule > 0 && nextRule < lastRuleEnd) {
                return Collections.emptyList();
            }
            ValidationSimpleRuleFactory.addNonEmpty(nodes2, s2.substring(currentRuleStart, lastRuleEnd));
            currentRuleStart = s2.indexOf(START, lastRuleEnd);
            if (currentRuleStart <= 0) continue;
            ValidationSimpleRuleFactory.addNonEmpty(nodes2, s2.substring(lastRuleEnd, currentRuleStart));
        }
        if (lastRuleEnd > 0) {
            ValidationSimpleRuleFactory.addNonEmpty(nodes2, s2.substring(lastRuleEnd));
        }
        return nodes2;
    }

    private static int getPairBracket(String s2, Integer index) {
        int opensStack = 0;
        for (int curIndex = index.intValue(); curIndex < s2.length(); ++curIndex) {
            if (s2.startsWith(START, curIndex)) {
                ++opensStack;
                continue;
            }
            if (!s2.startsWith(END, curIndex) || --opensStack != 0) continue;
            return curIndex;
        }
        return -1;
    }

    private static void addNonEmpty(@NotNull List<? super String> nodes2, @Nullable String s2) {
        if (!StringUtil.isEmpty(s2)) {
            nodes2.add(s2);
        }
    }

    private static boolean isExpressionNode(@NotNull String node) {
        return node.startsWith(START) && node.endsWith(END);
    }

    @NotNull
    private static String unwrapRuleNode(@NotNull String rule) {
        return ValidationSimpleRuleFactory.isExpressionNode(rule) ? rule.substring(START.length(), rule.length() - END.length()) : rule;
    }
}

