/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.TempFieldAccessor;
import com.intellij.util.ui.TempMethodInvocator;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PrinterGraphics;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.ProxyPrintGraphics;
import sun.swing.ImageIconUIResource;
import sun.swing.PrintColorUIResource;
import sun.swing.StringUIClientPropertyKey;

public class UIUtilities {
    public static final Object LAF_STATE_KEY = new StringBuffer("LookAndFeel State");
    public static final Object MENU_SELECTION_MANAGER_LISTENER_KEY = new StringBuffer("MenuSelectionManager listener key");
    private static LSBCacheEntry[] fontCache;
    private static final int CACHE_SIZE = 6;
    private static int nextIndex;
    private static LSBCacheEntry searchKey;
    private static final int MIN_CHAR_INDEX = 87;
    private static final int MAX_CHAR_INDEX = 88;
    public static final FontRenderContext DEFAULT_FRC;
    public static final Object AA_TEXT_PROPERTY_KEY;
    public static final String IMPLIED_CR = "CR";
    private static final StringBuilder SKIP_CLICK_COUNT;
    private static TempMethodInvocator<Object> AATextInfoAccessor;
    public static final Object COMPONENT_UI_PROPERTY_KEY;
    public static final StringUIClientPropertyKey BASICMENUITEMUI_MAX_TEXT_OFFSET;
    private static Field inputEvent_CanAccessSystemClipboard_Field;
    private static final String UntrustedClipboardAccess = "UNTRUSTED_CLIPBOARD_ACCESS_KEY";
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock;
    private static char[] charsBuffer;
    private static TempMethodInvocator<Boolean> isComplexLayoutAccessor;
    private static TempMethodInvocator<FontMetrics> getFontMetricsAccessor1;
    private static TempMethodInvocator<FontMetrics> getFontMetricsAccessor3;
    private static TempMethodInvocator<Integer> stringWidthAccessor;
    private static TempMethodInvocator<String> clipStringAccessor;
    private static TempMethodInvocator<Void> drawStringAccessor3;
    private static TempMethodInvocator<Void> drawStringUnderlineCharAtAccessor;
    private static TempMethodInvocator<Float> drawCharsAccessor;
    private static TempMethodInvocator<Float> drawStringAccessor1;
    private static TempMethodInvocator<Float> drawStringAccessor2;
    private static TempMethodInvocator<FontMetrics> getFontMetricsAccessor2;
    private static TempMethodInvocator<FontRenderContext> getRFCPropertyAccessor;

    public static Object createAATextInfo(Object aaHint, Integer lcdContrastHint) {
        return AATextInfoAccessor.create(aaHint, lcdContrastHint);
    }

    private static int syncCharsBuffer(String s2) {
        int length = s2.length();
        if (charsBuffer == null || charsBuffer.length < length) {
            charsBuffer = s2.toCharArray();
        } else {
            s2.getChars(0, length, charsBuffer, 0);
        }
        return length;
    }

    public static final boolean isComplexLayout(char[] text, int start, int limit) {
        return isComplexLayoutAccessor.staticInvoke(text, start, limit);
    }

    public static int getLeftSideBearing(JComponent c2, FontMetrics fm, String string2) {
        if (string2 == null || string2.length() == 0) {
            return 0;
        }
        return UIUtilities.getLeftSideBearing(c2, fm, string2.charAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLeftSideBearing(JComponent c2, FontMetrics fm, char firstChar) {
        char charIndex = firstChar;
        if (charIndex < 'X' && charIndex >= 'W') {
            Object lsbs = null;
            FontRenderContext frc = UIUtilities.getFontRenderContext(c2, fm);
            Font font = fm.getFont();
            Class<UIUtilities> clazz = UIUtilities.class;
            synchronized (UIUtilities.class) {
                LSBCacheEntry entry = null;
                if (searchKey == null) {
                    searchKey = new LSBCacheEntry(frc, font);
                } else {
                    searchKey.reset(frc, font);
                }
                for (LSBCacheEntry cacheEntry : fontCache) {
                    if (!searchKey.equals(cacheEntry)) continue;
                    entry = cacheEntry;
                    break;
                }
                if (entry == null) {
                    entry = searchKey;
                    UIUtilities.fontCache[UIUtilities.nextIndex] = searchKey;
                    searchKey = null;
                    nextIndex = (nextIndex + 1) % 6;
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return entry.getLeftSideBearing(firstChar);
            }
        }
        return 0;
    }

    public static FontMetrics getFontMetrics(JComponent c2, Graphics g2) {
        return getFontMetricsAccessor1.staticInvoke(c2, g2);
    }

    public static FontMetrics getFontMetrics(JComponent c2, Graphics g2, Font font) {
        return getFontMetricsAccessor3.staticInvoke(c2, g2, font);
    }

    public static int stringWidth(JComponent c2, FontMetrics fm, String string2) {
        return stringWidthAccessor.staticInvoke(c2, fm, string2);
    }

    public static String clipStringIfNecessary(JComponent c2, FontMetrics fm, String string2, int availTextWidth) {
        if (string2 == null || string2.equals("")) {
            return "";
        }
        int textWidth = UIUtilities.stringWidth(c2, fm, string2);
        if (textWidth > availTextWidth) {
            return UIUtilities.clipString(c2, fm, string2, availTextWidth);
        }
        return string2;
    }

    public static String clipString(JComponent c2, FontMetrics fm, String string2, int availTextWidth) {
        return clipStringAccessor.staticInvoke(c2, fm, string2, availTextWidth);
    }

    public static void drawString(JComponent c2, Graphics g2, String text, int x2, int y2) {
        drawStringAccessor3.staticInvoke(c2, g2, text, x2, y2);
    }

    public static void drawStringUnderlineCharAt(JComponent c2, Graphics g2, String text, int underlinedIndex, int x2, int y2) {
        drawStringUnderlineCharAtAccessor.staticInvoke(c2, g2, text, underlinedIndex, x2, y2);
    }

    public static int loc2IndexFileList(JList list, Point point) {
        Object bySize;
        int index = list.locationToIndex(point);
        if (index != -1 && (bySize = list.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)bySize).booleanValue() && !UIUtilities.pointIsInActualBounds(list, index, point)) {
            index = -1;
        }
        return index;
    }

    private static boolean pointIsInActualBounds(JList list, int index, Point point) {
        ListCellRenderer renderer = list.getCellRenderer();
        ListModel dataModel = list.getModel();
        Object value = dataModel.getElementAt(index);
        Component item = renderer.getListCellRendererComponent(list, value, index, false, false);
        Dimension itemSize = item.getPreferredSize();
        Rectangle cellBounds = list.getCellBounds(index, index);
        if (!item.getComponentOrientation().isLeftToRight()) {
            cellBounds.x += cellBounds.width - itemSize.width;
        }
        cellBounds.width = itemSize.width;
        return cellBounds.contains(point);
    }

    public static boolean pointOutsidePrefSize(JTable table2, int row, int column2, Point p2) {
        if (table2.convertColumnIndexToModel(column2) != 0 || row == -1) {
            return true;
        }
        TableCellRenderer tcr = table2.getCellRenderer(row, column2);
        Object value = table2.getValueAt(row, column2);
        Component cell = tcr.getTableCellRendererComponent(table2, value, false, false, row, column2);
        Dimension itemSize = cell.getPreferredSize();
        Rectangle cellBounds = table2.getCellRect(row, column2, false);
        cellBounds.width = itemSize.width;
        cellBounds.height = itemSize.height;
        assert (p2.x >= cellBounds.x && p2.y >= cellBounds.y);
        return p2.x > cellBounds.x + cellBounds.width || p2.y > cellBounds.y + cellBounds.height;
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel model, int lead, int anchor) {
        if (anchor == -1) {
            anchor = lead;
        }
        if (lead == -1) {
            model.setAnchorSelectionIndex(-1);
            model.setLeadSelectionIndex(-1);
        } else {
            if (model.isSelectedIndex(lead)) {
                model.addSelectionInterval(lead, lead);
            } else {
                model.removeSelectionInterval(lead, lead);
            }
            model.setAnchorSelectionIndex(anchor);
        }
    }

    public static boolean shouldIgnore(MouseEvent me, JComponent c2) {
        return c2 == null || !c2.isEnabled() || !SwingUtilities.isLeftMouseButton(me) || me.isConsumed();
    }

    public static void adjustFocus(JComponent c2) {
        if (!c2.hasFocus() && c2.isRequestFocusEnabled()) {
            c2.requestFocus();
        }
    }

    public static int drawChars(JComponent c2, Graphics g2, char[] data, int offset, int length, int x2, int y2) {
        return (int)UIUtilities.drawChars(c2, g2, data, offset, length, x2, y2, false);
    }

    public static float drawChars(JComponent c2, Graphics g2, char[] data, int offset, int length, float x2, float y2) {
        return UIUtilities.drawChars(c2, g2, data, offset, length, x2, y2, true);
    }

    public static float drawChars(JComponent c2, Graphics g2, char[] data, int offset, int length, float x2, float y2, boolean useFPAPI) {
        return drawCharsAccessor.staticInvoke(c2, g2, data, offset, length, Float.valueOf(x2), Float.valueOf(y2), useFPAPI).floatValue();
    }

    public static float getFontCharWidth(char c2, FontMetrics fm, boolean useFPAPI) {
        return UIUtilities.getFontCharsWidth(new char[]{c2}, 0, 1, fm, useFPAPI);
    }

    public static float getFontCharsWidth(char[] data, int offset, int len, FontMetrics fm, boolean useFPAPI) {
        if (len == 0) {
            return 0.0f;
        }
        if (useFPAPI) {
            Rectangle2D bounds = fm.getFont().getStringBounds(data, offset, offset + len, fm.getFontRenderContext());
            return (float)bounds.getWidth();
        }
        return fm.charsWidth(data, offset, len);
    }

    public static float getFontStringWidth(String data, FontMetrics fm, boolean useFPAPI) {
        if (useFPAPI) {
            Rectangle2D bounds = fm.getFont().getStringBounds(data, fm.getFontRenderContext());
            return (float)bounds.getWidth();
        }
        return fm.stringWidth(data);
    }

    public static float drawString(JComponent c2, Graphics g2, AttributedCharacterIterator iterator2, int x2, int y2) {
        return drawStringAccessor1.staticInvoke(c2, g2, iterator2, x2, y2).floatValue();
    }

    public static float drawString(JComponent c2, Graphics g2, AttributedCharacterIterator iterator2, float x2, float y2) {
        return drawStringAccessor2.staticInvoke(c2, g2, iterator2, Float.valueOf(x2), Float.valueOf(y2)).floatValue();
    }

    private static float drawStringImpl(JComponent c2, Graphics g2, AttributedCharacterIterator iterator2, float x2, float y2) {
        float retVal;
        Graphics2D g2d;
        boolean isPrinting = UIUtilities.isPrinting(g2);
        Color col2 = g2.getColor();
        if (isPrinting && col2 instanceof PrintColorUIResource) {
            g2.setColor(((PrintColorUIResource)col2).getPrintColor());
        }
        if ((g2d = UIUtilities.getGraphics2D(g2)) == null) {
            g2.drawString(iterator2, (int)x2, (int)y2);
            retVal = x2;
        } else {
            TextLayout layout;
            FontRenderContext frc;
            if (isPrinting) {
                frc = UIUtilities.getFontRenderContext(c2);
                if (frc.isAntiAliased() || frc.usesFractionalMetrics()) {
                    frc = new FontRenderContext(frc.getTransform(), false, false);
                }
            } else {
                frc = UIUtilities.getFRCProperty(c2);
                if (frc == null) {
                    frc = g2d.getFontRenderContext();
                }
            }
            if (isPrinting) {
                FontRenderContext deviceFRC = g2d.getFontRenderContext();
                if (!UIUtilities.isFontRenderContextPrintCompatible(frc, deviceFRC)) {
                    layout = new TextLayout(iterator2, deviceFRC);
                    AttributedCharacterIterator trimmedIt = UIUtilities.getTrimmedTrailingSpacesIterator(iterator2);
                    if (trimmedIt != null) {
                        float screenWidth = new TextLayout(trimmedIt, frc).getAdvance();
                        layout = layout.getJustifiedLayout(screenWidth);
                    }
                } else {
                    layout = new TextLayout(iterator2, frc);
                }
            } else {
                layout = new TextLayout(iterator2, frc);
            }
            layout.draw(g2d, x2, y2);
            retVal = layout.getAdvance();
        }
        if (isPrinting) {
            g2.setColor(col2);
        }
        return retVal;
    }

    public static void drawVLine(Graphics g2, int x2, int y1, int y2) {
        if (y2 < y1) {
            int temp = y2;
            y2 = y1;
            y1 = temp;
        }
        g2.fillRect(x2, y1, 1, y2 - y1 + 1);
    }

    public static void drawHLine(Graphics g2, int x1, int x2, int y2) {
        if (x2 < x1) {
            int temp = x2;
            x2 = x1;
            x1 = temp;
        }
        g2.fillRect(x1, y2, x2 - x1 + 1, 1);
    }

    public static void drawRect(Graphics g2, int x2, int y2, int w2, int h7) {
        if (w2 < 0 || h7 < 0) {
            return;
        }
        if (h7 == 0 || w2 == 0) {
            g2.fillRect(x2, y2, w2 + 1, h7 + 1);
        } else {
            g2.fillRect(x2, y2, w2, 1);
            g2.fillRect(x2 + w2, y2, 1, h7);
            g2.fillRect(x2 + 1, y2 + h7, w2, 1);
            g2.fillRect(x2, y2 + 1, 1, h7);
        }
    }

    private static TextLayout createTextLayout(JComponent c2, String s2, Font f2, FontRenderContext frc) {
        Object shaper;
        Object object = shaper = c2 == null ? null : c2.getClientProperty(TextAttribute.NUMERIC_SHAPING);
        if (shaper == null) {
            return new TextLayout(s2, f2, frc);
        }
        HashMap<TextAttribute, Object> a2 = new HashMap<TextAttribute, Object>();
        a2.put(TextAttribute.FONT, f2);
        a2.put(TextAttribute.NUMERIC_SHAPING, shaper);
        return new TextLayout(s2, a2, frc);
    }

    private static boolean isFontRenderContextPrintCompatible(FontRenderContext frc1, FontRenderContext frc2) {
        if (frc1 == frc2) {
            return true;
        }
        if (frc1 == null || frc2 == null) {
            return false;
        }
        if (frc1.getFractionalMetricsHint() != frc2.getFractionalMetricsHint()) {
            return false;
        }
        if (!frc1.isTransformed() && !frc2.isTransformed()) {
            return true;
        }
        double[] mat1 = new double[4];
        double[] mat2 = new double[4];
        frc1.getTransform().getMatrix(mat1);
        frc2.getTransform().getMatrix(mat2);
        return mat1[0] == mat2[0] && mat1[1] == mat2[1] && mat1[2] == mat2[2] && mat1[3] == mat2[3];
    }

    public static Graphics2D getGraphics2D(Graphics g2) {
        if (g2 instanceof Graphics2D) {
            return (Graphics2D)g2;
        }
        if (g2 instanceof ProxyPrintGraphics) {
            return (Graphics2D)((ProxyPrintGraphics)g2).getGraphics();
        }
        return null;
    }

    public static FontRenderContext getFontRenderContext(Component c2) {
        assert (c2 != null);
        if (c2 == null) {
            return DEFAULT_FRC;
        }
        return c2.getFontMetrics(c2.getFont()).getFontRenderContext();
    }

    private static FontRenderContext getFontRenderContext(Component c2, FontMetrics fm) {
        assert (fm != null || c2 != null);
        return fm != null ? fm.getFontRenderContext() : UIUtilities.getFontRenderContext(c2);
    }

    public static FontMetrics getFontMetrics(JComponent c2, Font font) {
        return getFontMetricsAccessor2.staticInvoke(c2, font);
    }

    private static FontRenderContext getFRCProperty(JComponent c2) {
        return getRFCPropertyAccessor.staticInvoke(c2);
    }

    static boolean isPrinting(Graphics g2) {
        return g2 instanceof PrinterGraphics || g2 instanceof PrintGraphics;
    }

    private static String trimTrailingSpaces(String s2) {
        int i2;
        for (i2 = s2.length() - 1; i2 >= 0 && Character.isWhitespace(s2.charAt(i2)); --i2) {
        }
        return s2.substring(0, i2 + 1);
    }

    private static AttributedCharacterIterator getTrimmedTrailingSpacesIterator(AttributedCharacterIterator iterator2) {
        int curIdx = iterator2.getIndex();
        char c2 = iterator2.last();
        while (c2 != '\uffff' && Character.isWhitespace(c2)) {
            c2 = iterator2.previous();
        }
        if (c2 != '\uffff') {
            int endIdx = iterator2.getIndex();
            if (endIdx == iterator2.getEndIndex() - 1) {
                iterator2.setIndex(curIdx);
                return iterator2;
            }
            AttributedString trimmedText = new AttributedString(iterator2, iterator2.getBeginIndex(), endIdx + 1);
            return trimmedText.getIterator();
        }
        return null;
    }

    public static boolean useSelectedTextColor(Highlighter.Highlight h7, JTextComponent c2) {
        Highlighter.HighlightPainter painter = h7.getPainter();
        String painterClass = painter.getClass().getName();
        if (painterClass.indexOf("javax.swing.text.DefaultHighlighter") != 0 && painterClass.indexOf("com.sun.java.swing.plaf.windows.WindowsTextUI") != 0) {
            return false;
        }
        try {
            DefaultHighlighter.DefaultHighlightPainter defPainter = (DefaultHighlighter.DefaultHighlightPainter)painter;
            if (defPainter.getColor() != null && !defPainter.getColor().equals(c2.getSelectionColor())) {
                return false;
            }
        }
        catch (ClassCastException e2) {
            return false;
        }
        return true;
    }

    public static boolean canCurrentEventAccessSystemClipboard() {
        return UIUtilities.isTrustedContext() || UIUtilities.canCurrentEventAccessSystemClipboard(false);
    }

    public static boolean canEventAccessSystemClipboard(AWTEvent e2) {
        return UIUtilities.isTrustedContext() || UIUtilities.canEventAccessSystemClipboard(e2, false);
    }

    private static synchronized boolean inputEvent_canAccessSystemClipboard(InputEvent ie) {
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            inputEvent_CanAccessSystemClipboard_Field = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    try {
                        Field field = InputEvent.class.getDeclaredField("canAccessSystemClipboard");
                        field.setAccessible(true);
                        return field;
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            return false;
        }
        boolean ret = false;
        try {
            ret = inputEvent_CanAccessSystemClipboard_Field.getBoolean(ie);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return ret;
    }

    private static boolean isAccessClipboardGesture(InputEvent ie) {
        boolean allowedGesture = false;
        if (ie instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)ie;
            int keyCode = ke.getKeyCode();
            int keyModifiers = ke.getModifiers();
            switch (keyCode) {
                case 67: 
                case 86: 
                case 88: {
                    allowedGesture = keyModifiers == 2;
                    break;
                }
                case 155: {
                    allowedGesture = keyModifiers == 2 || keyModifiers == 1;
                    break;
                }
                case 65485: 
                case 65487: 
                case 65489: {
                    allowedGesture = true;
                    break;
                }
                case 127: {
                    allowedGesture = keyModifiers == 1;
                }
            }
        }
        return allowedGesture;
    }

    private static boolean canEventAccessSystemClipboard(AWTEvent e2, boolean checkGesture) {
        if (EventQueue.isDispatchThread()) {
            if (e2 instanceof InputEvent && (!checkGesture || UIUtilities.isAccessClipboardGesture((InputEvent)e2))) {
                return UIUtilities.inputEvent_canAccessSystemClipboard((InputEvent)e2);
            }
            return false;
        }
        return true;
    }

    public static void checkAccess(int modifiers) {
        if (System.getSecurityManager() != null && !Modifier.isPublic(modifiers)) {
            throw new SecurityException("Resource is not accessible");
        }
    }

    private static boolean canCurrentEventAccessSystemClipboard(boolean checkGesture) {
        AWTEvent event = EventQueue.getCurrentEvent();
        return UIUtilities.canEventAccessSystemClipboard(event, checkGesture);
    }

    private static boolean isTrustedContext() {
        return System.getSecurityManager() == null || AppContext.getAppContext().get(UntrustedClipboardAccess) == null;
    }

    public static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuffer rule = new StringBuffer("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            if (fg.getRed() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getRed()));
            if (fg.getGreen() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getGreen()));
            if (fg.getBlue() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getBlue()));
            rule.append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    public static Object makeIcon(final Class<?> baseClass, final Class<?> rootClass, final String imageFile) {
        return new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table2) {
                byte[] buffer = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                    @Override
                    public byte[] run() {
                        try {
                            int n2;
                            InputStream resource2 = null;
                            for (Class srchClass = baseClass; srchClass != null && (resource2 = srchClass.getResourceAsStream(imageFile)) == null && srchClass != rootClass; srchClass = srchClass.getSuperclass()) {
                            }
                            if (resource2 == null) {
                                return null;
                            }
                            BufferedInputStream in = new BufferedInputStream(resource2);
                            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                            byte[] buffer = new byte[1024];
                            while ((n2 = in.read(buffer)) > 0) {
                                out.write(buffer, 0, n2);
                            }
                            in.close();
                            out.flush();
                            return out.toByteArray();
                        }
                        catch (IOException ioe) {
                            System.err.println(ioe.toString());
                            return null;
                        }
                    }
                });
                if (buffer == null) {
                    return null;
                }
                if (buffer.length == 0) {
                    System.err.println("warning: " + imageFile + " is zero-length");
                    return null;
                }
                return new ImageIconUIResource(buffer);
            }
        };
    }

    public static boolean isLocalDisplay() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        boolean isLocal = ge instanceof SunGraphicsEnvironment ? ((SunGraphicsEnvironment)ge).isDisplayLocal() : true;
        return isLocal;
    }

    public static int getUIDefaultsInt(Object key) {
        return UIUtilities.getUIDefaultsInt(key, 0);
    }

    public static int getUIDefaultsInt(Object key, Locale l2) {
        return UIUtilities.getUIDefaultsInt(key, l2, 0);
    }

    public static int getUIDefaultsInt(Object key, int defaultValue) {
        return UIUtilities.getUIDefaultsInt(key, null, defaultValue);
    }

    public static int getUIDefaultsInt(Object key, Locale l2, int defaultValue) {
        Object value = UIManager.get(key, l2);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            FocusTraversalPolicy policy;
            Component comp;
            FocusTraversalPolicy policy2;
            Component comp2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (comp2 = (policy2 = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                comp2.requestFocus();
                return comp2;
            }
            Container rootAncestor = container.getFocusCycleRootAncestor();
            if (rootAncestor != null && (comp = (policy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, container)) != null && SwingUtilities.isDescendingFrom(comp, container)) {
                comp.requestFocus();
                return comp;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    public static boolean tabbedPaneChangeFocusTo(Component comp) {
        if (comp != null) {
            if (comp.isFocusTraversable()) {
                UIUtilities.compositeRequestFocus(comp);
                return true;
            }
            if (comp instanceof JComponent && ((JComponent)comp).requestDefaultFocus()) {
                return true;
            }
        }
        return false;
    }

    public static <V> Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask<V> future = new FutureTask<V>(task);
        UIUtilities.execute(future);
        return future;
    }

    public static <V> Future<V> submit(Runnable task, V result2) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask<V> future = new FutureTask<V>(task, result2);
        UIUtilities.execute(future);
        return future;
    }

    private static void execute(Runnable command2) {
        SwingUtilities.invokeLater(command2);
    }

    public static void setSkipClickCount(Component comp, int count) {
        if (comp instanceof JTextComponent && ((JTextComponent)comp).getCaret() instanceof DefaultCaret) {
            ((JTextComponent)comp).putClientProperty(SKIP_CLICK_COUNT, count);
        }
    }

    public static int getAdjustedClickCount(JTextComponent comp, MouseEvent e2) {
        int cc2 = e2.getClickCount();
        if (cc2 == 1) {
            comp.putClientProperty(SKIP_CLICK_COUNT, null);
        } else {
            Integer sub2 = (Integer)comp.getClientProperty(SKIP_CLICK_COUNT);
            if (sub2 != null) {
                return cc2 - sub2;
            }
        }
        return cc2;
    }

    private static Section liesIn(Rectangle rect, Point p2, boolean horizontal, boolean ltr, boolean three) {
        boolean forward;
        int length;
        int pComp;
        int p0;
        if (horizontal) {
            p0 = rect.x;
            pComp = p2.x;
            length = rect.width;
            forward = ltr;
        } else {
            p0 = rect.y;
            pComp = p2.y;
            length = rect.height;
            forward = true;
        }
        if (three) {
            int boundary;
            int n2 = boundary = length >= 30 ? 10 : length / 3;
            if (pComp < p0 + boundary) {
                return forward ? Section.LEADING : Section.TRAILING;
            }
            if (pComp >= p0 + length - boundary) {
                return forward ? Section.TRAILING : Section.LEADING;
            }
            return Section.MIDDLE;
        }
        int middle = p0 + length / 2;
        if (forward) {
            return pComp >= middle ? Section.TRAILING : Section.LEADING;
        }
        return pComp < middle ? Section.TRAILING : Section.LEADING;
    }

    public static Section liesInHorizontal(Rectangle rect, Point p2, boolean ltr, boolean three) {
        return UIUtilities.liesIn(rect, p2, true, ltr, three);
    }

    public static Section liesInVertical(Rectangle rect, Point p2, boolean three) {
        return UIUtilities.liesIn(rect, p2, false, false, three);
    }

    public static int convertColumnIndexToModel(TableColumnModel cm2, int viewColumnIndex) {
        if (viewColumnIndex < 0) {
            return viewColumnIndex;
        }
        return cm2.getColumn(viewColumnIndex).getModelIndex();
    }

    public static int convertColumnIndexToView(TableColumnModel cm2, int modelColumnIndex) {
        if (modelColumnIndex < 0) {
            return modelColumnIndex;
        }
        for (int column2 = 0; column2 < cm2.getColumnCount(); ++column2) {
            if (cm2.getColumn(column2).getModelIndex() != modelColumnIndex) continue;
            return column2;
        }
        return -1;
    }

    public static int getSystemMnemonicKeyMask() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            return ((SunToolkit)toolkit).getFocusAcceleratorKeyMask();
        }
        return 8;
    }

    public static TreePath getTreePath(TreeModelEvent event, TreeModel model) {
        Object root;
        TreePath path = event.getTreePath();
        if (path == null && model != null && (root = model.getRoot()) != null) {
            path = new TreePath(root);
        }
        return path;
    }

    public static boolean isScaledGraphics(Graphics g2) {
        if (g2 instanceof Graphics2D) {
            AffineTransform tx = ((Graphics2D)g2).getTransform();
            return (tx.getType() & 0xFFFFFFBE) != 0;
        }
        return false;
    }

    public static boolean isFloatingPointScale(AffineTransform tx) {
        int type = tx.getType() & 0xFFFFFFBE;
        if (type == 0) {
            return false;
        }
        if ((type & 0xFFFFFFF9) == 0) {
            double scaleX = tx.getScaleX();
            double scaleY = tx.getScaleY();
            return scaleX != (double)((int)scaleX) || scaleY != (double)((int)scaleY);
        }
        return false;
    }

    static {
        DEFAULT_FRC = new FontRenderContext(null, false, false);
        AA_TEXT_PROPERTY_KEY = new TempFieldAccessor("sun.swing.SwingUtilities2", "AA_TEXT_PROPERTY_KEY").get(null);
        SKIP_CLICK_COUNT = new StringBuilder("skipClickCount");
        AATextInfoAccessor = new TempMethodInvocator("sun.swing.SwingUtilities2$AATextInfo", Object.class, Integer.class);
        COMPONENT_UI_PROPERTY_KEY = new StringBuffer("ComponentUIPropertyKey");
        BASICMENUITEMUI_MAX_TEXT_OFFSET = new StringUIClientPropertyKey("maxTextOffset");
        inputEvent_CanAccessSystemClipboard_Field = null;
        charsBufferLock = new Object();
        charsBuffer = new char[100];
        fontCache = new LSBCacheEntry[6];
        isComplexLayoutAccessor = new TempMethodInvocator("sun.swing.SwingUtilities2", "isComplexLayout", char[].class, Integer.TYPE, Integer.TYPE);
        getFontMetricsAccessor1 = new TempMethodInvocator("sun.swing.SwingUtilities2", "getFontMetrics", JComponent.class, Graphics.class);
        getFontMetricsAccessor3 = new TempMethodInvocator("sun.swing.SwingUtilities2", "getFontMetrics", JComponent.class, Graphics.class, Font.class);
        stringWidthAccessor = new TempMethodInvocator("sun.swing.SwingUtilities2", "stringWidth", JComponent.class, FontMetrics.class, String.class);
        clipStringAccessor = new TempMethodInvocator("sun.swing.SwingUtilities2", "clipString", JComponent.class, FontMetrics.class, String.class, Integer.TYPE);
        drawStringAccessor3 = new TempMethodInvocator("sun.swing.SwingUtilities2", "drawString", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE);
        drawStringUnderlineCharAtAccessor = new TempMethodInvocator("sun.swing.SwingUtilities2", "drawStringUnderlineCharAt", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        drawCharsAccessor = new TempMethodInvocator("sun.swing.SwingUtilities2", "drawChars", JComponent.class, Graphics.class, char[].class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Boolean.TYPE);
        drawStringAccessor1 = new TempMethodInvocator("sun.swing.SwingUtilities2", "drawString", JComponent.class, Graphics.class, AttributedCharacterIterator.class, Integer.TYPE, Integer.TYPE);
        drawStringAccessor2 = new TempMethodInvocator("sun.swing.SwingUtilities2", "drawString", JComponent.class, Graphics.class, AttributedCharacterIterator.class, Float.TYPE, Float.TYPE);
        getFontMetricsAccessor2 = new TempMethodInvocator("sun.swing.SwingUtilities2", "getFontMetrics", JComponent.class, Font.class);
        getRFCPropertyAccessor = new TempMethodInvocator("sun.swing.SwingUtilities2", "getRFCProperty", JComponent.class, Graphics.class, char[].class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Boolean.TYPE);
    }

    public static interface RepaintListener {
        public void repaintPerformed(JComponent var1, int var2, int var3, int var4, int var5);
    }

    public static enum Section {
        LEADING,
        MIDDLE,
        TRAILING;

    }

    private static class LSBCacheEntry {
        private static final byte UNSET = 127;
        private static final char[] oneChar = new char[1];
        private byte[] lsbCache = new byte[1];
        private Font font;
        private FontRenderContext frc;

        public LSBCacheEntry(FontRenderContext frc, Font font) {
            this.reset(frc, font);
        }

        public void reset(FontRenderContext frc, Font font) {
            this.font = font;
            this.frc = frc;
            for (int counter = this.lsbCache.length - 1; counter >= 0; --counter) {
                this.lsbCache[counter] = 127;
            }
        }

        public int getLeftSideBearing(char aChar) {
            int index = aChar - 87;
            assert (index >= 0 && index < 1);
            byte lsb = this.lsbCache[index];
            if (lsb == 127) {
                Object aaHint;
                LSBCacheEntry.oneChar[0] = aChar;
                GlyphVector gv = this.font.createGlyphVector(this.frc, oneChar);
                lsb = (byte)gv.getGlyphPixelBounds((int)0, (FontRenderContext)this.frc, (float)0.0f, (float)0.0f).x;
                if (lsb < 0 && ((aaHint = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                    lsb = (byte)(lsb + 1);
                }
                this.lsbCache[index] = lsb;
            }
            return lsb;
        }

        public boolean equals(Object entry) {
            if (entry == this) {
                return true;
            }
            if (!(entry instanceof LSBCacheEntry)) {
                return false;
            }
            LSBCacheEntry oEntry = (LSBCacheEntry)entry;
            return this.font.equals(oEntry.font) && this.frc.equals(oEntry.frc);
        }

        public int hashCode() {
            int result2 = 17;
            if (this.font != null) {
                result2 = 37 * result2 + this.font.hashCode();
            }
            if (this.frc != null) {
                result2 = 37 * result2 + this.frc.hashCode();
            }
            return result2;
        }
    }
}

