/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Checksum;

public final class CRC32
implements Checksum {
    private int v = 0;
    private static int[] crc_table = null;
    private static final int GF2_DIM = 32;

    public void update(byte[] buf, int index, int len) {
        int c2 = ~this.v;
        while (--len >= 0) {
            c2 = crc_table[(c2 ^ buf[index++]) & 0xFF] ^ c2 >>> 8;
        }
        this.v = ~c2;
    }

    public void reset() {
        this.v = 0;
    }

    public void reset(long vv) {
        this.v = (int)(vv & 0xFFFFFFFFL);
    }

    public long getValue() {
        return (long)this.v & 0xFFFFFFFFL;
    }

    static long combine(long crc1, long crc2, long len2) {
        long[] even = new long[32];
        long[] odd = new long[32];
        if (len2 <= 0L) {
            return crc1;
        }
        odd[0] = 3988292384L;
        long row = 1L;
        for (int n2 = 1; n2 < 32; ++n2) {
            odd[n2] = row;
            row <<= 1;
        }
        CRC32.gf2_matrix_square(even, odd);
        CRC32.gf2_matrix_square(odd, even);
        do {
            CRC32.gf2_matrix_square(even, odd);
            if ((len2 & 1L) != 0L) {
                crc1 = CRC32.gf2_matrix_times(even, crc1);
            }
            if ((len2 >>= 1) == 0L) break;
            CRC32.gf2_matrix_square(odd, even);
            if ((len2 & 1L) == 0L) continue;
            crc1 = CRC32.gf2_matrix_times(odd, crc1);
        } while ((len2 >>= 1) != 0L);
        return crc1 ^= crc2;
    }

    private static long gf2_matrix_times(long[] mat, long vec) {
        long sum2 = 0L;
        int index = 0;
        while (vec != 0L) {
            if ((vec & 1L) != 0L) {
                sum2 ^= mat[index];
            }
            vec >>= 1;
            ++index;
        }
        return sum2;
    }

    static final void gf2_matrix_square(long[] square, long[] mat) {
        for (int n2 = 0; n2 < 32; ++n2) {
            square[n2] = CRC32.gf2_matrix_times(mat, mat[n2]);
        }
    }

    public CRC32 copy() {
        CRC32 foo = new CRC32();
        foo.v = this.v;
        return foo;
    }

    public static int[] getCRC32Table() {
        int[] tmp = new int[crc_table.length];
        System.arraycopy(crc_table, 0, tmp, 0, tmp.length);
        return tmp;
    }

    static {
        crc_table = new int[256];
        for (int n2 = 0; n2 < 256; ++n2) {
            int c2 = n2;
            int k2 = 8;
            while (--k2 >= 0) {
                if ((c2 & 1) != 0) {
                    c2 = 0xEDB88320 ^ c2 >>> 1;
                    continue;
                }
                c2 >>>= 1;
            }
            CRC32.crc_table[n2] = c2;
        }
    }
}

