/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.core.typeahead;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface TypeAheadTerminalModel {
    public void insertCharacter(char var1, int var2);

    public void removeCharacters(int var1, int var2);

    public void moveCursor(int var1);

    public void forceRedraw();

    public void clearPredictions();

    public void lock();

    public void unlock();

    public boolean isUsingAlternateBuffer();

    @NotNull
    public LineWithCursorX getCurrentLineWithCursor();

    public int getTerminalWidth();

    public boolean isTypeAheadEnabled();

    public long getLatencyThreshold();

    public ShellType getShellType();

    public static ShellType commandLineToShellType(List<String> commandLine) {
        if (commandLine == null || commandLine.isEmpty()) {
            return ShellType.Unknown;
        }
        String command2 = commandLine.get(0);
        if (command2.endsWith("bash")) {
            return ShellType.Bash;
        }
        if (command2.endsWith("zsh")) {
            return ShellType.Zsh;
        }
        return ShellType.Unknown;
    }

    public static class LineWithCursorX {
        @NotNull
        public final StringBuffer myLineText;
        public int myCursorX;

        public LineWithCursorX(@NotNull StringBuffer terminalLine, int cursorX) {
            this.myLineText = terminalLine;
            this.myCursorX = cursorX;
        }

        @NotNull
        public LineWithCursorX copy() {
            return new LineWithCursorX(new StringBuffer(this.myLineText), this.myCursorX);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof LineWithCursorX)) {
                return false;
            }
            LineWithCursorX that = (LineWithCursorX)o2;
            return this.myCursorX == that.myCursorX && this.myLineText.toString().stripTrailing().equals(that.myLineText.toString().stripTrailing());
        }

        public int hashCode() {
            return Objects.hash(this.myLineText, this.myCursorX);
        }

        void moveToWordBoundary(boolean isDirectionRight, ShellType shellType) {
            switch (shellType) {
                default: {
                    this.moveToWordBoundaryBash(isDirectionRight);
                    break;
                }
                case Zsh: {
                    this.moveToWordBoundaryZsh(isDirectionRight);
                }
            }
        }

        private void moveToWordBoundaryZsh(boolean isDirectionRight) {
            String text = this.myLineText.toString();
            String defaultWordChars = "*?_-.[]~=/&;!#$%^(){}<>";
            if (isDirectionRight) {
                while (this.myCursorX < text.length() && (Character.isLetterOrDigit(text.charAt(this.myCursorX)) || defaultWordChars.indexOf(text.charAt(this.myCursorX)) != -1)) {
                    ++this.myCursorX;
                }
                while (this.myCursorX < text.length() && !Character.isLetterOrDigit(text.charAt(this.myCursorX)) && defaultWordChars.indexOf(text.charAt(this.myCursorX)) == -1) {
                    ++this.myCursorX;
                }
            } else {
                --this.myCursorX;
                while (this.myCursorX >= 0 && !Character.isLetterOrDigit(text.charAt(this.myCursorX)) && defaultWordChars.indexOf(text.charAt(this.myCursorX)) == -1) {
                    --this.myCursorX;
                }
                while (this.myCursorX >= 0 && (Character.isLetterOrDigit(text.charAt(this.myCursorX)) || defaultWordChars.indexOf(text.charAt(this.myCursorX)) != -1)) {
                    --this.myCursorX;
                }
                ++this.myCursorX;
            }
        }

        private void moveToWordBoundaryBash(boolean isDirectionRight) {
            String text = this.myLineText.toString();
            if (!isDirectionRight) {
                --this.myCursorX;
            }
            boolean ateLeadingWhitespace = false;
            while (this.myCursorX >= 0) {
                if (this.myCursorX >= text.length()) {
                    return;
                }
                char currentChar = text.charAt(this.myCursorX);
                if (Character.isLetterOrDigit(currentChar)) {
                    ateLeadingWhitespace = true;
                } else if (ateLeadingWhitespace) break;
                this.myCursorX += isDirectionRight ? 1 : -1;
            }
            if (!isDirectionRight) {
                ++this.myCursorX;
            }
        }
    }

    public static enum ShellType {
        Bash,
        Zsh,
        Unknown;

    }
}

