/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.TerminalCopyPasteHandler;
import com.jediterm.terminal.ui.UtilKt;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTerminalCopyPasteHandler
implements TerminalCopyPasteHandler,
ClipboardOwner {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTerminalCopyPasteHandler.class);

    @Override
    public void setContents(@NotNull String text, boolean useSystemSelectionClipboardIfAvailable) {
        Clipboard systemSelectionClipboard;
        if (useSystemSelectionClipboardIfAvailable && (systemSelectionClipboard = DefaultTerminalCopyPasteHandler.getSystemSelectionClipboard()) != null) {
            this.setClipboardContents(new StringSelection(text), systemSelectionClipboard);
            return;
        }
        this.setSystemClipboardContents(text);
    }

    @Override
    @Nullable
    public String getContents(boolean useSystemSelectionClipboardIfAvailable) {
        Clipboard systemSelectionClipboard;
        if (useSystemSelectionClipboardIfAvailable && (systemSelectionClipboard = DefaultTerminalCopyPasteHandler.getSystemSelectionClipboard()) != null) {
            return this.getClipboardContents(systemSelectionClipboard);
        }
        return this.getSystemClipboardContents();
    }

    protected void setSystemClipboardContents(@NotNull String text) {
        this.setClipboardContents(new StringSelection(text), DefaultTerminalCopyPasteHandler.getSystemClipboard());
    }

    @Nullable
    private String getSystemClipboardContents() {
        return this.getClipboardContents(DefaultTerminalCopyPasteHandler.getSystemClipboard());
    }

    private void setClipboardContents(@NotNull Transferable contents, @Nullable Clipboard clipboard) {
        if (clipboard != null) {
            try {
                clipboard.setContents(contents, this);
            }
            catch (IllegalStateException e2) {
                DefaultTerminalCopyPasteHandler.logException("Cannot set contents", e2);
            }
        }
    }

    @Nullable
    private String getClipboardContents(@Nullable Clipboard clipboard) {
        if (clipboard != null) {
            try {
                if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    return (String)clipboard.getData(DataFlavor.stringFlavor);
                }
            }
            catch (Exception e2) {
                DefaultTerminalCopyPasteHandler.logException("Cannot get clipboard contents", e2);
            }
        }
        return null;
    }

    @Nullable
    private static Clipboard getSystemClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (IllegalStateException e2) {
            DefaultTerminalCopyPasteHandler.logException("Cannot get system clipboard", e2);
            return null;
        }
    }

    @Nullable
    private static Clipboard getSystemSelectionClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemSelection();
        }
        catch (IllegalStateException e2) {
            DefaultTerminalCopyPasteHandler.logException("Cannot get system selection clipboard", e2);
            return null;
        }
    }

    private static void logException(@NotNull String message, @NotNull Exception e2) {
        if (UtilKt.isWindows() && e2 instanceof IllegalStateException) {
            LOG.debug(message, (Throwable)e2);
        } else {
            LOG.warn(message, (Throwable)e2);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

