/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.TerminalColor;
import java.util.EnumSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextStyle {
    private static final EnumSet<Option> NO_OPTIONS = EnumSet.noneOf(Option.class);
    public static final TextStyle EMPTY = new TextStyle();
    private final TerminalColor myForeground;
    private final TerminalColor myBackground;
    private final EnumSet<Option> myOptions;

    public TextStyle() {
        this(null, null, NO_OPTIONS);
    }

    public TextStyle(@Nullable TerminalColor foreground, @Nullable TerminalColor background) {
        this(foreground, background, NO_OPTIONS);
    }

    public TextStyle(@Nullable TerminalColor foreground, @Nullable TerminalColor background, @NotNull EnumSet<Option> options) {
        this.myForeground = foreground;
        this.myBackground = background;
        this.myOptions = options.clone();
    }

    @Nullable
    public TerminalColor getForeground() {
        return this.myForeground;
    }

    @Nullable
    public TerminalColor getBackground() {
        return this.myBackground;
    }

    public TextStyle createEmptyWithColors() {
        return new TextStyle(this.myForeground, this.myBackground);
    }

    public boolean hasOption(Option option2) {
        return this.myOptions.contains((Object)option2);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TextStyle textStyle = (TextStyle)o2;
        return Objects.equals(this.myForeground, textStyle.myForeground) && Objects.equals(this.myBackground, textStyle.myBackground) && this.myOptions.equals(textStyle.myOptions);
    }

    public int hashCode() {
        return Objects.hash(this.myForeground, this.myBackground, this.myOptions);
    }

    @NotNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private TerminalColor myForeground;
        private TerminalColor myBackground;
        private final EnumSet<Option> myOptions;

        public Builder(@NotNull TextStyle textStyle) {
            this.myForeground = textStyle.myForeground;
            this.myBackground = textStyle.myBackground;
            this.myOptions = textStyle.myOptions.clone();
        }

        public Builder() {
            this.myForeground = null;
            this.myBackground = null;
            this.myOptions = EnumSet.noneOf(Option.class);
        }

        @NotNull
        public Builder setForeground(@Nullable TerminalColor foreground) {
            this.myForeground = foreground;
            return this;
        }

        @NotNull
        public Builder setBackground(@Nullable TerminalColor background) {
            this.myBackground = background;
            return this;
        }

        @NotNull
        public Builder setOption(@NotNull Option option2, boolean val) {
            option2.set(this.myOptions, val);
            return this;
        }

        @NotNull
        public TextStyle build() {
            return new TextStyle(this.myForeground, this.myBackground, this.myOptions);
        }
    }

    public static enum Option {
        BOLD,
        ITALIC,
        SLOW_BLINK,
        RAPID_BLINK,
        DIM,
        INVERSE,
        UNDERLINED,
        HIDDEN;


        private void set(@NotNull EnumSet<Option> options, boolean val) {
            if (val) {
                options.add(this);
            } else {
                options.remove((Object)this);
            }
        }
    }
}

