/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.TerminalLine;
import org.jetbrains.annotations.NotNull;

public abstract class TerminalLineIntervalHighlighting {
    private final TerminalLine myLine;
    private final int myStartOffset;
    private final int myEndOffset;
    private final TextStyle myStyle;
    private boolean myDisposed = false;

    TerminalLineIntervalHighlighting(@NotNull TerminalLine line, int startOffset, int length, @NotNull TextStyle style2) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("Negative startOffset: " + startOffset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Negative length: " + length);
        }
        this.myLine = line;
        this.myStartOffset = startOffset;
        this.myEndOffset = startOffset + length;
        this.myStyle = style2;
    }

    @NotNull
    public TerminalLine getLine() {
        return this.myLine;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public final void dispose() {
        this.doDispose();
        this.myDisposed = true;
    }

    protected abstract void doDispose();

    public boolean intersectsWith(int otherStartOffset, int otherEndOffset) {
        return this.myEndOffset > otherStartOffset && otherEndOffset > this.myStartOffset;
    }

    @NotNull
    public TextStyle mergeWith(@NotNull TextStyle style2) {
        TerminalColor background;
        TerminalColor foreground = this.myStyle.getForeground();
        if (foreground == null) {
            foreground = style2.getForeground();
        }
        if ((background = this.myStyle.getBackground()) == null) {
            background = style2.getBackground();
        }
        return new TextStyle(foreground, background);
    }

    public String toString() {
        return "startOffset=" + this.myStartOffset + ", endOffset=" + this.myEndOffset + ", disposed=" + this.myDisposed;
    }
}

