/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.core.compatibility.Point;
import com.jediterm.terminal.model.SelectionUtil;
import kotlin.Pair;
import org.jetbrains.annotations.Nullable;

public class TerminalSelection {
    private final Point myStart;
    private Point myEnd;

    public TerminalSelection(Point start) {
        this.myStart = start;
    }

    public TerminalSelection(Point start, Point end) {
        this.myStart = start;
        this.myEnd = end;
    }

    public Point getStart() {
        return this.myStart;
    }

    public Point getEnd() {
        return this.myEnd;
    }

    public void updateEnd(Point end) {
        this.myEnd = end;
    }

    public Pair<Point, Point> pointsForRun(int width) {
        Pair<Point, Point> p2 = SelectionUtil.sortPoints(new Point(this.myStart), new Point(this.myEnd));
        ((Point)p2.getSecond()).x = Math.min(((Point)p2.getSecond()).x + 1, width);
        return p2;
    }

    public boolean contains(Point toTest) {
        return this.intersects(toTest.x, toTest.y, 1);
    }

    public void shiftY(int dy) {
        this.myStart.y += dy;
        this.myEnd.y += dy;
    }

    public boolean intersects(int x2, int row, int length) {
        return null != this.intersect(x2, row, length);
    }

    @Nullable
    public Pair<Integer, Integer> intersect(int x2, int row, int length) {
        int newLength;
        int newX = x2;
        Pair<Point, Point> p2 = SelectionUtil.sortPoints(new Point(this.myStart), new Point(this.myEnd));
        if (((Point)p2.getFirst()).y == row) {
            newX = Math.max(x2, ((Point)p2.getFirst()).x);
        }
        if ((newLength = ((Point)p2.getSecond()).y == row ? Math.min(((Point)p2.getSecond()).x, x2 + length - 1) - newX + 1 : length - newX + x2) <= 0 || row < ((Point)p2.getFirst()).y || row > ((Point)p2.getSecond()).y) {
            return null;
        }
        return new Pair((Object)newX, (Object)newLength);
    }

    public String toString() {
        return "[x=" + this.myStart.x + ",y=" + this.myStart.y + "] -> [x=" + this.myEnd.x + ",y=" + this.myEnd.y + "]";
    }
}

