/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.ui.JediTermSearchComponent;
import com.jediterm.terminal.ui.JediTermSearchComponentListener;
import com.jediterm.terminal.ui.JediTermWidget;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicArrowButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JediTermDefaultSearchComponent
extends JPanel
implements JediTermSearchComponent {
    private final JTextField myTextField = new JTextField();
    private final JLabel label = new JLabel();
    private final JCheckBox ignoreCaseCheckBox = new JCheckBox("Ignore Case", true);
    private final List<JediTermSearchComponentListener> myListeners = new CopyOnWriteArrayList<JediTermSearchComponentListener>();
    private final JediTermSearchComponentListener myMulticaster = this.createMulticaster();

    public JediTermDefaultSearchComponent(JediTermWidget jediTermWidget) {
        JButton next2 = this.createNextButton();
        next2.addActionListener(e2 -> this.myMulticaster.selectNextFindResult());
        JButton prev = this.createPrevButton();
        prev.addActionListener(e2 -> this.myMulticaster.selectPrevFindResult());
        this.myTextField.setPreferredSize(new Dimension(jediTermWidget.myTerminalPanel.myCharSize.width * 30, jediTermWidget.myTerminalPanel.myCharSize.height + 3));
        this.myTextField.setEditable(true);
        this.updateLabel(null);
        this.add(this.myTextField);
        this.listenForChanges();
        this.add(this.ignoreCaseCheckBox);
        this.add(this.label);
        this.add(next2);
        this.add(prev);
        this.setOpaque(true);
    }

    private void listenForChanges() {
        final Runnable settingsChanged = () -> this.myMulticaster.searchSettingsChanged(this.myTextField.getText(), this.ignoreCaseCheckBox.isSelected());
        this.myTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e2) {
                settingsChanged.run();
            }

            @Override
            public void removeUpdate(DocumentEvent e2) {
                settingsChanged.run();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
                settingsChanged.run();
            }
        });
        this.ignoreCaseCheckBox.addItemListener(e2 -> settingsChanged.run());
    }

    private JButton createNextButton() {
        return new BasicArrowButton(5);
    }

    private JButton createPrevButton() {
        return new BasicArrowButton(1);
    }

    private void updateLabel(@Nullable SubstringFinder.FindResult result2) {
        if (result2 == null) {
            this.label.setText("");
        } else if (!result2.getItems().isEmpty()) {
            SubstringFinder.FindResult.FindItem selectedItem = result2.selectedItem();
            this.label.setText(selectedItem.getIndex() + " of " + result2.getItems().size());
        }
    }

    @Override
    public void onResultUpdated( @Nullable SubstringFinder.FindResult results) {
        this.updateLabel(results);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void addListener(@NotNull JediTermSearchComponentListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void requestFocus() {
        this.myTextField.requestFocus();
    }

    @Override
    public void addKeyListener(@NotNull KeyListener listener) {
        this.myTextField.addKeyListener(listener);
    }

    @NotNull
    private JediTermSearchComponentListener createMulticaster() {
        Class<JediTermSearchComponentListener> listenerClass = JediTermSearchComponentListener.class;
        return (JediTermSearchComponentListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, (object, method, params) -> {
            for (JediTermSearchComponentListener listener : this.myListeners) {
                method.invoke((Object)listener, params);
            }
            return null;
        });
    }
}

