/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.cef.misc.CefLog;

public abstract class RemoteServerObjectLocal {
    protected final int myId;
    protected final RpcContext myRpc;
    protected final Map<String, String> myCache = new HashMap<String, String>();

    public RemoteServerObjectLocal(RpcContext rpcContext, RObject robj) {
        this.myId = robj.objId;
        this.myRpc = rpcContext;
        if (robj.objInfo != null) {
            this.myCache.putAll(robj.objInfo);
        }
    }

    public abstract void flush();

    public RObject thriftId() {
        return new RObject(false, this.myId);
    }

    public RObject thriftIdWithCache() {
        return new RObject(false, this.myId).setObjInfo(this.myCache);
    }

    protected void onThriftException(TException e2) {
        CefLog.Error("thrift exception '%s'", e2.getMessage());
        StringWriter sw = new StringWriter();
        e2.printStackTrace(new PrintWriter(sw));
        CefLog.Error(sw.getBuffer().toString(), new Object[0]);
    }

    protected long getLongVal(String key) {
        return this.getLongVal(key, 0L);
    }

    protected long getLongVal(String key, long def2) {
        String sval = this.myCache.get(key);
        if (sval == null || sval.isEmpty()) {
            return def2;
        }
        try {
            return Long.parseLong(sval);
        }
        catch (NumberFormatException e2) {
            CefLog.Error("not long value: %s -> %s", key, sval);
            return def2;
        }
    }

    protected boolean getBoolVal(String key) {
        return this.getBoolVal(key, false);
    }

    protected boolean getBoolVal(String key, boolean def2) {
        String sval = this.myCache.get(key);
        if (sval == null || sval.isEmpty()) {
            return def2;
        }
        try {
            return Boolean.parseBoolean(sval);
        }
        catch (NumberFormatException e2) {
            CefLog.Error("not bool value: %s -> %s", key, sval);
            return def2;
        }
    }

    protected void setStrVal(String key, String value) {
        if (value == null || value.isEmpty()) {
            this.myCache.remove(key);
        } else {
            this.myCache.put(key, value);
        }
    }

    protected void setLongVal(String key, long value) {
        this.myCache.put(key, String.valueOf(value));
    }
}

