/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.WindowsPipe;
import com.jetbrains.cef.remote.WindowsPipeServerSocket;
import com.jetbrains.cef.remote.WindowsPipeSocket;
import com.jetbrains.cef.remote.thrift.transport.TIOStreamTransport;
import com.jetbrains.cef.remote.thrift.transport.TServerSocket;
import com.jetbrains.cef.remote.thrift.transport.TServerTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransportException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.cef.OS;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class ThriftTransport {
    private static final boolean IS_TCP_USED;
    private static final int PORT_CEF_SERVER;
    private static final int PORT_JAVA_HANDLERS;
    private static final String PIPENAME_JAVA_HANDLERS;
    private static final String PIPENAME_CEF_SERVER;
    private static final long PID;
    private static final String SUFFIX;
    private static final Path PIPE_DIR;
    private final String myPipe;
    private final int myPort;
    public static final ThriftTransport ourDefaultServer;
    public static final ThriftTransport ourDefaultClient;

    public ThriftTransport(File pipe) {
        this.myPipe = OS.isWindows() ? pipe.getName() : pipe.getAbsolutePath();
        this.myPort = 0;
    }

    public ThriftTransport(String pipe) {
        this.myPipe = pipe;
        this.myPort = 0;
    }

    public ThriftTransport(int port) {
        this.myPipe = null;
        this.myPort = port;
    }

    public boolean isTcp() {
        return this.myPipe == null;
    }

    public String getPipe() {
        return this.myPipe;
    }

    public int getPort() {
        return this.myPort;
    }

    public String toString() {
        return this.myPipe != null ? String.format("pipe='%s'", this.myPipe) : String.format("port=%d", this.myPort);
    }

    public String toStringShort() {
        return this.myPipe != null ? String.format("pipe_%s", this.myPipe).trim().replace(" ", "") : String.format("port_%d", this.myPort);
    }

    public void close() {
        if (!OS.isWindows() && !this.isTcp()) {
            new File(this.myPipe).delete();
        }
    }

    public static String getJavaHandlersPipe(String suffix) {
        if (OS.isWindows()) {
            return PIPENAME_JAVA_HANDLERS + "_" + suffix;
        }
        return PIPE_DIR.resolve(PIPENAME_JAVA_HANDLERS + "_" + suffix).toString();
    }

    public static String getServerPipe(String suffix) {
        if (OS.isWindows()) {
            return PIPENAME_CEF_SERVER + "_" + suffix;
        }
        return PIPE_DIR.resolve(PIPENAME_CEF_SERVER + "_" + suffix).toString();
    }

    public static boolean isTcpUsed() {
        return IS_TCP_USED;
    }

    public static String getUniqueSuffix() {
        return SUFFIX;
    }

    private static int getServerPort() {
        return PORT_CEF_SERVER;
    }

    private static int getJavaHandlersPort() {
        return PORT_JAVA_HANDLERS;
    }

    public static int findFreePort(Set<Integer> exclude) {
        return ThriftTransport.findFreePort(6188, 7777, exclude);
    }

    public static int findFreePort(int from, int to, Set<Integer> exclude) {
        for (int port = from; port < to; ++port) {
            if (exclude != null && exclude.contains(port)) continue;
            try {
                ServerSocket ss = new ServerSocket(port, 0, InetAddress.getByName(null));
                ss.close();
                return port;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public TServerTransport createServerTransport() throws Exception {
        if (this.isTcp()) {
            return new TServerSocket(new InetSocketAddress(InetAddress.getByName(null), this.myPort));
        }
        if (OS.isWindows()) {
            final WindowsPipeServerSocket pipeSocket = new WindowsPipeServerSocket(this.myPipe);
            return new TServerTransport(){

                @Override
                public void listen() {
                }

                @Override
                public TTransport accept() throws TTransportException {
                    try {
                        Socket client2 = pipeSocket.accept();
                        return client2 != null ? new TIOStreamTransport(client2.getInputStream(), client2.getOutputStream()) : null;
                    }
                    catch (IOException e2) {
                        CefLog.Debug("Exception occurred during pipe listening: %s", e2);
                        throw new TTransportException(0, e2.getMessage());
                    }
                }

                @Override
                public void close() {
                    try {
                        pipeSocket.close();
                    }
                    catch (IOException e2) {
                        CefLog.Error("Exception occurred during pipe closing: %s", e2);
                    }
                }
            };
        }
        new File(this.myPipe).delete();
        final ServerSocketChannel serverChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
        serverChannel.bind(UnixDomainSocketAddress.of(this.myPipe));
        return new TServerTransport(){

            @Override
            public void listen() {
            }

            @Override
            public TTransport accept() throws TTransportException {
                try {
                    SocketChannel channel = serverChannel.accept();
                    BufferedInputStream is = new BufferedInputStream(Channels.newInputStream(channel));
                    BufferedOutputStream os = new BufferedOutputStream(Channels.newOutputStream(channel));
                    return new TIOStreamTransport(is, (OutputStream)os);
                }
                catch (IOException e2) {
                    CefLog.Debug("Exception occurred during pipe listening: %s", e2);
                    throw new TTransportException(0, e2.getMessage());
                }
            }

            @Override
            public void close() {
                try {
                    serverChannel.close();
                }
                catch (IOException e2) {
                    CefLog.Error("Exception occurred during pipe closing: %s", e2);
                }
            }
        };
    }

    public TIOStreamTransport openPipeTransport() throws TTransportException {
        try {
            Runnable closer;
            OutputStream os;
            InputStream is;
            if (OS.isWindows()) {
                WindowsPipeSocket pipe = new WindowsPipeSocket(this.myPipe);
                is = pipe.getInputStream();
                os = pipe.getOutputStream();
                closer = () -> {
                    try {
                        pipe.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                };
            } else {
                SocketChannel channel = SocketChannel.open(StandardProtocolFamily.UNIX);
                UnixDomainSocketAddress socketAddress = UnixDomainSocketAddress.of(this.myPipe);
                channel.connect(socketAddress);
                is = Channels.newInputStream(channel);
                os = Channels.newOutputStream(channel);
                closer = () -> {
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                };
            }
            return new TIOStreamTransport(is, os){

                @Override
                public void close() {
                    closer.run();
                }
            };
        }
        catch (IOException e2) {
            throw new TTransportException(e2.getMessage());
        }
    }

    public static File[] findPipes() {
        if (OS.isWindows()) {
            String[] pipes = WindowsPipe.findPipes(PIPENAME_CEF_SERVER + "*");
            if (pipes == null || pipes.length == 0) {
                return null;
            }
            File[] result2 = new File[pipes.length];
            for (int i2 = 0; i2 < pipes.length; ++i2) {
                result2[i2] = new File(pipes[i2]);
            }
            return result2;
        }
        return PIPE_DIR.toFile().listFiles((dir, name) -> name.startsWith(PIPENAME_CEF_SERVER));
    }

    private static String normalizePipeName(String pipeName) {
        if (OS.isWindows()) {
            return pipeName;
        }
        if (pipeName == null || pipeName.isEmpty()) {
            return null;
        }
        if (pipeName.length() < 100) {
            return pipeName;
        }
        SimpleDateFormat f2 = new SimpleDateFormat("mm_ss_SSS");
        String newShortName = "cc_" + f2.format(new Date());
        String newName = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve(newShortName).toString();
        if (newName.length() < 100) {
            return newName;
        }
        return "/var/tmp/" + newShortName;
    }

    static {
        PID = ProcessHandle.current().pid();
        PIPE_DIR = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
        boolean bl2 = IS_TCP_USED = !Utils.getBoolean("CEF_SERVER_USE_PIPE");
        if (!Utils.getBoolean("DONT_JCEF_USE_UNIQUE_NAMES")) {
            SimpleDateFormat f2 = new SimpleDateFormat("hh_mm_ss_SSS");
            SUFFIX = "_" + PID + "_" + f2.format(new Date());
        } else {
            SUFFIX = "_" + PID;
        }
        if (IS_TCP_USED) {
            int customPort = Utils.getInteger("ALT_CEF_SERVER_PORT", -1);
            if (customPort == -1) {
                PORT_CEF_SERVER = ThriftTransport.findFreePort(null);
                if (PORT_CEF_SERVER == -1) {
                    CefLog.Error("Can't find free tcp-port for server.", new Object[0]);
                } else {
                    CefLog.Info("Found free tcp-port %d for server.", PORT_CEF_SERVER);
                }
            } else {
                CefLog.Info("Use custom tcp-port %d for server.", customPort);
                PORT_CEF_SERVER = customPort;
            }
            customPort = Utils.getInteger("ALT_JAVA_HANDLERS_PORT", -1);
            if (customPort == -1) {
                HashSet<Integer> exclude = new HashSet<Integer>();
                exclude.add(PORT_CEF_SERVER);
                PORT_JAVA_HANDLERS = ThriftTransport.findFreePort(exclude);
                if (PORT_JAVA_HANDLERS == -1) {
                    CefLog.Error("Can't find free tcp-port for java-handlers.", new Object[0]);
                } else {
                    CefLog.Info("Found free tcp-port %d for java-handlers.", PORT_JAVA_HANDLERS);
                }
            } else {
                CefLog.Info("Use custom tcp-port %d for java-handlers.", customPort);
                PORT_JAVA_HANDLERS = customPort;
            }
            ourDefaultServer = new ThriftTransport(ThriftTransport.getServerPort());
            ourDefaultClient = new ThriftTransport(ThriftTransport.getJavaHandlersPort());
            PIPENAME_JAVA_HANDLERS = "";
            PIPENAME_CEF_SERVER = "";
        } else {
            Object pipe;
            String suffixJava;
            String suffixServer;
            PORT_CEF_SERVER = 0;
            PORT_JAVA_HANDLERS = 0;
            String pipeServerDefault = "cef_server_pipe";
            String pipeServerCustom = Utils.getString("ALT_CEF_SERVER_PIPE");
            if (pipeServerCustom == null || pipeServerCustom.isEmpty()) {
                PIPENAME_CEF_SERVER = "cef_server_pipe";
                suffixServer = SUFFIX;
            } else {
                PIPENAME_CEF_SERVER = pipeServerCustom;
                suffixServer = "";
            }
            String pipeJavaDefault = "client_pipe";
            String pipeJavaCustom = Utils.getString("ALT_JAVA_HANDLERS_PIPE");
            if (pipeJavaCustom == null || pipeJavaCustom.isEmpty()) {
                PIPENAME_JAVA_HANDLERS = pipeJavaDefault;
                suffixJava = SUFFIX;
            } else {
                PIPENAME_JAVA_HANDLERS = pipeJavaCustom;
                suffixJava = "";
            }
            if (OS.isWindows()) {
                pipe = PIPENAME_CEF_SERVER + suffixServer;
            } else {
                pipe = PIPE_DIR.resolve(PIPENAME_CEF_SERVER + suffixServer).toString();
                pipe = ThriftTransport.normalizePipeName((String)pipe);
            }
            ourDefaultServer = new ThriftTransport((String)pipe);
            if (OS.isWindows()) {
                pipe = PIPENAME_JAVA_HANDLERS + suffixJava;
            } else {
                pipe = PIPE_DIR.resolve(PIPENAME_JAVA_HANDLERS + suffixJava).toString();
                pipe = ThriftTransport.normalizePipeName((String)pipe);
            }
            ourDefaultClient = new ThriftTransport((String)pipe);
        }
    }
}

