/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.browser;

import com.jetbrains.cef.remote.PlatformUtils;
import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.browser.RemoteClient;
import com.jetbrains.cef.remote.browser.RemoteDevToolsMessageObserver;
import com.jetbrains.cef.remote.browser.RemoteFrame;
import com.jetbrains.cef.remote.browser.RemoteRegistration;
import com.jetbrains.cef.remote.browser.RemoteRegistrationImpl;
import com.jetbrains.cef.remote.callback.RemoteIntCallback;
import com.jetbrains.cef.remote.callback.RemotePdfPrintCallback;
import com.jetbrains.cef.remote.callback.RemoteRunFileDialogCallback;
import com.jetbrains.cef.remote.callback.RemoteStringVisitor;
import com.jetbrains.cef.remote.network.RemoteRequest;
import com.jetbrains.cef.remote.network.RemoteRequestContext;
import com.jetbrains.cef.remote.network.RemoteRequestImpl;
import com.jetbrains.cef.remote.thrift_codegen.CefKeyEventAttributes;
import com.jetbrains.cef.remote.thrift_codegen.Color;
import com.jetbrains.cef.remote.thrift_codegen.CompositionUnderline;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import com.jetbrains.cef.remote.thrift_codegen.Range;
import com.jetbrains.cef.remote.thrift_codegen.Style;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefDevToolsClient;
import org.cef.browser.CefDevToolsMessageObserver;
import org.cef.browser.CefFrame;
import org.cef.browser.CefRegistration;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefNativeRenderHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.input.CefCompositionUnderline;
import org.cef.input.CefTouchEvent;
import org.cef.misc.CefLog;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.misc.CefRange;
import org.cef.network.CefRequest;

public class RemoteBrowser
implements CefBrowser {
    private final RpcContext myRpc;
    private final RemoteClient myOwner;
    private final CefClient myCefClient;
    private final RemoteRequestContext myRequestContext;
    private final CefBrowserSettings mySettings;
    private volatile int myBid = -1;
    private String myUrl = null;
    private Component myComponent;
    private CefNativeRenderHandler myRender;
    private final AtomicBoolean myIsNativeBrowserCreationRequested = new AtomicBoolean(false);
    private final AtomicBoolean myIsNativeBrowserCreationStarted = new AtomicBoolean(false);
    private volatile boolean myIsNativeBrowserCreated = false;
    private volatile boolean myIsClosing = false;
    private volatile boolean myIsClosed = false;
    private volatile int myNativeBrowserIdentifier = Integer.MIN_VALUE;
    private final List<Runnable> myDelayedActions = new ArrayList<Runnable>();
    private int myFrameRate = 30;
    private volatile boolean myIsDevToolsOpened = false;
    private volatile CefDevToolsClient myDevToolsClient = null;
    private Point myInspectPoint;

    RemoteBrowser(RpcContext rpcContext, RemoteClient owner, CefClient cefClient, String url, RemoteRequestContext requestContext, CefBrowserSettings settings2) {
        this.myRpc = rpcContext;
        this.myOwner = owner;
        this.myCefClient = cefClient;
        this.myUrl = url;
        this.myRequestContext = requestContext != null ? requestContext : new RemoteRequestContext(this.myRpc.server);
        this.mySettings = settings2;
    }

    public int getBid() {
        return this.myBid;
    }

    public int getCid() {
        return this.myOwner.getCid();
    }

    public RemoteClient getOwner() {
        return this.myOwner;
    }

    public boolean isNativeBrowserCreationStarted() {
        return this.myIsNativeBrowserCreationStarted.get();
    }

    public boolean isNativeBrowserCreated() {
        return this.myIsNativeBrowserCreated;
    }

    public int getNativeBrowserIdentifier() {
        return this.myNativeBrowserIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNativeBrowserCreated(int nativeBrowserIdentifier) {
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            this.myIsNativeBrowserCreated = true;
            this.myNativeBrowserIdentifier = nativeBrowserIdentifier;
            this.myDelayedActions.forEach(r2 -> r2.run());
            this.myDelayedActions.clear();
        }
    }

    public void setComponent(Component component, CefNativeRenderHandler renderHandler) {
        this.myComponent = component;
        this.myRender = renderHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execWhenCreated(Runnable runnable2, String name) {
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            if (this.myIsNativeBrowserCreated) {
                runnable2.run();
            } else {
                CefLog.Debug("%s: add delayed action %s", this, name);
                this.myDelayedActions.add(runnable2);
            }
        }
    }

    @Override
    public void createImmediately() {
        if (!this.myIsNativeBrowserCreationRequested.getAndSet(true)) {
            this.myRpc.server.onConnected(this::requestBid, "requestBid", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestBid() {
        AtomicBoolean atomicBoolean = this.myIsNativeBrowserCreationStarted;
        synchronized (atomicBoolean) {
            if (this.myIsClosing) {
                return;
            }
            this.myIsNativeBrowserCreationStarted.set(true);
            int hmask = this.myOwner.getHandlersMask() | (this.myRender == null ? 0 : RemoteClient.HandlerMasks.NativeRender.val());
            this.myRpc.exec(s2 -> {
                RObject contextHandler = new RObject();
                if (this.myRequestContext.getRemoteHandler() != null) {
                    contextHandler = this.myRequestContext.getRemoteHandler().thriftId();
                }
                this.myBid = s2.Browser_Create(this.myOwner.getCid(), hmask, contextHandler);
            });
            if (this.myBid >= 0) {
                this.myOwner.onNewBid(this);
                CefLog.Debug("Registered bid %d with handlers: %s", this.myBid, RemoteClient.HandlerMasks.toString(hmask));
                this.myRpc.exec(s2 -> s2.Browser_StartNativeCreation(this.myBid, this.myUrl));
            } else {
                CefLog.Error("Can't obtain bid, createBrowser returns %d", this.myBid);
            }
        }
        if (this.myBid >= 0) {
            this.myRequestContext.setBid(this.myBid, this.myRpc);
        }
    }

    @Override
    public Component getUIComponent() {
        return this.myComponent;
    }

    @Override
    public CefClient getClient() {
        return this.myCefClient;
    }

    @Override
    public CefRequestContext getRequestContext() {
        return this.myRequestContext;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this.myRender;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return null;
    }

    @Override
    public boolean canGoBack() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myRpc.execObj(s2 -> s2.Browser_CanGoBack(this.myBid));
    }

    @Override
    public void goBack() {
        if (this.myIsClosing || this.myBid < 0) {
            return;
        }
        this.myRpc.exec(s2 -> s2.Browser_GoBack(this.myBid));
    }

    @Override
    public boolean canGoForward() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myRpc.execObj(s2 -> s2.Browser_CanGoForward(this.myBid));
    }

    @Override
    public void goForward() {
        if (this.myIsClosing || this.myBid < 0) {
            return;
        }
        this.myRpc.exec(s2 -> s2.Browser_GoForward(this.myBid));
    }

    @Override
    public boolean isLoading() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myRpc.execObj(s2 -> s2.Browser_IsLoading(this.myBid));
    }

    @Override
    public void reload() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_Reload(this.myBid)), "reload");
    }

    @Override
    public void reloadIgnoreCache() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_ReloadIgnoreCache(this.myBid)), "reloadIgnoreCache");
    }

    @Override
    public void stopLoad() {
        if (this.myIsClosing || this.myBid < 0) {
            return;
        }
        this.myRpc.exec(s2 -> s2.Browser_StopLoad(this.myBid));
    }

    @Override
    public int getIdentifier() {
        return this.myNativeBrowserIdentifier;
    }

    @Override
    public CefFrame getMainFrame() {
        if (this.myIsClosing) {
            return null;
        }
        if (this.myBid < 0) {
            CefLog.Debug("bid wasn't received yet and getMainFrame will return null.", new Object[0]);
            return null;
        }
        RObject rf = this.myRpc.execObj(s2 -> s2.Browser_GetMainFrame(this.myBid));
        return rf == null || rf.isNull ? null : new RemoteFrame(this.myRpc, rf);
    }

    @Override
    public CefFrame getFocusedFrame() {
        if (this.myIsClosing) {
            return null;
        }
        if (this.myBid < 0) {
            CefLog.Debug("bid wasn't received yet and getFocusedFrame will return null.", new Object[0]);
            return null;
        }
        RObject rf = this.myRpc.execObj(s2 -> s2.Browser_GetFocusedFrame(this.myBid));
        return rf == null || rf.isNull ? null : new RemoteFrame(this.myRpc, rf);
    }

    @Override
    public CefFrame getFrameByIdentifier(String identifier) {
        if (this.myIsClosing) {
            return null;
        }
        if (this.myBid < 0) {
            CefLog.Debug("bid wasn't received yet and getFrameByIdentifier will return null.", new Object[0]);
            return null;
        }
        RObject rf = this.myRpc.execObj(s2 -> s2.Browser_GetFrameByIdentifier(this.myBid, identifier));
        return rf == null || rf.isNull ? null : new RemoteFrame(this.myRpc, rf);
    }

    @Override
    public CefFrame getFrameByName(String name) {
        if (this.myIsClosing) {
            return null;
        }
        if (this.myBid < 0) {
            CefLog.Debug("bid wasn't received yet and getFrameByName will return null.", new Object[0]);
            return null;
        }
        RObject rf = this.myRpc.execObj(s2 -> s2.Browser_GetFrameByName(this.myBid, name));
        return rf == null || rf.isNull ? null : new RemoteFrame(this.myRpc, rf);
    }

    @Override
    public Vector<String> getFrameIdentifiers() {
        if (this.myIsClosing) {
            return null;
        }
        if (this.myBid < 0) {
            CefLog.Debug("bid wasn't received yet and getFrameIdentifiers will return null.", new Object[0]);
            return null;
        }
        List ids = this.myRpc.execObj(s2 -> s2.Browser_GetFrameIdentifiers(this.myBid));
        return ids == null || ids.isEmpty() ? null : new Vector(ids);
    }

    @Override
    public Vector<String> getFrameNames() {
        if (this.myIsClosing) {
            return null;
        }
        if (this.myBid < 0) {
            CefLog.Debug("bid wasn't received yet and getFrameNames will return null.", new Object[0]);
            return null;
        }
        List ids = this.myRpc.execObj(s2 -> s2.Browser_GetFrameNames(this.myBid));
        return ids == null || ids.isEmpty() ? null : new Vector(ids);
    }

    @Override
    public int getFrameCount() {
        if (this.myIsClosing) {
            return 0;
        }
        if (this.myBid < 0) {
            CefLog.Debug("bid wasn't received yet and getFrameCount will return 0.", new Object[0]);
            return 0;
        }
        return this.myRpc.execObj(s2 -> s2.Browser_GetFrameCount(this.myBid));
    }

    @Override
    public boolean isPopup() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myRpc.execObj(s2 -> s2.Browser_IsPopup(this.myBid));
    }

    @Override
    public boolean hasDocument() {
        if (this.myIsClosing || this.myBid < 0) {
            return false;
        }
        return this.myRpc.execObj(s2 -> s2.Browser_HasDocument(this.myBid));
    }

    @Override
    public void viewSource() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_ViewSource(this.myBid)), "viewSource");
    }

    @Override
    public void getSource(CefStringVisitor visitor) {
        if (this.myIsClosing || visitor == null) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> {
            RemoteStringVisitor rvisitor = RemoteStringVisitor.create(visitor);
            s2.Browser_GetSource(this.myBid, rvisitor.thriftId());
        }), "getSource");
    }

    @Override
    public void getText(CefStringVisitor visitor) {
        if (this.myIsClosing || visitor == null) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> {
            RemoteStringVisitor rvisitor = RemoteStringVisitor.create(visitor);
            s2.Browser_GetText(this.myBid, rvisitor.thriftId());
        }), "getText");
    }

    @Override
    public void loadRequest(CefRequest request) {
        if (this.myIsClosing) {
            return;
        }
        if (!(request instanceof RemoteRequest)) {
            CefLog.Error("Unsupported CefRequest: %s", request);
            return;
        }
        this.execWhenCreated(() -> {
            RemoteRequestImpl rr = ((RemoteRequest)request).getImpl();
            if (rr != null) {
                rr.flush();
                this.myRpc.exec(s2 -> s2.Browser_LoadRequest(this.myBid, rr.thriftIdWithCache()));
            } else {
                CefLog.Error("RemoteRequestImpl is null [bid=%d]", this.myBid);
            }
        }, "loadRequest");
    }

    @Override
    public void loadURL(String url) {
        this.myUrl = url;
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_LoadURL(this.myBid, url)), "loadURL");
    }

    @Override
    public void executeJavaScript(String code2, String url, int line) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_ExecuteJavaScript(this.myBid, code2, url, line)), "executeJavaScript");
    }

    @Override
    public String getURL() {
        if (this.myBid < 0) {
            CefLog.Debug("Can't do getURL because bid wasn't created, return cached %s", this.myUrl);
            return this.myUrl;
        }
        if (this.myIsClosing) {
            return this.myUrl;
        }
        return this.myRpc.execObj(s2 -> s2.Browser_GetURL(this.myBid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean force) {
        Object object = this.myIsNativeBrowserCreationStarted;
        synchronized (object) {
            if (this.myIsClosing) {
                return;
            }
            this.myIsClosing = true;
            if (this.myRender != null) {
                this.myRender.disposeNativeResources();
            }
            if (this.myBid >= 0) {
                this.myRpc.exec(s2 -> s2.Browser_Close(this.myBid));
            }
        }
        object = this.myDelayedActions;
        synchronized (object) {
            this.myDelayedActions.clear();
        }
    }

    @Override
    public void setCloseAllowed() {
    }

    @Override
    public boolean doClose() {
        return false;
    }

    @Override
    public void onBeforeClose() {
        this.myIsClosed = true;
        this.myRequestContext.dispose();
        if (this.myIsDevToolsOpened) {
            this.closeDevTools();
        }
        if (this.myDevToolsClient != null) {
            this.myDevToolsClient.close();
        }
    }

    @Override
    public boolean isClosing() {
        return this.myIsClosing;
    }

    @Override
    public boolean isClosed() {
        return this.myIsClosed;
    }

    @Override
    public void setFocus(boolean enable) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_SetFocus(this.myBid, enable)), "setFocus");
    }

    @Override
    public void setWindowVisibility(boolean visible) {
    }

    @Override
    public double getZoomLevel() {
        if (this.myBid < 0) {
            CefLog.Debug("Can't do getZoomLevel because bid wasn't created, return 0", new Object[0]);
            return 0.0;
        }
        if (this.myIsClosing) {
            return 0.0;
        }
        return this.myRpc.execObj(s2 -> s2.Browser_GetZoomLevel(this.myBid));
    }

    @Override
    public void setZoomLevel(double zoomLevel) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_SetZoomLevel(this.myBid, zoomLevel)), "setZoomLevel");
    }

    @Override
    public void runFileDialog(CefDialogHandler.FileDialogMode mode, String title2, String defaultFilePath, Vector<String> acceptFilters, CefRunFileDialogCallback callback) {
        if (this.myIsClosing) {
            return;
        }
        if (callback == null) {
            CefLog.Error("Can't run file dialog because callback is null.", new Object[0]);
            return;
        }
        RemoteRunFileDialogCallback rcallback = RemoteRunFileDialogCallback.create(callback);
        Vector filters = acceptFilters == null ? new Vector() : acceptFilters;
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_RunFileDialog(this.myBid, mode.name(), title2, defaultFilePath, filters, rcallback.thriftId())), "runFileDialog");
    }

    @Override
    public void startDownload(String url) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_StartDownload(this.myBid, url)), "startDownload");
    }

    @Override
    public void print() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_Print(this.myBid)), "print");
    }

    @Override
    public void printToPDF(String path, CefPdfPrintSettings settings2, CefPdfPrintCallback callback) {
        if (this.myIsClosing) {
            return;
        }
        if (callback == null) {
            CefLog.Error("Can't print to pdf because callback is null.", new Object[0]);
            return;
        }
        RemotePdfPrintCallback rcallback = RemotePdfPrintCallback.create(callback);
        HashMap<String, String> printSettings = new HashMap<String, String>();
        if (settings2 != null) {
            printSettings.put("landscape", String.valueOf(settings2.landscape));
            printSettings.put("print_background", String.valueOf(settings2.print_background));
            printSettings.put("scale", String.valueOf(settings2.scale));
            printSettings.put("paper_width", String.valueOf(settings2.paper_width));
            printSettings.put("paper_height", String.valueOf(settings2.paper_height));
            printSettings.put("prefer_css_page_size", String.valueOf(settings2.prefer_css_page_size));
            if (settings2.margin_type != null) {
                printSettings.put("margin_type", String.valueOf((Object)settings2.margin_type));
            }
            printSettings.put("margin_top", String.valueOf(settings2.margin_top));
            printSettings.put("margin_bottom", String.valueOf(settings2.margin_bottom));
            printSettings.put("margin_right", String.valueOf(settings2.margin_right));
            printSettings.put("margin_left", String.valueOf(settings2.margin_left));
            if (settings2.page_ranges != null && !settings2.page_ranges.isEmpty()) {
                printSettings.put("page_ranges", settings2.page_ranges);
            }
            printSettings.put("display_header_footer", String.valueOf(settings2.display_header_footer));
            if (settings2.header_template != null && !settings2.header_template.isEmpty()) {
                printSettings.put("header_template", settings2.header_template);
            }
            if (settings2.footer_template != null && !settings2.footer_template.isEmpty()) {
                printSettings.put("footer_template", settings2.footer_template);
            }
            printSettings.put("generate_document_outline", String.valueOf(settings2.generate_document_outline));
            printSettings.put("generate_tagged_pdf", String.valueOf(settings2.generate_tagged_pdf));
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_PrintToPDF(this.myBid, path, printSettings, rcallback.thriftId())), "printToPDF");
    }

    @Override
    public void find(String searchText, boolean forward, boolean matchCase, boolean findNext) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_Find(this.myBid, searchText, forward, matchCase, findNext)), "find");
    }

    @Override
    public void stopFinding(boolean clearSelection) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_StopFinding(this.myBid, clearSelection)), "stopFinding");
    }

    @Override
    public void openDevTools() {
        this.openDevTools(null);
    }

    @Override
    public void openDevTools(Point inspectAt) {
        if (this.myIsClosing) {
            return;
        }
        if (this.myBid == -1) {
            CefLog.Error("Can't open dev-tools because bid is -1", new Object[0]);
        } else {
            this.myRpc.exec(s2 -> s2.Browser_OpenDevTools(this.myBid, this.myInspectPoint != null ? this.myInspectPoint.x : 0, this.myInspectPoint != null ? this.myInspectPoint.y : 0));
        }
    }

    @Override
    public void closeDevTools() {
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_CloseDevTools(this.myBid)), "closeDevTools");
    }

    @Override
    public CefDevToolsClient getDevToolsClient() {
        if (this.myIsClosing) {
            return null;
        }
        if (this.myDevToolsClient == null || this.myDevToolsClient.isClosed()) {
            this.myDevToolsClient = new CefDevToolsClient(this);
        }
        return this.myDevToolsClient;
    }

    @Override
    public void replaceMisspelling(String word) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_ReplaceMisspelling(this.myBid, word)), "replaceMisspelling");
    }

    @Override
    public void wasResized(int width, int height) {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.invokeLater(s2 -> s2.Browser_WasResized(this.myBid)), "wasResized");
    }

    @Override
    public void invalidate() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.invokeLater(s2 -> s2.Browser_Invalidate(this.myBid)), "invalidate");
    }

    @Override
    public void notifyScreenInfoChanged() {
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.invokeLater(s2 -> s2.Browser_NotifyScreenInfoChanged(this.myBid)), "notifyScreenInfoChanged");
    }

    @Override
    public void sendKeyEvent(KeyEvent e2) {
        if (this.myBid < 0) {
            CefLog.Debug("Skip sendKeyEvent because remote browser wasn't created, bid=%d", this.myBid);
            return;
        }
        if (this.myIsClosing) {
            return;
        }
        CefKeyEventAttributes cefKeyEvent = PlatformUtils.getCefKeyEventAttributes(e2);
        this.myRpc.invokeLater(s2 -> s2.Browser_SendCefKeyEvent(this.myBid, cefKeyEvent));
    }

    @Override
    public void sendMouseEvent(MouseEvent e2) {
        if (this.myBid < 0) {
            CefLog.Debug("Skip sendMouseEvent because remote browser wasn't created, bid=%d", this.myBid);
            return;
        }
        if (this.myIsClosing) {
            return;
        }
        this.myRpc.invokeLater(s2 -> s2.Browser_SendMouseEvent(this.myBid, e2.getID(), e2.getX(), e2.getY(), e2.getModifiersEx(), e2.getClickCount(), e2.getButton()));
    }

    @Override
    public void sendMouseWheelEvent(MouseWheelEvent e2) {
        if (this.myBid < 0) {
            CefLog.Debug("Skip sendMouseWheelEvent because remote browser wasn't created, bid=%d", this.myBid);
            return;
        }
        if (this.myIsClosing) {
            return;
        }
        this.myRpc.invokeLater(s2 -> s2.Browser_SendMouseWheelEvent(this.myBid, e2.getScrollType(), e2.getX(), e2.getY(), e2.getModifiersEx(), e2.getWheelRotation(), e2.getUnitsToScroll()));
    }

    @Override
    public void sendTouchEvent(CefTouchEvent e2) {
        CefLog.Error("UNIMPLEMENTED: sendTouchEvent", new Object[0]);
    }

    @Override
    public CompletableFuture<BufferedImage> createScreenshot(boolean nativeResolution) {
        return null;
    }

    @Override
    public void ImeSetComposition(String text, List<CefCompositionUnderline> cefUnderlines, CefRange cefReplacementRange, CefRange cefSelectionRange) {
        ArrayList<CompositionUnderline> underlineList = new ArrayList<CompositionUnderline>();
        if (cefUnderlines != null) {
            for (CefCompositionUnderline cefUnderline : cefUnderlines) {
                Range range = new Range(cefUnderline.getRange().from, cefUnderline.getRange().to);
                Color color = new Color(cefUnderline.getColor().getRed(), cefUnderline.getColor().getGreen(), cefUnderline.getColor().getBlue(), cefUnderline.getColor().getAlpha());
                Color backgroundColor = new Color(cefUnderline.getBackgroundColor().getRed(), cefUnderline.getBackgroundColor().getGreen(), cefUnderline.getBackgroundColor().getBlue(), cefUnderline.getBackgroundColor().getAlpha());
                Style style2 = Style.NONE;
                switch (cefUnderline.getStyle()) {
                    case SOLID: {
                        style2 = Style.SOLID;
                        break;
                    }
                    case DOT: {
                        style2 = Style.DOT;
                        break;
                    }
                    case DASH: {
                        style2 = Style.DASH;
                    }
                }
                underlineList.add(new CompositionUnderline(range, color, backgroundColor, cefUnderline.getThick(), style2));
            }
        }
        Range replacementRange = new Range(cefReplacementRange.from, cefReplacementRange.to);
        Range selectionRange = new Range(cefSelectionRange.from, cefSelectionRange.to);
        this.myRpc.invokeLater(s2 -> s2.Browser_ImeSetComposition(this.myBid, text, underlineList, replacementRange, selectionRange));
    }

    @Override
    public void ImeCommitText(String text, CefRange cefReplacementRange, int relativeCursorPos) {
        Range replacementRange = new Range(cefReplacementRange.from, cefReplacementRange.to);
        this.myRpc.invokeLater(s2 -> s2.Browser_ImeCommitText(this.myBid, text, replacementRange, relativeCursorPos));
    }

    @Override
    public void ImeFinishComposingText(boolean b2) {
        this.myRpc.invokeLater(s2 -> s2.Browser_ImeFinishComposingText(this.myBid, b2));
    }

    @Override
    public void ImeCancelComposing() {
        this.myRpc.invokeLater(s2 -> s2.Browser_ImeCancelComposing(this.myBid));
    }

    @Override
    public void setWindowlessFrameRate(int frameRate) {
        this.myFrameRate = frameRate;
        if (this.myIsClosing) {
            return;
        }
        this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_SetFrameRate(this.myBid, frameRate)), "setWindowlessFrameRate");
    }

    @Override
    public CompletableFuture<Integer> getWindowlessFrameRate() {
        CefLog.Warn("%s: getWindowlessFrameRate returns cached value %d. TODO: implement real getWindowlessFrameRate.", this, this.myFrameRate);
        CompletableFuture<Integer> result2 = new CompletableFuture<Integer>();
        result2.complete(this.myFrameRate);
        return result2;
    }

    public String toString() {
        return "RemoteBrowser_" + this.myBid;
    }

    public CefRegistration addDevToolsMessageObserver(CefDevToolsMessageObserver observer) {
        if (this.myIsClosing || observer == null) {
            return null;
        }
        if (!this.myIsNativeBrowserCreated) {
            CefLog.Error("Can't add DevToolsMessageObserver because native browser wasn't created", new Object[0]);
            return null;
        }
        RemoteDevToolsMessageObserver robserver = RemoteDevToolsMessageObserver.create(observer);
        RObject registration = this.myRpc.execObj(s2 -> s2.Browser_AddDevToolsMessageObserver(this.myBid, robserver.thriftId()));
        RemoteRegistrationImpl impl2 = new RemoteRegistrationImpl(this.myRpc, registration);
        return new RemoteRegistration(impl2);
    }

    public CompletableFuture<Integer> executeDevToolsMethod(String method, String parametersAsJson) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        if (this.myIsClosing || method == null) {
            future.completeExceptionally(new CefDevToolsClient.DevToolsException(this.myIsClosing ? "Client is closing." : "Method is null."));
        } else if (!this.myIsNativeBrowserCreated) {
            CefLog.Error("Can't execute DevToolsMethod because native browser wasn't created", new Object[0]);
            future.completeExceptionally(new CefDevToolsClient.DevToolsException("Native browser wasn't created"));
        } else {
            RemoteIntCallback ricb = RemoteIntCallback.create(generatedMessageId -> {
                if (generatedMessageId <= 0) {
                    future.completeExceptionally(new CefDevToolsClient.DevToolsException(String.format("Failed to execute DevTools method %s, generatedMessageId=%d", method, generatedMessageId)));
                } else {
                    future.complete((Integer)generatedMessageId);
                }
            });
            this.execWhenCreated(() -> this.myRpc.exec(s2 -> s2.Browser_ExecuteDevToolsMethod(this.myBid, method, parametersAsJson, ricb.thriftId())), String.format("executeDevToolsMethod: %s(%s)", method, parametersAsJson));
        }
        return future;
    }

    @Override
    public boolean isWindowless() {
        return true;
    }
}

