/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.network.RemoteCookieManagerImpl;
import com.jetbrains.cef.remote.thrift_codegen.Cookie;
import java.util.Date;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefCookieVisitor;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;

public class RemoteCookieManager
extends CefCookieManager {
    RemoteCookieManagerImpl myImpl;
    private volatile boolean myIsDisposed = false;

    private RemoteCookieManager(CefServer server) {
        server.onConnected(() -> {
            this.myImpl = RemoteCookieManagerImpl.create(server.getRpcContext());
        }, "CookieManager_Create", true);
    }

    public static RemoteCookieManager createGlobal(CefServer server) {
        return new RemoteCookieManager(server);
    }

    @Override
    public void dispose() {
        this.myIsDisposed = true;
    }

    @Override
    public boolean visitAllCookies(CefCookieVisitor visitor) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.visitAllCookies(visitor);
        }
        throw new RuntimeException("visitAllCookies: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    @Override
    public boolean visitUrlCookies(String url, boolean includeHttpOnly, CefCookieVisitor visitor) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.visitUrlCookies(url, includeHttpOnly, visitor);
        }
        throw new RuntimeException("visitUrlCookies: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    @Override
    public boolean setCookie(String url, CefCookie cookie) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.setCookie(url, cookie);
        }
        throw new RuntimeException("setCookie: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    @Override
    public boolean deleteCookies(String url, String cookieName) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.deleteCookies(url, cookieName);
        }
        throw new RuntimeException("deleteCookies: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    @Override
    public boolean flushStore(CefCompletionCallback handler2) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.flushStore(handler2);
        }
        throw new RuntimeException("flushStore: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    public static CefCookie toCefCookie(Cookie c2) {
        if (c2 == null) {
            return null;
        }
        Date creation = c2.creation == 0L ? null : new Date(c2.creation);
        Date lastAccess = c2.lastAccess == 0L ? null : new Date(c2.lastAccess);
        Date expires = c2.isSetExpires() ? new Date(c2.expires) : null;
        return new CefCookie(c2.name, c2.value, c2.domain, c2.path, c2.secure, c2.httponly, creation, lastAccess, expires != null, expires);
    }

    public static Cookie toThriftCookie(CefCookie c2) {
        if (c2 == null) {
            return null;
        }
        Cookie cookie = new Cookie(c2.name, c2.value, c2.domain, c2.path, c2.secure, c2.httponly, c2.creation == null ? 0L : c2.creation.getTime(), c2.lastAccess == null ? 0L : c2.lastAccess.getTime());
        if (c2.hasExpires && c2.expires != null) {
            cookie.setExpires(c2.expires.getTime());
        }
        return cookie;
    }
}

