/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.router;

import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.router.RemoteMessageRouterImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.misc.CefLog;

public class RemoteMessageRouter
extends CefMessageRouter {
    private RemoteMessageRouterImpl myImpl;
    private final List<Runnable> myDelayedActions = new ArrayList<Runnable>();
    private volatile boolean myIsDisposed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Runnable nativeRunnable, String name) {
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            if (this.myIsDisposed) {
                return;
            }
            if (this.myImpl != null) {
                nativeRunnable.run();
            } else {
                CefLog.Debug("RemoteMessageRouter: %s: add delayed action %s", this, name);
                this.myDelayedActions.add(nativeRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            this.myIsDisposed = true;
            this.myDelayedActions.clear();
            if (this.myImpl != null) {
                this.myImpl.disposeOnServer();
            }
        }
    }

    @Override
    public boolean addHandler(CefMessageRouterHandler handler2, boolean first2) {
        this.execute(() -> this.myImpl.addHandler(handler2, first2), "addHandler");
        return true;
    }

    @Override
    public boolean removeHandler(CefMessageRouterHandler handler2) {
        this.execute(() -> this.myImpl.removeHandler(handler2), "removeHandler");
        return true;
    }

    @Override
    public void cancelPending(CefBrowser browser, CefMessageRouterHandler handler2) {
        this.execute(() -> this.myImpl.cancelPending(browser, handler2), "cancelPending");
    }

    public RemoteMessageRouter(CefServer server, CefMessageRouter.CefMessageRouterConfig config) {
        super(config);
        server.onConnected(() -> {
            RpcContext rpcContext = server.getRpcContext();
            this.myImpl = RemoteMessageRouterImpl.create(rpcContext, this.getMessageRouterConfig());
            List<Runnable> list = this.myDelayedActions;
            synchronized (list) {
                this.myDelayedActions.forEach(r2 -> r2.run());
                this.myDelayedActions.clear();
                if (this.myIsDisposed && this.myImpl != null) {
                    this.myImpl.disposeOnServer();
                }
            }
        }, "MessageRouter_Create", true);
    }

    public RemoteMessageRouterImpl getImpl() {
        return this.myImpl;
    }

    public void addToBrowsers(List<Integer> bids) {
        if (bids == null || bids.isEmpty()) {
            return;
        }
        this.execute(() -> {
            Iterator iterator2 = bids.iterator();
            while (iterator2.hasNext()) {
                int bid = (Integer)iterator2.next();
                if (bid < 0) continue;
                this.myImpl.addToBrowser(bid);
            }
        }, "addToBrowsers");
    }

    public void removeFromBrowsers(List<Integer> bids) {
        if (bids == null || bids.isEmpty()) {
            return;
        }
        this.execute(() -> {
            Iterator iterator2 = bids.iterator();
            while (iterator2.hasNext()) {
                int bid = (Integer)iterator2.next();
                if (bid < 0) continue;
                this.myImpl.removeFromBrowser(bid);
            }
        }, "removeFromBrowsers");
    }
}

