/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift;

import java.text.MessageFormat;
import org.cef.misc.CefLog;

public class Logger {
    private final String name;

    public Logger(String name) {
        this.name = name;
    }

    public void error(String message) {
        CefLog.Error(this.makeMessage(message), new Object[0]);
    }

    public void error(String message, Throwable t2) {
        CefLog.Error(this.makeMessage(message, t2), new Object[0]);
    }

    public void warn(String message) {
        CefLog.Warn(this.makeMessage(message), new Object[0]);
    }

    public void warn(String message, Throwable t2) {
        CefLog.Warn(this.makeMessage(message, t2), new Object[0]);
    }

    public void debug(String message) {
        CefLog.Debug(this.makeMessage(message), new Object[0]);
    }

    public void debug(String message, Throwable t2) {
        CefLog.Debug(this.makeMessage(message, t2), new Object[0]);
    }

    public void info(String message) {
        CefLog.Info(this.makeMessage(message), new Object[0]);
    }

    public void info(String message, Throwable t2) {
        CefLog.Info(this.makeMessage(message, t2), new Object[0]);
    }

    String makeMessage(String message) {
        return MessageFormat.format("[thrift:{0}] {1}", this.name, message);
    }

    String makeMessage(String message, Throwable e2) {
        return MessageFormat.format("[thrift:{0}] {1} - {2}", this.name, message, e2);
    }
}

