/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift;

import com.jetbrains.cef.remote.thrift.Logger;
import com.jetbrains.cef.remote.thrift.LoggerFactory;
import com.jetbrains.cef.remote.thrift.TApplicationException;
import com.jetbrains.cef.remote.thrift.TBase;
import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift.TSerializable;
import com.jetbrains.cef.remote.thrift.protocol.TMessage;
import com.jetbrains.cef.remote.thrift.protocol.TProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TProtocolException;
import com.jetbrains.cef.remote.thrift.transport.TTransportException;

public abstract class ProcessFunction<I, T extends TBase> {
    private final String methodName;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessFunction.class.getName());

    public ProcessFunction(String methodName) {
        this.methodName = methodName;
    }

    public final void process(int seqid, TProtocol iprot, TProtocol oprot, I iface) throws TException {
        int msgType;
        TSerializable result2;
        block8: {
            T args = this.getEmptyArgsInstance();
            try {
                args.read(iprot);
            }
            catch (TProtocolException e2) {
                iprot.readMessageEnd();
                TApplicationException x2 = new TApplicationException(7, e2.getMessage());
                oprot.writeMessageBegin(new TMessage(this.getMethodName(), 3, seqid));
                x2.write(oprot);
                oprot.writeMessageEnd();
                oprot.getTransport().flush();
                return;
            }
            iprot.readMessageEnd();
            result2 = null;
            msgType = 2;
            try {
                result2 = this.getResult(iface, args);
            }
            catch (TTransportException ex2) {
                LOGGER.error("Transport error while processing " + this.getMethodName(), ex2);
                throw ex2;
            }
            catch (TApplicationException ex3) {
                LOGGER.error("Internal application error processing " + this.getMethodName(), ex3);
                result2 = ex3;
                msgType = 3;
            }
            catch (Exception ex4) {
                LOGGER.error("Internal error processing " + this.getMethodName(), ex4);
                if (this.rethrowUnhandledExceptions()) {
                    throw new RuntimeException(ex4.getMessage(), ex4);
                }
                if (this.isOneway()) break block8;
                result2 = new TApplicationException(6, "Internal error processing " + this.getMethodName());
                msgType = 3;
            }
        }
        if (!this.isOneway()) {
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), (byte)msgType, seqid));
            result2.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
        }
    }

    private void handleException(int seqid, TProtocol oprot) throws TException {
        if (!this.isOneway()) {
            TApplicationException x2 = new TApplicationException(6, "Internal error processing " + this.getMethodName());
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), 3, seqid));
            x2.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
        }
    }

    protected boolean rethrowUnhandledExceptions() {
        return false;
    }

    protected abstract boolean isOneway();

    public abstract TBase getResult(I var1, T var2) throws TException;

    public abstract T getEmptyArgsInstance();

    public String getMethodName() {
        return this.methodName;
    }
}

