/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class TBaseHelper {
    private static final Comparator comparator = new NestedStructureComparator();

    private TBaseHelper() {
    }

    public static int compareTo(Object o1, Object o2) {
        if (o1 instanceof Comparable) {
            return TBaseHelper.compareTo((Comparable)o1, (Comparable)o2);
        }
        if (o1 instanceof List) {
            return TBaseHelper.compareTo((List)o1, (List)o2);
        }
        if (o1 instanceof Set) {
            return TBaseHelper.compareTo((Set)o1, (Set)o2);
        }
        if (o1 instanceof Map) {
            return TBaseHelper.compareTo((Map)o1, (Map)o2);
        }
        if (o1 instanceof byte[]) {
            return TBaseHelper.compareTo((byte[])o1, (byte[])o2);
        }
        throw new IllegalArgumentException("Cannot compare objects of type " + o1.getClass());
    }

    public static int compareTo(boolean a2, boolean b2) {
        return Boolean.compare(a2, b2);
    }

    public static int compareTo(byte a2, byte b2) {
        return Byte.compare(a2, b2);
    }

    public static int compareTo(short a2, short b2) {
        return Short.compare(a2, b2);
    }

    public static int compareTo(int a2, int b2) {
        return Integer.compare(a2, b2);
    }

    public static int compareTo(long a2, long b2) {
        return Long.compare(a2, b2);
    }

    public static int compareTo(double a2, double b2) {
        return Double.compare(a2, b2);
    }

    public static int compareTo(String a2, String b2) {
        return a2.compareTo(b2);
    }

    public static int compareTo(byte[] a2, byte[] b2) {
        int compare = TBaseHelper.compareTo(a2.length, b2.length);
        if (compare == 0) {
            for (int i2 = 0; i2 < a2.length && (compare = TBaseHelper.compareTo(a2[i2], b2[i2])) == 0; ++i2) {
            }
        }
        return compare;
    }

    public static int compareTo(Comparable a2, Comparable b2) {
        return a2.compareTo(b2);
    }

    public static int compareTo(List a2, List b2) {
        int compare = TBaseHelper.compareTo(a2.size(), b2.size());
        if (compare == 0) {
            for (int i2 = 0; i2 < a2.size() && (compare = comparator.compare(a2.get(i2), b2.get(i2))) == 0; ++i2) {
            }
        }
        return compare;
    }

    public static int compareTo(Set a2, Set b2) {
        int compare;
        block1: {
            compare = TBaseHelper.compareTo(a2.size(), b2.size());
            if (compare != 0) break block1;
            ArrayList sortedA = new ArrayList(a2);
            ArrayList sortedB = new ArrayList(b2);
            Collections.sort(sortedA, comparator);
            Collections.sort(sortedB, comparator);
            Iterator iterA = sortedA.iterator();
            Iterator iterB = sortedB.iterator();
            while (iterA.hasNext() && iterB.hasNext() && (compare = comparator.compare(iterA.next(), iterB.next())) == 0) {
            }
        }
        return compare;
    }

    public static int compareTo(Map a2, Map b2) {
        int lastComparison = TBaseHelper.compareTo(a2.size(), b2.size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        TreeMap sortedA = new TreeMap(comparator);
        sortedA.putAll(a2);
        Iterator iterA = sortedA.entrySet().iterator();
        TreeMap sortedB = new TreeMap(comparator);
        sortedB.putAll(b2);
        Iterator iterB = sortedB.entrySet().iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            Map.Entry entryA = iterA.next();
            Map.Entry entryB = iterB.next();
            lastComparison = comparator.compare(entryA.getKey(), entryB.getKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            lastComparison = comparator.compare(entryA.getValue(), entryB.getValue());
            if (lastComparison == 0) continue;
            return lastComparison;
        }
        return 0;
    }

    public static void toString(Collection<ByteBuffer> bbs, StringBuilder sb) {
        Iterator<ByteBuffer> it = bbs.iterator();
        if (it.hasNext()) {
            sb.append("[");
            while (true) {
                ByteBuffer bb2 = it.next();
                TBaseHelper.toString(bb2, sb);
                if (!it.hasNext()) {
                    sb.append("]");
                    return;
                }
                sb.append(", ");
            }
        }
        sb.append("[]");
    }

    public static void toString(ByteBuffer bb2, StringBuilder sb) {
        byte[] buf = bb2.array();
        int arrayOffset = bb2.arrayOffset();
        int offset = arrayOffset + bb2.position();
        int origLimit = arrayOffset + bb2.limit();
        int limit = origLimit - offset > 128 ? offset + 128 : origLimit;
        for (int i2 = offset; i2 < limit; ++i2) {
            if (i2 > offset) {
                sb.append(" ");
            }
            sb.append(TBaseHelper.paddedByteString(buf[i2]));
        }
        if (origLimit != limit) {
            sb.append("...");
        }
    }

    public static String paddedByteString(byte b2) {
        int extended = (b2 | 0x100) & 0x1FF;
        return Integer.toHexString(extended).toUpperCase().substring(1);
    }

    public static byte[] byteBufferToByteArray(ByteBuffer byteBuffer) {
        if (TBaseHelper.wrapsFullArray(byteBuffer)) {
            return byteBuffer.array();
        }
        byte[] target = new byte[byteBuffer.remaining()];
        TBaseHelper.byteBufferToByteArray(byteBuffer, target, 0);
        return target;
    }

    public static boolean wrapsFullArray(ByteBuffer byteBuffer) {
        return byteBuffer.hasArray() && byteBuffer.position() == 0 && byteBuffer.arrayOffset() == 0 && byteBuffer.remaining() == byteBuffer.capacity();
    }

    public static int byteBufferToByteArray(ByteBuffer byteBuffer, byte[] target, int offset) {
        int remaining = byteBuffer.remaining();
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), target, offset, remaining);
        return remaining;
    }

    public static ByteBuffer rightSize(ByteBuffer in) {
        if (in == null) {
            return null;
        }
        if (TBaseHelper.wrapsFullArray(in)) {
            return in;
        }
        return ByteBuffer.wrap(TBaseHelper.byteBufferToByteArray(in));
    }

    public static ByteBuffer copyBinary(ByteBuffer orig) {
        if (orig == null) {
            return null;
        }
        ByteBuffer copy = ByteBuffer.wrap(new byte[orig.remaining()]);
        if (orig.hasArray()) {
            System.arraycopy(orig.array(), orig.arrayOffset() + orig.position(), copy.array(), 0, orig.remaining());
        } else {
            orig.slice().get(copy.array());
        }
        return copy;
    }

    public static byte[] copyBinary(byte[] orig) {
        return orig == null ? null : Arrays.copyOf(orig, orig.length);
    }

    public static int hashCode(long value) {
        return Long.hashCode(value);
    }

    public static int hashCode(double value) {
        return Double.hashCode(value);
    }

    private static class NestedStructureComparator
    implements Comparator,
    Serializable {
        private NestedStructureComparator() {
        }

        public int compare(Object oA, Object oB) {
            if (oA == null && oB == null) {
                return 0;
            }
            if (oA == null) {
                return -1;
            }
            if (oB == null) {
                return 1;
            }
            if (oA instanceof List) {
                return TBaseHelper.compareTo((List)oA, (List)oB);
            }
            if (oA instanceof Set) {
                return TBaseHelper.compareTo((Set)oA, (Set)oB);
            }
            if (oA instanceof Map) {
                return TBaseHelper.compareTo((Map)oA, (Map)oB);
            }
            if (oA instanceof byte[]) {
                return TBaseHelper.compareTo((byte[])oA, (byte[])oB);
            }
            return TBaseHelper.compareTo((Comparable)oA, (Comparable)oB);
        }
    }
}

