/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift;

import com.jetbrains.cef.remote.thrift.Logger;
import com.jetbrains.cef.remote.thrift.LoggerFactory;
import com.jetbrains.cef.remote.thrift.TNonblockingMultiFetchStats;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TNonblockingMultiFetchClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TNonblockingMultiFetchClient.class);
    private final int maxRecvBufBytesPerServer;
    private final int fetchTimeoutSeconds;
    private final ByteBuffer requestBuf;
    private ByteBuffer requestBufDuplication;
    private final List<InetSocketAddress> servers;
    private final TNonblockingMultiFetchStats stats;
    private ByteBuffer[] recvBuf;

    public TNonblockingMultiFetchClient(int maxRecvBufBytesPerServer, int fetchTimeoutSeconds, ByteBuffer requestBuf, List<InetSocketAddress> servers) {
        this.maxRecvBufBytesPerServer = maxRecvBufBytesPerServer;
        this.fetchTimeoutSeconds = fetchTimeoutSeconds;
        this.requestBuf = requestBuf;
        this.servers = servers;
        this.stats = new TNonblockingMultiFetchStats();
        this.recvBuf = null;
    }

    public synchronized int getMaxRecvBufBytesPerServer() {
        return this.maxRecvBufBytesPerServer;
    }

    public synchronized int getFetchTimeoutSeconds() {
        return this.fetchTimeoutSeconds;
    }

    public synchronized ByteBuffer getRequestBuf() {
        if (this.requestBuf == null) {
            return null;
        }
        if (this.requestBufDuplication == null) {
            this.requestBufDuplication = this.requestBuf.duplicate();
        }
        return this.requestBufDuplication;
    }

    public synchronized List<InetSocketAddress> getServerList() {
        if (this.servers == null) {
            return null;
        }
        return Collections.unmodifiableList(this.servers);
    }

    public synchronized TNonblockingMultiFetchStats getFetchStats() {
        return this.stats;
    }

    public synchronized ByteBuffer[] fetch() {
        this.recvBuf = null;
        this.stats.clear();
        if (this.servers == null || this.servers.size() == 0 || this.requestBuf == null || this.fetchTimeoutSeconds <= 0) {
            return this.recvBuf;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        MultiFetch multiFetch = new MultiFetch();
        FutureTask<Object> task = new FutureTask<Object>(multiFetch, null);
        executor.execute(task);
        try {
            task.get(this.fetchTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            task.cancel(true);
            LOGGER.error("Interrupted during fetch", ie);
        }
        catch (ExecutionException ee) {
            task.cancel(true);
            LOGGER.error("Exception during fetch", ee);
        }
        catch (TimeoutException te) {
            task.cancel(true);
            LOGGER.error("Timeout for fetch", te);
        }
        executor.shutdownNow();
        multiFetch.close();
        return this.recvBuf;
    }

    private class MultiFetch
    implements Runnable {
        private Selector selector;

        private MultiFetch() {
        }

        @Override
        public void run() {
            long t1 = System.currentTimeMillis();
            int numTotalServers = TNonblockingMultiFetchClient.this.servers.size();
            TNonblockingMultiFetchClient.this.stats.setNumTotalServers(numTotalServers);
            TNonblockingMultiFetchClient.this.recvBuf = new ByteBuffer[numTotalServers];
            ByteBuffer[] sendBuf = new ByteBuffer[numTotalServers];
            long[] numBytesRead = new long[numTotalServers];
            int[] frameSize = new int[numTotalServers];
            boolean[] hasReadFrameSize = new boolean[numTotalServers];
            try {
                this.selector = Selector.open();
            }
            catch (IOException ioe) {
                LOGGER.error("Selector opens error", ioe);
                return;
            }
            for (int i2 = 0; i2 < numTotalServers; ++i2) {
                sendBuf[i2] = TNonblockingMultiFetchClient.this.requestBuf.duplicate();
                TNonblockingMultiFetchClient.this.recvBuf[i2] = ByteBuffer.allocate(4);
                TNonblockingMultiFetchClient.this.stats.incTotalRecvBufBytes(4);
                InetSocketAddress server = TNonblockingMultiFetchClient.this.servers.get(i2);
                SocketChannel s2 = null;
                SelectionKey key = null;
                try {
                    s2 = SocketChannel.open();
                    s2.configureBlocking(false);
                    s2.connect(server);
                    key = s2.register(this.selector, s2.validOps());
                    key.attach(i2);
                    continue;
                }
                catch (Exception e2) {
                    TNonblockingMultiFetchClient.this.stats.incNumConnectErrorServers();
                    LOGGER.error("Set up socket to server " + server + " error", e2);
                    if (s2 != null) {
                        try {
                            s2.close();
                        }
                        catch (Exception ex2) {
                            LOGGER.error("failed to free up socket", ex2);
                        }
                    }
                    if (key == null) continue;
                    key.cancel();
                }
            }
            while (TNonblockingMultiFetchClient.this.stats.getNumReadCompletedServers() + TNonblockingMultiFetchClient.this.stats.getNumConnectErrorServers() < TNonblockingMultiFetchClient.this.stats.getNumTotalServers()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                try {
                    this.selector.select();
                }
                catch (Exception e3) {
                    LOGGER.error("Selector selects error", e3);
                    continue;
                }
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SocketChannel sChannel;
                    SelectionKey selKey = it.next();
                    it.remove();
                    int index = (Integer)selKey.attachment();
                    if (selKey.isValid() && selKey.isConnectable()) {
                        try {
                            sChannel = (SocketChannel)selKey.channel();
                            sChannel.finishConnect();
                        }
                        catch (Exception e4) {
                            TNonblockingMultiFetchClient.this.stats.incNumConnectErrorServers();
                            LOGGER.error(MessageFormat.format("Socket {0} connects to server {1} error", index, TNonblockingMultiFetchClient.this.servers.get(index)), e4);
                        }
                    }
                    if (selKey.isValid() && selKey.isWritable() && sendBuf[index].hasRemaining()) {
                        try {
                            sChannel = (SocketChannel)selKey.channel();
                            sChannel.write(sendBuf[index]);
                        }
                        catch (Exception e5) {
                            LOGGER.error(MessageFormat.format("Socket {0} writes to server {1} error", index, TNonblockingMultiFetchClient.this.servers.get(index)), e5);
                        }
                    }
                    if (!selKey.isValid() || !selKey.isReadable()) continue;
                    try {
                        sChannel = (SocketChannel)selKey.channel();
                        int bytesRead = sChannel.read(TNonblockingMultiFetchClient.this.recvBuf[index]);
                        if (bytesRead <= 0) continue;
                        int n2 = index;
                        numBytesRead[n2] = numBytesRead[n2] + (long)bytesRead;
                        if (!hasReadFrameSize[index] && TNonblockingMultiFetchClient.this.recvBuf[index].remaining() == 0) {
                            frameSize[index] = TNonblockingMultiFetchClient.this.recvBuf[index].getInt(0);
                            if (frameSize[index] <= 0) {
                                TNonblockingMultiFetchClient.this.stats.incNumInvalidFrameSize();
                                LOGGER.error(MessageFormat.format("Read an invalid frame size {0} from {1}. Does the server use TFramedTransport?", frameSize[index], TNonblockingMultiFetchClient.this.servers.get(index)));
                                sChannel.close();
                                continue;
                            }
                            if (frameSize[index] + 4 > TNonblockingMultiFetchClient.this.stats.getMaxResponseBytes()) {
                                TNonblockingMultiFetchClient.this.stats.setMaxResponseBytes(frameSize[index] + 4);
                            }
                            if (frameSize[index] + 4 > TNonblockingMultiFetchClient.this.maxRecvBufBytesPerServer) {
                                TNonblockingMultiFetchClient.this.stats.incNumOverflowedRecvBuf();
                                LOGGER.error(MessageFormat.format("Read frame size {0} from {1}, total buffer size would exceed limit {2}", frameSize[index], TNonblockingMultiFetchClient.this.servers.get(index), TNonblockingMultiFetchClient.this.maxRecvBufBytesPerServer));
                                sChannel.close();
                                continue;
                            }
                            TNonblockingMultiFetchClient.this.recvBuf[index] = ByteBuffer.allocate(frameSize[index] + 4);
                            TNonblockingMultiFetchClient.this.recvBuf[index].putInt(frameSize[index]);
                            TNonblockingMultiFetchClient.this.stats.incTotalRecvBufBytes(frameSize[index]);
                            hasReadFrameSize[index] = true;
                        }
                        if (!hasReadFrameSize[index] || numBytesRead[index] < (long)(frameSize[index] + 4)) continue;
                        sChannel.close();
                        TNonblockingMultiFetchClient.this.stats.incNumReadCompletedServers();
                        long t2 = System.currentTimeMillis();
                        TNonblockingMultiFetchClient.this.stats.setReadTime(t2 - t1);
                    }
                    catch (Exception e6) {
                        LOGGER.error(MessageFormat.format("Socket {0} reads from server {1} error", index, TNonblockingMultiFetchClient.this.servers.get(index)), e6);
                    }
                }
            }
        }

        public void close() {
            try {
                if (this.selector.isOpen()) {
                    for (SelectionKey selKey : this.selector.keys()) {
                        SocketChannel sChannel = (SocketChannel)selKey.channel();
                        sChannel.close();
                    }
                    this.selector.close();
                }
            }
            catch (IOException e2) {
                LOGGER.error("Free resource error", e2);
            }
        }
    }
}

