/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.partial;

import com.jetbrains.cef.remote.thrift.Logger;
import com.jetbrains.cef.remote.thrift.LoggerFactory;
import com.jetbrains.cef.remote.thrift.TEnum;
import com.jetbrains.cef.remote.thrift.partial.Validate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class EnumCache {
    private static final Logger LOG = LoggerFactory.getLogger(EnumCache.class);
    private Map<Class<? extends TEnum>, Map<Integer, TEnum>> classMap = new HashMap<Class<? extends TEnum>, Map<Integer, TEnum>>();

    public TEnum get(Class<? extends TEnum> enumClass, int value) {
        Validate.checkNotNull(enumClass, "enumClass");
        Map<Integer, TEnum> valueMap = this.classMap.get(enumClass);
        if (valueMap == null && (valueMap = this.addClass(enumClass)) == null) {
            return null;
        }
        return valueMap.get(value);
    }

    private Map<Integer, TEnum> addClass(Class<? extends TEnum> enumClass) {
        try {
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            TEnum[] enumValues = (TEnum[])valuesMethod.invoke(null, new Object[0]);
            HashMap<Integer, TEnum> valueMap = new HashMap<Integer, TEnum>();
            for (TEnum enumValue : enumValues) {
                valueMap.put(enumValue.getValue(), enumValue);
            }
            this.classMap.put(enumClass, valueMap);
            return valueMap;
        }
        catch (NoSuchMethodException e2) {
            LOG.error("enum class does not have values() method", e2);
            return null;
        }
        catch (IllegalAccessException e3) {
            LOG.error("Enum.values() method should be public!", e3);
            return null;
        }
        catch (InvocationTargetException e4) {
            LOG.error("Enum.values() threw exception", e4);
            return null;
        }
    }
}

