/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.transport.layered;

import com.jetbrains.cef.remote.thrift.TByteArrayOutputStream;
import com.jetbrains.cef.remote.thrift.TConfiguration;
import com.jetbrains.cef.remote.thrift.transport.TMemoryInputTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransportException;
import com.jetbrains.cef.remote.thrift.transport.TTransportFactory;
import com.jetbrains.cef.remote.thrift.transport.layered.TLayeredTransport;
import java.util.Objects;

public class TFramedTransport
extends TLayeredTransport {
    private final TByteArrayOutputStream writeBuffer_ = new TByteArrayOutputStream(1024);
    private final TMemoryInputTransport readBuffer_;
    private static final byte[] sizeFiller_ = new byte[]{0, 0, 0, 0};
    private final byte[] i32buf = new byte[4];

    public TFramedTransport(TTransport transport, int maxLength) throws TTransportException {
        super(transport);
        TConfiguration _configuration = Objects.isNull(transport.getConfiguration()) ? new TConfiguration() : transport.getConfiguration();
        _configuration.setMaxFrameSize(maxLength);
        this.writeBuffer_.write(sizeFiller_, 0, 4);
        this.readBuffer_ = new TMemoryInputTransport(_configuration, new byte[0]);
    }

    public TFramedTransport(TTransport transport) throws TTransportException {
        this(transport, 0xFA0000);
    }

    @Override
    public void open() throws TTransportException {
        this.getInnerTransport().open();
    }

    @Override
    public boolean isOpen() {
        return this.getInnerTransport().isOpen();
    }

    @Override
    public void close() {
        this.getInnerTransport().close();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int got = this.readBuffer_.read(buf, off, len);
        if (got > 0) {
            return got;
        }
        this.readFrame();
        return this.readBuffer_.read(buf, off, len);
    }

    @Override
    public byte[] getBuffer() {
        return this.readBuffer_.getBuffer();
    }

    @Override
    public int getBufferPosition() {
        return this.readBuffer_.getBufferPosition();
    }

    @Override
    public int getBytesRemainingInBuffer() {
        return this.readBuffer_.getBytesRemainingInBuffer();
    }

    @Override
    public void consumeBuffer(int len) {
        this.readBuffer_.consumeBuffer(len);
    }

    public void clear() {
        this.readBuffer_.clear();
    }

    private void readFrame() throws TTransportException {
        this.getInnerTransport().readAll(this.i32buf, 0, 4);
        int size = TFramedTransport.decodeFrameSize(this.i32buf);
        if (size < 0) {
            this.close();
            throw new TTransportException(5, "Read a negative frame size (" + size + ")!");
        }
        if (size > this.getInnerTransport().getConfiguration().getMaxFrameSize()) {
            this.close();
            throw new TTransportException(5, "Frame size (" + size + ") larger than max length (" + this.getInnerTransport().getConfiguration().getMaxFrameSize() + ")!");
        }
        byte[] buff = new byte[size];
        this.getInnerTransport().readAll(buff, 0, size);
        this.readBuffer_.reset(buff);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.writeBuffer_.write(buf, off, len);
    }

    @Override
    public void flush() throws TTransportException {
        byte[] buf = this.writeBuffer_.get();
        int len = this.writeBuffer_.len() - 4;
        this.writeBuffer_.reset();
        this.writeBuffer_.write(sizeFiller_, 0, 4);
        TFramedTransport.encodeFrameSize(len, buf);
        this.getInnerTransport().write(buf, 0, len + 4);
        this.getInnerTransport().flush();
    }

    public static void encodeFrameSize(int frameSize, byte[] buf) {
        buf[0] = (byte)(0xFF & frameSize >> 24);
        buf[1] = (byte)(0xFF & frameSize >> 16);
        buf[2] = (byte)(0xFF & frameSize >> 8);
        buf[3] = (byte)(0xFF & frameSize);
    }

    public static int decodeFrameSize(byte[] buf) {
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    public static class Factory
    extends TTransportFactory {
        private final int maxLength_;

        public Factory() {
            this.maxLength_ = 0xFA0000;
        }

        public Factory(int maxLength) {
            this.maxLength_ = maxLength;
        }

        @Override
        public TTransport getTransport(TTransport base2) throws TTransportException {
            return new TFramedTransport(base2, this.maxLength_);
        }
    }
}

