/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.transport.sasl;

import com.jetbrains.cef.remote.thrift.EncodingUtils;
import com.jetbrains.cef.remote.thrift.transport.sasl.FrameWriter;
import com.jetbrains.cef.remote.thrift.utils.StringUtils;
import java.nio.ByteBuffer;

public class DataFrameWriter
extends FrameWriter {
    @Override
    public void withOnlyPayload(byte[] payload, int offset, int length) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Previous write is not yet complete, with " + this.frameBytes.remaining() + " bytes left.");
        }
        this.frameBytes = this.buildFrameWithPayload(payload, offset, length);
    }

    @Override
    protected ByteBuffer buildFrame(byte[] header2, int headerOffset, int headerLength, byte[] payload, int payloadOffset, int payloadLength) {
        if (header2 != null && headerLength > 0) {
            throw new IllegalArgumentException("Extra header [" + StringUtils.bytesToHexString(header2) + "] offset " + payloadOffset + " length " + payloadLength);
        }
        return this.buildFrameWithPayload(payload, payloadOffset, payloadLength);
    }

    private ByteBuffer buildFrameWithPayload(byte[] payload, int offset, int length) {
        byte[] bytes = new byte[4 + length];
        EncodingUtils.encodeBigEndian(length, bytes, 0);
        System.arraycopy(payload, offset, bytes, 4, length);
        return ByteBuffer.wrap(bytes);
    }
}

