/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.transport.sasl;

import com.jetbrains.cef.remote.thrift.transport.TNonblockingTransport;
import com.jetbrains.cef.remote.thrift.transport.TTransportException;
import java.nio.ByteBuffer;

public abstract class FrameWriter {
    protected ByteBuffer frameBytes;

    public void withHeaderAndPayload(byte[] header2, byte[] payload) {
        if (payload == null) {
            payload = new byte[]{};
        }
        if (header2 == null) {
            this.withOnlyPayload(payload);
        } else {
            this.withHeaderAndPayload(header2, 0, header2.length, payload, 0, payload.length);
        }
    }

    public void withHeaderAndPayload(byte[] header2, int headerOffset, int headerLength, byte[] payload, int payloadOffset, int payloadLength) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Previsous write is not yet complete, with " + this.frameBytes.remaining() + " bytes left.");
        }
        this.frameBytes = this.buildFrame(header2, headerOffset, headerLength, payload, payloadOffset, payloadLength);
    }

    public void withOnlyPayload(byte[] payload) {
        this.withOnlyPayload(payload, 0, payload.length);
    }

    public abstract void withOnlyPayload(byte[] var1, int var2, int var3);

    protected abstract ByteBuffer buildFrame(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public void write(TNonblockingTransport transport) throws TTransportException {
        transport.write(this.frameBytes);
    }

    public boolean isComplete() {
        return this.frameBytes == null || !this.frameBytes.hasRemaining();
    }

    public void clear() {
        this.frameBytes = null;
    }
}

