/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.infra.pgpVerifier;

import com.jetbrains.infra.pgpVerifier.PgpSignaturesVerifier;
import com.jetbrains.infra.pgpVerifier.Sha256ChecksumSignatureVerifier;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J6\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\f\u0010\u0017\u001a\u00020\u000e*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/infra/pgpVerifier/Sha256ChecksumSignatureVerifier;", "", "pgpSignaturesVerifier", "Lcom/jetbrains/infra/pgpVerifier/PgpSignaturesVerifier;", "(Lcom/jetbrains/infra/pgpVerifier/PgpSignaturesVerifier;)V", "sha256WithFileNameRegex", "Lkotlin/text/Regex;", "getFileDigest", "", "file", "Ljava/nio/file/Path;", "digest", "Ljava/security/MessageDigest;", "getHashFromChecksumFile", "", "detachedSignatureFile", "checksumFile", "expectedFileName", "untrustedPublicKeyRing", "Ljava/io/InputStream;", "trustedMasterKey", "verifyChecksumAndSignature", "", "toHexString", "download-pgp-verifier"})
public final class Sha256ChecksumSignatureVerifier {
    @NotNull
    private final PgpSignaturesVerifier pgpSignaturesVerifier;
    @NotNull
    private final Regex sha256WithFileNameRegex;

    public Sha256ChecksumSignatureVerifier(@NotNull PgpSignaturesVerifier pgpSignaturesVerifier) {
        Intrinsics.checkNotNullParameter((Object)pgpSignaturesVerifier, (String)"pgpSignaturesVerifier");
        this.pgpSignaturesVerifier = pgpSignaturesVerifier;
        this.sha256WithFileNameRegex = new Regex("([0-9a-f]{64})[\t ]+\\*?([a-zA-Z0-9_\\-.*]+)\\s*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getHashFromChecksumFile(Path detachedSignatureFile, Path checksumFile, String expectedFileName, InputStream untrustedPublicKeyRing, InputStream trustedMasterKey) {
        Closeable closeable = Files.newInputStream(detachedSignatureFile, new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream signatureStream = (InputStream)closeable;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)signatureStream, (String)"signatureStream");
            this.pgpSignaturesVerifier.verifySignature(checksumFile, signatureStream, untrustedPublicKeyRing, trustedMasterKey);
            signatureStream = Unit.INSTANCE;
        }
        catch (Throwable signatureStream) {
            throwable = signatureStream;
            throw signatureStream;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String text = Files.readString(checksumFile);
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        MatchResult matchResult = this.sha256WithFileNameRegex.matchEntire((CharSequence)text);
        if (matchResult == null) {
            throw new IllegalStateException(("Checksum file does not match regex '" + this.sha256WithFileNameRegex + "': ~~~" + text + "~~~").toString());
        }
        MatchResult match2 = matchResult;
        String actualFileName = (String)match2.getGroupValues().get(2);
        if (!Intrinsics.areEqual((Object)actualFileName, (Object)expectedFileName)) {
            throw new IllegalStateException(("Expected file name '" + expectedFileName + "', but got '" + actualFileName + "' in checksum file: ~~~" + text + "~~~").toString());
        }
        return (String)match2.getGroupValues().get(1);
    }

    public final void verifyChecksumAndSignature(@NotNull Path file, @NotNull Path detachedSignatureFile, @NotNull Path checksumFile, @NotNull String expectedFileName, @NotNull InputStream untrustedPublicKeyRing, @NotNull InputStream trustedMasterKey) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)detachedSignatureFile, (String)"detachedSignatureFile");
        Intrinsics.checkNotNullParameter((Object)checksumFile, (String)"checksumFile");
        Intrinsics.checkNotNullParameter((Object)expectedFileName, (String)"expectedFileName");
        Intrinsics.checkNotNullParameter((Object)untrustedPublicKeyRing, (String)"untrustedPublicKeyRing");
        Intrinsics.checkNotNullParameter((Object)trustedMasterKey, (String)"trustedMasterKey");
        String expectedHash = this.getHashFromChecksumFile(detachedSignatureFile, checksumFile, expectedFileName, untrustedPublicKeyRing, trustedMasterKey);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(\"SHA-256\")");
        byte[] actualByteHash = this.getFileDigest(file, messageDigest);
        String actualHash = this.toHexString(actualByteHash);
        if (!Intrinsics.areEqual((Object)expectedHash, (Object)actualHash)) {
            throw new IllegalStateException(("Failed to verify SHA-256 checksum for " + file + "\n\nThe actual value is " + actualHash + ",\nbut " + expectedHash + " was expected").toString());
        }
    }

    private final String toHexString(byte[] $this$toHexString) {
        return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)"", null, null, (int)0, null, (Function1)toHexString.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getFileDigest(Path file, MessageDigest digest) {
        byte[] buf = new byte[65536];
        digest.reset();
        Closeable closeable = Files.newInputStream(file, new OpenOption[0]);
        Throwable throwable = null;
        try {
            int count;
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            while ((count = it.read(buf)) > 0) {
                digest.update(buf, 0, count);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
        return byArray;
    }
}

