/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.enums;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.Fields;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.EnumSet;

public class EnumSetConverter
implements Converter {
    private final Mapper mapper;

    public EnumSetConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return type != null && EnumSet.class.isAssignableFrom(type) && Reflections.typeField != null;
    }

    public void marshal(Object source2, HierarchicalStreamWriter writer, MarshallingContext context) {
        EnumSet set2 = (EnumSet)source2;
        Class enumTypeForSet = (Class)Fields.read(Reflections.typeField, set2);
        String attributeName = this.mapper.aliasForSystemAttribute("enum-type");
        if (attributeName != null) {
            writer.addAttribute(attributeName, this.mapper.serializedClass(enumTypeForSet));
        }
        writer.setValue(this.joinEnumValues(set2));
    }

    private String joinEnumValues(EnumSet set2) {
        boolean seenFirst = false;
        StringBuffer result2 = new StringBuffer();
        for (Enum value : set2) {
            if (seenFirst) {
                result2.append(',');
            } else {
                seenFirst = true;
            }
            result2.append(value.name());
        }
        return result2.toString();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String attributeName = this.mapper.aliasForSystemAttribute("enum-type");
        if (attributeName == null) {
            throw new ConversionException("No EnumType specified for EnumSet");
        }
        Class enumTypeForSet = this.mapper.realClass(reader.getAttribute(attributeName));
        EnumSet set2 = EnumSet.noneOf(enumTypeForSet);
        String[] enumValues = reader.getValue().split(",");
        for (int i2 = 0; i2 < enumValues.length; ++i2) {
            String enumValue = enumValues[i2];
            if (enumValue.length() <= 0) continue;
            set2.add(Enum.valueOf(enumTypeForSet, enumValue));
        }
        return set2;
    }

    private static class Reflections {
        private static final Field typeField = Fields.locate(EnumSet.class, Class.class, false);

        private Reflections() {
        }
    }
}

