/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class DurationConverter
extends AbstractSingleValueConverter {
    private final DatatypeFactory factory;

    public DurationConverter() {
        this(new Object(){

            DatatypeFactory getFactory() {
                try {
                    return DatatypeFactory.newInstance();
                }
                catch (DatatypeConfigurationException e2) {
                    return null;
                }
            }
        }.getFactory());
    }

    public DurationConverter(DatatypeFactory factory2) {
        this.factory = factory2;
    }

    public boolean canConvert(Class type) {
        return this.factory != null && type != null && Duration.class.isAssignableFrom(type);
    }

    public Object fromString(String s2) {
        return this.factory.newDuration(s2);
    }
}

