/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.javabean;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWritingException;
import com.thoughtworks.xstream.converters.javabean.ComparingPropertySorter;
import com.thoughtworks.xstream.converters.javabean.JavaBeanProvider;
import com.thoughtworks.xstream.converters.javabean.NativePropertySorter;
import com.thoughtworks.xstream.converters.javabean.PropertyDictionary;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public class BeanProvider
implements JavaBeanProvider {
    protected static final Object[] NO_PARAMS = new Object[0];
    protected PropertyDictionary propertyDictionary;

    public BeanProvider() {
        this(new PropertyDictionary(new NativePropertySorter()));
    }

    public BeanProvider(Comparator propertyNameComparator) {
        this(new PropertyDictionary(new ComparingPropertySorter(propertyNameComparator)));
    }

    public BeanProvider(PropertyDictionary propertyDictionary) {
        this.propertyDictionary = propertyDictionary;
    }

    public Object newInstance(Class type) {
        ErrorWritingException ex2 = null;
        if (type == Void.TYPE || type == Void.class) {
            ex2 = new ConversionException("Security alert: Marshalling rejected");
        } else {
            try {
                return type.newInstance();
            }
            catch (InstantiationException e2) {
                ex2 = new ConversionException("Cannot construct type", e2);
            }
            catch (IllegalAccessException e3) {
                ex2 = new ObjectAccessException("Cannot construct type", e3);
            }
            catch (SecurityException e4) {
                ex2 = new ObjectAccessException("Cannot construct type", e4);
            }
            catch (ExceptionInInitializerError e5) {
                ex2 = new ConversionException("Cannot construct type", e5);
            }
        }
        ex2.add("construction-type", type.getName());
        throw ex2;
    }

    public void visitSerializableProperties(Object object, JavaBeanProvider.Visitor visitor) {
        PropertyDescriptor[] propertyDescriptors = this.getSerializableProperties(object);
        for (int i2 = 0; i2 < propertyDescriptors.length; ++i2) {
            ErrorWritingException ex2 = null;
            PropertyDescriptor property = propertyDescriptors[i2];
            try {
                Method readMethod = property.getReadMethod();
                String name = property.getName();
                Class<?> definedIn = readMethod.getDeclaringClass();
                if (visitor.shouldVisit(name, definedIn)) {
                    Object value = readMethod.invoke(object, new Object[0]);
                    visitor.visit(name, property.getPropertyType(), definedIn, value);
                }
            }
            catch (IllegalArgumentException e2) {
                ex2 = new ConversionException("Cannot get property", e2);
            }
            catch (IllegalAccessException e3) {
                ex2 = new ObjectAccessException("Cannot access property", e3);
            }
            catch (InvocationTargetException e4) {
                ex2 = new ConversionException("Cannot get property", e4.getTargetException());
            }
            if (ex2 == null) continue;
            ex2.add("property", object.getClass() + "." + property.getName());
            throw ex2;
        }
    }

    public void writeProperty(Object object, String propertyName, Object value) {
        ErrorWritingException ex2 = null;
        PropertyDescriptor property = this.getProperty(propertyName, object.getClass());
        try {
            property.getWriteMethod().invoke(object, value);
        }
        catch (IllegalArgumentException e2) {
            ex2 = new ConversionException("Cannot set property", e2);
        }
        catch (IllegalAccessException e3) {
            ex2 = new ObjectAccessException("Cannot access property", e3);
        }
        catch (InvocationTargetException e4) {
            ex2 = new ConversionException("Cannot set property", e4.getTargetException());
        }
        if (ex2 != null) {
            ex2.add("property", object.getClass() + "." + property.getName());
            throw ex2;
        }
    }

    public Class getPropertyType(Object object, String name) {
        return this.getProperty(name, object.getClass()).getPropertyType();
    }

    public boolean propertyDefinedInClass(String name, Class type) {
        return this.propertyDictionary.propertyDescriptorOrNull(type, name) != null;
    }

    public boolean canInstantiate(Class type) {
        try {
            return type != null && this.newInstance(type) != null;
        }
        catch (ErrorWritingException e2) {
            return false;
        }
    }

    protected Constructor getDefaultConstrutor(Class type) {
        Constructor<?>[] constructors = type.getConstructors();
        for (int i2 = 0; i2 < constructors.length; ++i2) {
            Constructor<?> c2 = constructors[i2];
            if (c2.getParameterTypes().length != 0 || !Modifier.isPublic(c2.getModifiers())) continue;
            return c2;
        }
        return null;
    }

    protected PropertyDescriptor[] getSerializableProperties(Object object) {
        ArrayList<PropertyDescriptor> result2 = new ArrayList<PropertyDescriptor>();
        Iterator iter = this.propertyDictionary.propertiesFor(object.getClass());
        while (iter.hasNext()) {
            PropertyDescriptor descriptor2 = (PropertyDescriptor)iter.next();
            if (!this.canStreamProperty(descriptor2)) continue;
            result2.add(descriptor2);
        }
        return result2.toArray(new PropertyDescriptor[result2.size()]);
    }

    protected boolean canStreamProperty(PropertyDescriptor descriptor2) {
        return descriptor2.getReadMethod() != null && descriptor2.getWriteMethod() != null;
    }

    public boolean propertyWriteable(String name, Class type) {
        PropertyDescriptor property = this.getProperty(name, type);
        return property.getWriteMethod() != null;
    }

    protected PropertyDescriptor getProperty(String name, Class type) {
        return this.propertyDictionary.propertyDescriptor(type, name);
    }

    public static interface Visitor
    extends JavaBeanProvider.Visitor {
    }
}

