/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.javabean;

import com.thoughtworks.xstream.converters.javabean.BeanProperty;
import com.thoughtworks.xstream.converters.javabean.NativePropertySorter;
import com.thoughtworks.xstream.converters.javabean.PropertySorter;
import com.thoughtworks.xstream.converters.reflection.MissingFieldException;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PropertyDictionary
implements Caching {
    private transient Map propertyNameCache = Collections.synchronizedMap(new HashMap());
    private final PropertySorter sorter;

    public PropertyDictionary() {
        this(new NativePropertySorter());
    }

    public PropertyDictionary(PropertySorter sorter) {
        this.sorter = sorter;
    }

    public Iterator serializablePropertiesFor(Class type) {
        ArrayList<BeanProperty> beanProperties = new ArrayList<BeanProperty>();
        Collection descriptors = this.buildMap(type).values();
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            PropertyDescriptor descriptor2 = (PropertyDescriptor)iter.next();
            if (descriptor2.getReadMethod() == null || descriptor2.getWriteMethod() == null) continue;
            beanProperties.add(new BeanProperty(type, descriptor2.getName(), descriptor2.getPropertyType()));
        }
        return beanProperties.iterator();
    }

    public BeanProperty property(Class cls, String name) {
        BeanProperty beanProperty = null;
        PropertyDescriptor descriptor2 = this.propertyDescriptorOrNull(cls, name);
        if (descriptor2 == null) {
            throw new MissingFieldException(cls.getName(), name);
        }
        if (descriptor2.getReadMethod() != null && descriptor2.getWriteMethod() != null) {
            beanProperty = new BeanProperty(cls, descriptor2.getName(), descriptor2.getPropertyType());
        }
        return beanProperty;
    }

    public Iterator propertiesFor(Class type) {
        return this.buildMap(type).values().iterator();
    }

    public PropertyDescriptor propertyDescriptor(Class type, String name) {
        PropertyDescriptor descriptor2 = this.propertyDescriptorOrNull(type, name);
        if (descriptor2 == null) {
            throw new MissingFieldException(type.getName(), name);
        }
        return descriptor2;
    }

    public PropertyDescriptor propertyDescriptorOrNull(Class type, String name) {
        return (PropertyDescriptor)this.buildMap(type).get(name);
    }

    private Map buildMap(Class type) {
        Map nameMap = (Map)this.propertyNameCache.get(type);
        if (nameMap == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(type, Object.class);
            }
            catch (IntrospectionException e2) {
                ObjectAccessException oaex = new ObjectAccessException("Cannot get BeanInfo of type", e2);
                oaex.add("bean-type", type.getName());
                throw oaex;
            }
            nameMap = new OrderRetainingMap();
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i2 = 0; i2 < propertyDescriptors.length; ++i2) {
                PropertyDescriptor descriptor2 = propertyDescriptors[i2];
                nameMap.put(descriptor2.getName(), descriptor2);
            }
            nameMap = this.sorter.sort(type, nameMap);
            this.propertyNameCache.put(type, nameMap);
        }
        return nameMap;
    }

    public void flushCache() {
        this.propertyNameCache.clear();
    }
}

