/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProviderWrapper;
import com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.CGLIBMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;

public class CGLIBEnhancedConverter
extends SerializableConverter {
    private static String DEFAULT_NAMING_MARKER = "$$EnhancerByCGLIB$$";
    private static String CALLBACK_MARKER = "CGLIB$CALLBACK_";
    private transient Map fieldCache = new HashMap();
    static /* synthetic */ Class class$net$sf$cglib$proxy$MethodInterceptor;
    static /* synthetic */ Class class$net$sf$cglib$proxy$NoOp;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Callback;

    public CGLIBEnhancedConverter(Mapper mapper, ReflectionProvider reflectionProvider, ClassLoaderReference classLoaderReference) {
        super(mapper, (ReflectionProvider)new CGLIBFilteringReflectionProvider(reflectionProvider), classLoaderReference);
    }

    public CGLIBEnhancedConverter(Mapper mapper, ReflectionProvider reflectionProvider, ClassLoader classLoader) {
        super(mapper, (ReflectionProvider)new CGLIBFilteringReflectionProvider(reflectionProvider), classLoader);
    }

    public CGLIBEnhancedConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this(mapper, (ReflectionProvider)new CGLIBFilteringReflectionProvider(reflectionProvider), CGLIBEnhancedConverter.class.getClassLoader());
    }

    public boolean canConvert(Class type) {
        return type != null && Enhancer.isEnhanced((Class)type) && type.getName().indexOf(DEFAULT_NAMING_MARKER) > 0 || type == CGLIBMapper.Marker.class;
    }

    public void marshal(Object source2, HierarchicalStreamWriter writer, MarshallingContext context) {
        Callback[] callbacks;
        Class<?> type = source2.getClass();
        boolean hasFactory = Factory.class.isAssignableFrom(type);
        ExtendedHierarchicalStreamWriterHelper.startNode(writer, "type", type);
        context.convertAnother(type.getSuperclass());
        writer.endNode();
        writer.startNode("interfaces");
        Class<?>[] interfaces = type.getInterfaces();
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            if (interfaces[i2] == (class$net$sf$cglib$proxy$Factory == null ? CGLIBEnhancedConverter.class$("net.sf.cglib.proxy.Factory") : class$net$sf$cglib$proxy$Factory)) continue;
            ExtendedHierarchicalStreamWriterHelper.startNode(writer, this.mapper.serializedClass(interfaces[i2].getClass()), interfaces[i2].getClass());
            context.convertAnother(interfaces[i2]);
            writer.endNode();
        }
        writer.endNode();
        writer.startNode("hasFactory");
        writer.setValue(String.valueOf(hasFactory));
        writer.endNode();
        Map callbackIndexMap = null;
        Callback[] callbackArray = callbacks = hasFactory ? ((Factory)source2).getCallbacks() : this.getCallbacks(source2);
        if (callbacks.length > 1) {
            if (!hasFactory) {
                ConversionException exception = new ConversionException("Cannot handle CGLIB enhanced proxies without factory that have multiple callbacks");
                exception.add("proxy-superclass", type.getSuperclass().getName());
                exception.add("number-of-callbacks", String.valueOf(callbacks.length));
                throw exception;
            }
            callbackIndexMap = this.createCallbackIndexMap((Factory)source2);
            writer.startNode("callbacks");
            writer.startNode("mapping");
            context.convertAnother(callbackIndexMap);
            writer.endNode();
        }
        boolean hasInterceptor = false;
        for (int i3 = 0; i3 < callbacks.length; ++i3) {
            Callback callback = callbacks[i3];
            if (callback == null) {
                String name = this.mapper.serializedClass(null);
                writer.startNode(name);
                writer.endNode();
                continue;
            }
            hasInterceptor = hasInterceptor || (class$net$sf$cglib$proxy$MethodInterceptor == null ? CGLIBEnhancedConverter.class$("net.sf.cglib.proxy.MethodInterceptor") : class$net$sf$cglib$proxy$MethodInterceptor).isAssignableFrom(callback.getClass());
            ExtendedHierarchicalStreamWriterHelper.startNode(writer, this.mapper.serializedClass(callback.getClass()), callback.getClass());
            context.convertAnother(callback);
            writer.endNode();
        }
        if (callbacks.length > 1) {
            writer.endNode();
        }
        try {
            Field field = type.getDeclaredField("serialVersionUID");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            long serialVersionUID = field.getLong(null);
            ExtendedHierarchicalStreamWriterHelper.startNode(writer, "serialVersionUID", String.class);
            writer.setValue(String.valueOf(serialVersionUID));
            writer.endNode();
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException e2) {
            ObjectAccessException exception = new ObjectAccessException("Cannot access field", e2);
            exception.add("field", type.getName() + ".serialVersionUID");
            throw exception;
        }
        if (hasInterceptor) {
            writer.startNode("instance");
            super.doMarshalConditionally(source2, writer, context);
            writer.endNode();
        }
    }

    private Callback[] getCallbacks(Object source2) {
        Class<?> type = source2.getClass();
        ArrayList<Field> fields = (ArrayList<Field>)this.fieldCache.get(type.getName());
        if (fields == null) {
            fields = new ArrayList<Field>();
            this.fieldCache.put(type.getName(), fields);
            int i2 = 0;
            while (true) {
                try {
                    Field field = type.getDeclaredField(CALLBACK_MARKER + i2);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    fields.add(field);
                }
                catch (NoSuchFieldException e2) {
                    break;
                }
                ++i2;
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i3 = 0; i3 < fields.size(); ++i3) {
            try {
                Field field = (Field)fields.get(i3);
                Object callback = field.get(source2);
                list.add(callback);
                continue;
            }
            catch (IllegalAccessException e3) {
                ObjectAccessException exception = new ObjectAccessException("Cannot access field", e3);
                exception.add("field", type.getName() + "." + CALLBACK_MARKER + i3);
                throw exception;
            }
        }
        return list.toArray(new Callback[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map createCallbackIndexMap(Factory source2) {
        Callback[] originalCallbacks = source2.getCallbacks();
        Callback[] reverseEngineeringCallbacks = new Callback[originalCallbacks.length];
        HashMap callbackIndexMap = new HashMap();
        int idxNoOp = -1;
        for (int i2 = 0; i2 < originalCallbacks.length; ++i2) {
            Callback callback = originalCallbacks[i2];
            if (callback == null) {
                reverseEngineeringCallbacks[i2] = null;
                continue;
            }
            if ((class$net$sf$cglib$proxy$NoOp == null ? CGLIBEnhancedConverter.class$("net.sf.cglib.proxy.NoOp") : class$net$sf$cglib$proxy$NoOp).isAssignableFrom(callback.getClass())) {
                reverseEngineeringCallbacks[i2] = NoOp.INSTANCE;
                idxNoOp = i2;
                continue;
            }
            reverseEngineeringCallbacks[i2] = this.createReverseEngineeredCallbackOfProperType(callback, i2, callbackIndexMap);
        }
        try {
            source2.setCallbacks(reverseEngineeringCallbacks);
            HashSet interfaces = new HashSet();
            HashSet<Method> methods = new HashSet<Method>();
            Class type = source2.getClass();
            do {
                methods.addAll(Arrays.asList(type.getDeclaredMethods()));
                methods.addAll(Arrays.asList(type.getMethods()));
                Class<?>[] implementedInterfaces = type.getInterfaces();
                interfaces.addAll(Arrays.asList(implementedInterfaces));
            } while ((type = type.getSuperclass()) != null);
            Iterator iterator2 = interfaces.iterator();
            while (iterator2.hasNext()) {
                type = (Class)iterator2.next();
                methods.addAll(Arrays.asList(type.getDeclaredMethods()));
            }
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                Method method = (Method)iter.next();
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                if ((class$net$sf$cglib$proxy$Factory == null ? CGLIBEnhancedConverter.class$("net.sf.cglib.proxy.Factory") : class$net$sf$cglib$proxy$Factory).isAssignableFrom(method.getDeclaringClass()) || (method.getModifiers() & 0x18) > 0) {
                    iter.remove();
                    continue;
                }
                Class[] parameterTypes = method.getParameterTypes();
                Method calledMethod = method;
                try {
                    if ((method.getModifiers() & 0x400) > 0) {
                        calledMethod = source2.getClass().getMethod(method.getName(), method.getParameterTypes());
                    }
                    callbackIndexMap.put(null, method);
                    calledMethod.invoke((Object)source2, parameterTypes == null ? (Object[])null : this.createNullArguments(parameterTypes));
                }
                catch (IllegalAccessException e2) {
                    ObjectAccessException exception = new ObjectAccessException("Cannot access method", e2);
                    exception.add("method", calledMethod.toString());
                    throw exception;
                }
                catch (InvocationTargetException e2) {
                }
                catch (NoSuchMethodException e3) {
                    ConversionException exception = new ConversionException("CGLIB enhanced proxies wit abstract nethod that has not been implemented");
                    exception.add("proxy-superclass", type.getSuperclass().getName());
                    exception.add("method", method.toString());
                    throw exception;
                }
                if (!callbackIndexMap.containsKey(method)) continue;
                iter.remove();
            }
            if (idxNoOp >= 0) {
                Integer idx = new Integer(idxNoOp);
                Iterator iter2 = methods.iterator();
                while (iter2.hasNext()) {
                    callbackIndexMap.put(iter2.next(), idx);
                }
            }
        }
        finally {
            source2.setCallbacks(originalCallbacks);
        }
        callbackIndexMap.remove(null);
        return callbackIndexMap;
    }

    private Object[] createNullArguments(Class[] parameterTypes) {
        Object[] arguments = new Object[parameterTypes.length];
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            Class type = parameterTypes[i2];
            if (!type.isPrimitive()) continue;
            arguments[i2] = type == Byte.TYPE ? new Byte(0) : (type == Short.TYPE ? new Short(0) : (type == Integer.TYPE ? new Integer(0) : (type == Long.TYPE ? new Long(0L) : (type == Float.TYPE ? new Float(0.0f) : (type == Double.TYPE ? new Double(0.0) : (type == Character.TYPE ? (Comparable<Character>)new Character('\u0000') : (Comparable<Character>)Boolean.FALSE))))));
        }
        return arguments;
    }

    private Callback createReverseEngineeredCallbackOfProperType(Callback callback, int index, Map callbackIndexMap) {
        Class<?> iface = null;
        Class<?>[] interfaces = callback.getClass().getInterfaces();
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            if (!(class$net$sf$cglib$proxy$Callback == null ? CGLIBEnhancedConverter.class$("net.sf.cglib.proxy.Callback") : class$net$sf$cglib$proxy$Callback).isAssignableFrom(interfaces[i2])) continue;
            iface = interfaces[i2];
            if (iface == (class$net$sf$cglib$proxy$Callback == null ? CGLIBEnhancedConverter.class$("net.sf.cglib.proxy.Callback") : class$net$sf$cglib$proxy$Callback)) {
                ConversionException exception = new ConversionException("Cannot handle CGLIB callback");
                exception.add("CGLIB-callback-type", callback.getClass().getName());
                throw exception;
            }
            interfaces = iface.getInterfaces();
            if (Arrays.asList(interfaces).contains(class$net$sf$cglib$proxy$Callback == null ? CGLIBEnhancedConverter.class$("net.sf.cglib.proxy.Callback") : class$net$sf$cglib$proxy$Callback)) break;
            i2 = -1;
        }
        return (Callback)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new ReverseEngineeringInvocationHandler(index, callbackIndexMap));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Enhancer enhancer = new Enhancer();
        reader.moveDown();
        enhancer.setSuperclass((Class)context.convertAnother(null, Class.class));
        reader.moveUp();
        reader.moveDown();
        ArrayList<Object> interfaces = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            interfaces.add(context.convertAnother(null, this.mapper.realClass(reader.getNodeName())));
            reader.moveUp();
        }
        enhancer.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
        reader.moveUp();
        reader.moveDown();
        boolean useFactory = Boolean.valueOf(reader.getValue());
        enhancer.setUseFactory(useFactory);
        reader.moveUp();
        ArrayList callbacksToEnhance = new ArrayList();
        ArrayList callbacks = new ArrayList();
        Map callbackIndexMap = null;
        reader.moveDown();
        if ("callbacks".equals(reader.getNodeName())) {
            reader.moveDown();
            callbackIndexMap = (Map)context.convertAnother(null, HashMap.class);
            reader.moveUp();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                this.readCallback(reader, context, callbacksToEnhance, callbacks);
                reader.moveUp();
            }
        } else {
            this.readCallback(reader, context, callbacksToEnhance, callbacks);
        }
        enhancer.setCallbacks(callbacksToEnhance.toArray(new Callback[callbacksToEnhance.size()]));
        if (callbackIndexMap != null) {
            enhancer.setCallbackFilter((CallbackFilter)new ReverseEngineeredCallbackFilter(callbackIndexMap));
        }
        reader.moveUp();
        Object result2 = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("serialVersionUID")) {
                enhancer.setSerialVersionUID(Long.valueOf(reader.getValue()));
            } else if (reader.getNodeName().equals("instance")) {
                result2 = this.create(enhancer, callbacks, useFactory);
                super.doUnmarshalConditionally(result2, reader, context);
            }
            reader.moveUp();
        }
        if (result2 == null) {
            result2 = this.create(enhancer, callbacks, useFactory);
        }
        return this.serializationMembers.callReadResolve(result2);
    }

    private void readCallback(HierarchicalStreamReader reader, UnmarshallingContext context, List callbacksToEnhance, List callbacks) {
        Callback callback = (Callback)context.convertAnother(null, this.mapper.realClass(reader.getNodeName()));
        callbacks.add(callback);
        if (callback == null) {
            callbacksToEnhance.add(NoOp.INSTANCE);
        } else {
            callbacksToEnhance.add(callback);
        }
    }

    private Object create(Enhancer enhancer, List callbacks, boolean useFactory) {
        Object result2 = enhancer.create();
        if (useFactory) {
            ((Factory)result2).setCallbacks(callbacks.toArray(new Callback[callbacks.size()]));
        }
        return result2;
    }

    protected List hierarchyFor(Class type) {
        List typeHierarchy = super.hierarchyFor(type);
        typeHierarchy.remove(typeHierarchy.size() - 1);
        return typeHierarchy;
    }

    protected Object readResolve() {
        super.readResolve();
        this.fieldCache = new HashMap();
        return this;
    }

    private static class ReverseEngineeredCallbackFilter
    implements CallbackFilter {
        private final Map callbackIndexMap;

        public ReverseEngineeredCallbackFilter(Map callbackIndexMap) {
            this.callbackIndexMap = callbackIndexMap;
        }

        public int accept(Method method) {
            if (!this.callbackIndexMap.containsKey(method)) {
                ConversionException exception = new ConversionException("CGLIB callback not detected in reverse engineering");
                exception.add("CGLIB-callback", method.toString());
                throw exception;
            }
            return (Integer)this.callbackIndexMap.get(method);
        }
    }

    private static final class ReverseEngineeringInvocationHandler
    implements InvocationHandler {
        private final Integer index;
        private final Map indexMap;

        public ReverseEngineeringInvocationHandler(int index, Map indexMap) {
            this.indexMap = indexMap;
            this.index = new Integer(index);
        }

        public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
            this.indexMap.put(this.indexMap.get(null), this.index);
            return null;
        }
    }

    private static class CGLIBFilteringReflectionProvider
    extends ReflectionProviderWrapper {
        public CGLIBFilteringReflectionProvider(ReflectionProvider reflectionProvider) {
            super(reflectionProvider);
        }

        public void visitSerializableFields(Object object, final ReflectionProvider.Visitor visitor) {
            this.wrapped.visitSerializableFields(object, new ReflectionProvider.Visitor(){

                public void visit(String name, Class type, Class definedIn, Object value) {
                    if (!name.startsWith("CGLIB$")) {
                        visitor.visit(name, type, definedIn, value);
                    }
                }
            });
        }
    }
}

