/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ISO8601JodaTimeConverter
extends AbstractSingleValueConverter {
    private static final DateTimeFormatter[] formattersUTC = new DateTimeFormatter[]{ISODateTimeFormat.dateTime(), ISODateTimeFormat.dateTimeNoMillis(), ISODateTimeFormat.basicDateTime(), ISODateTimeFormat.basicDateTimeNoMillis(), ISODateTimeFormat.basicOrdinalDateTime(), ISODateTimeFormat.basicOrdinalDateTimeNoMillis(), ISODateTimeFormat.basicTime(), ISODateTimeFormat.basicTimeNoMillis(), ISODateTimeFormat.basicTTime(), ISODateTimeFormat.basicTTimeNoMillis(), ISODateTimeFormat.basicWeekDateTime(), ISODateTimeFormat.basicWeekDateTimeNoMillis(), ISODateTimeFormat.ordinalDateTime(), ISODateTimeFormat.ordinalDateTimeNoMillis(), ISODateTimeFormat.time(), ISODateTimeFormat.timeNoMillis(), ISODateTimeFormat.tTime(), ISODateTimeFormat.tTimeNoMillis(), ISODateTimeFormat.weekDateTime(), ISODateTimeFormat.weekDateTimeNoMillis()};
    private static final DateTimeFormatter[] formattersNoUTC = new DateTimeFormatter[]{ISODateTimeFormat.basicDate(), ISODateTimeFormat.basicOrdinalDate(), ISODateTimeFormat.basicWeekDate(), ISODateTimeFormat.date(), ISODateTimeFormat.dateHour(), ISODateTimeFormat.dateHourMinute(), ISODateTimeFormat.dateHourMinuteSecond(), ISODateTimeFormat.dateHourMinuteSecondFraction(), ISODateTimeFormat.dateHourMinuteSecondMillis(), ISODateTimeFormat.hour(), ISODateTimeFormat.hourMinute(), ISODateTimeFormat.hourMinuteSecond(), ISODateTimeFormat.hourMinuteSecondFraction(), ISODateTimeFormat.hourMinuteSecondMillis(), ISODateTimeFormat.ordinalDate(), ISODateTimeFormat.weekDate(), ISODateTimeFormat.year(), ISODateTimeFormat.yearMonth(), ISODateTimeFormat.yearMonthDay(), ISODateTimeFormat.weekyear(), ISODateTimeFormat.weekyearWeek(), ISODateTimeFormat.weekyearWeekDay()};

    public boolean canConvert(Class type) {
        return false;
    }

    public Object fromString(String str) {
        for (int i2 = 0; i2 < formattersUTC.length; ++i2) {
            DateTimeFormatter formatter2 = formattersUTC[i2];
            try {
                DateTime dt2 = formatter2.parseDateTime(str);
                GregorianCalendar calendar = dt2.toGregorianCalendar();
                ((Calendar)calendar).setTimeZone(TimeZone.getDefault());
                return calendar;
            }
            catch (IllegalArgumentException dt2) {
                continue;
            }
        }
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault());
        for (int i3 = 0; i3 < formattersNoUTC.length; ++i3) {
            DateTimeFormatter element = formattersNoUTC[i3];
            try {
                DateTimeFormatter formatter3 = element.withZone(dateTimeZone);
                DateTime dt3 = formatter3.parseDateTime(str);
                GregorianCalendar calendar = dt3.toGregorianCalendar();
                ((Calendar)calendar).setTimeZone(TimeZone.getDefault());
                return calendar;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        ConversionException exception = new ConversionException("Cannot parse date");
        exception.add("date", str);
        throw exception;
    }

    public String toString(Object obj) {
        DateTime dt2 = new DateTime(obj);
        return dt2.toString(formattersUTC[0]);
    }
}

