/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public final class XmlHeaderAwareReader
extends Reader {
    private final InputStreamReader reader;
    private final double version;
    private static final String KEY_ENCODING = "encoding";
    private static final String KEY_VERSION = "version";
    private static final String XML_TOKEN = "?xml";
    private static final int STATE_BOM = 0;
    private static final int STATE_START = 1;
    private static final int STATE_AWAIT_XML_HEADER = 2;
    private static final int STATE_ATTR_NAME = 3;
    private static final int STATE_ATTR_VALUE = 4;

    public XmlHeaderAwareReader(InputStream in) throws UnsupportedEncodingException, IOException {
        PushbackInputStream[] pin = new PushbackInputStream[]{in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, 64)};
        Map header2 = this.getHeader(pin);
        this.version = Double.parseDouble((String)header2.get(KEY_VERSION));
        this.reader = new InputStreamReader((InputStream)pin[0], (String)header2.get(KEY_ENCODING));
    }

    private Map getHeader(PushbackInputStream[] in) throws IOException {
        HashMap<String, String> header2 = new HashMap<String, String>();
        header2.put(KEY_ENCODING, "UTF-8");
        header2.put(KEY_VERSION, "1.0");
        int state = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        int i2 = 0;
        char ch2 = '\u0000';
        char valueEnd = '\u0000';
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        boolean escape = false;
        while (i2 != -1 && (i2 = in[0].read()) != -1) {
            out.write(i2);
            ch2 = (char)i2;
            switch (state) {
                case 0: {
                    if (ch2 == '\u00ef' && out.size() == 1 || ch2 == '\u00bb' && out.size() == 2 || ch2 == '\u00bf' && out.size() == 3) {
                        if (ch2 != '\u00bf') break;
                        out.reset();
                        state = 1;
                        break;
                    }
                    if (out.size() > 1) {
                        i2 = -1;
                        break;
                    }
                    state = 1;
                }
                case 1: {
                    if (Character.isWhitespace(ch2)) break;
                    if (ch2 == '<') {
                        state = 2;
                        break;
                    }
                    i2 = -1;
                    break;
                }
                case 2: {
                    if (!Character.isWhitespace(ch2)) {
                        name.append(Character.toLowerCase(ch2));
                        if (XML_TOKEN.startsWith(name.substring(0))) break;
                        i2 = -1;
                        break;
                    }
                    if (name.toString().equals(XML_TOKEN)) {
                        state = 3;
                        name.setLength(0);
                        break;
                    }
                    i2 = -1;
                    break;
                }
                case 3: {
                    if (!Character.isWhitespace(ch2)) {
                        if (ch2 == '=') {
                            state = 4;
                            break;
                        }
                        if (Character.isLetter(ch2 = Character.toLowerCase(ch2))) {
                            name.append(ch2);
                            break;
                        }
                        i2 = -1;
                        break;
                    }
                    if (name.length() <= 0) break;
                    i2 = -1;
                    break;
                }
                case 4: {
                    if (valueEnd == '\u0000') {
                        if (ch2 == '\"' || ch2 == '\'') {
                            valueEnd = ch2;
                            break;
                        }
                        i2 = -1;
                        break;
                    }
                    if (ch2 == '\\' && !escape) {
                        escape = true;
                        break;
                    }
                    if (ch2 == valueEnd && !escape) {
                        valueEnd = '\u0000';
                        state = 3;
                        header2.put(name.toString(), value.toString());
                        name.setLength(0);
                        value.setLength(0);
                        break;
                    }
                    escape = false;
                    if (ch2 != '\n') {
                        value.append(ch2);
                        break;
                    }
                    i2 = -1;
                }
            }
        }
        byte[] pushbackData = out.toByteArray();
        i2 = pushbackData.length;
        while (i2-- > 0) {
            byte b2 = pushbackData[i2];
            try {
                in[0].unread(b2);
            }
            catch (IOException ex2) {
                in[0] = new PushbackInputStream(in[0], ++i2);
            }
        }
        return header2;
    }

    public String getEncoding() {
        return this.reader.getEncoding();
    }

    public double getVersion() {
        return this.version;
    }

    public void mark(int readAheadLimit) throws IOException {
        this.reader.mark(readAheadLimit);
    }

    public boolean markSupported() {
        return this.reader.markSupported();
    }

    public int read() throws IOException {
        return this.reader.read();
    }

    public int read(char[] cbuf, int offset, int length) throws IOException {
        return this.reader.read(cbuf, offset, length);
    }

    public int read(char[] cbuf) throws IOException {
        return this.reader.read(cbuf);
    }

    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public long skip(long n2) throws IOException {
        return this.reader.skip(n2);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean equals(Object obj) {
        return this.reader.equals(obj);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    public String toString() {
        return this.reader.toString();
    }
}

