/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import dk.brics.automaton.TransitionComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public final class ShuffleOperations {
    private ShuffleOperations() {
    }

    public static Automaton shuffle(Automaton a1, Automaton a2) {
        State s2;
        a1.determinize();
        a2.determinize();
        Transition[][] transitions1 = Automaton.getSortedTransitions(a1.getStates());
        Transition[][] transitions2 = Automaton.getSortedTransitions(a2.getStates());
        Automaton c2 = new Automaton();
        LinkedList<StatePair> worklist = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> newstates = new HashMap<StatePair, StatePair>();
        c2.initial = s2 = new State();
        StatePair p2 = new StatePair(s2, a1.initial, a2.initial);
        worklist.add(p2);
        newstates.put(p2, p2);
        while (worklist.size() > 0) {
            p2 = (StatePair)worklist.removeFirst();
            p2.s.accept = p2.s1.accept && p2.s2.accept;
            Transition[] t1 = transitions1[p2.s1.number];
            for (int n1 = 0; n1 < t1.length; ++n1) {
                StatePair q2 = new StatePair(t1[n1].to, p2.s2);
                StatePair r2 = (StatePair)newstates.get(q2);
                if (r2 == null) {
                    q2.s = new State();
                    worklist.add(q2);
                    newstates.put(q2, q2);
                    r2 = q2;
                }
                p2.s.transitions.add(new Transition(t1[n1].min, t1[n1].max, r2.s));
            }
            Transition[] t2 = transitions2[p2.s2.number];
            for (int n2 = 0; n2 < t2.length; ++n2) {
                StatePair q3 = new StatePair(p2.s1, t2[n2].to);
                StatePair r3 = (StatePair)newstates.get(q3);
                if (r3 == null) {
                    q3.s = new State();
                    worklist.add(q3);
                    newstates.put(q3, q3);
                    r3 = q3;
                }
                p2.s.transitions.add(new Transition(t2[n2].min, t2[n2].max, r3.s));
            }
        }
        c2.deterministic = false;
        c2.removeDeadTransitions();
        c2.checkMinimizeAlways();
        return c2;
    }

    public static String shuffleSubsetOf(Collection<Automaton> ca2, Automaton a2, Character suspend_shuffle, Character resume_shuffle) {
        if (ca2.size() == 0) {
            return null;
        }
        if (ca2.size() == 1) {
            Automaton a1 = ca2.iterator().next();
            if (a1.isSingleton()) {
                if (a2.run(a1.singleton)) {
                    return null;
                }
                return a1.singleton;
            }
            if (a1 == a2) {
                return null;
            }
        }
        a2.determinize();
        Transition[][][] ca_transitions = new Transition[ca2.size()][][];
        int i2 = 0;
        for (Automaton a1 : ca2) {
            ca_transitions[i2++] = Automaton.getSortedTransitions(a1.getStates());
        }
        Transition[][] a_transitions = Automaton.getSortedTransitions(a2.getStates());
        TransitionComparator tc = new TransitionComparator(false);
        ShuffleConfiguration init = new ShuffleConfiguration(ca2, a2);
        LinkedList<ShuffleConfiguration> pending = new LinkedList<ShuffleConfiguration>();
        HashSet<ShuffleConfiguration> visited = new HashSet<ShuffleConfiguration>();
        pending.add(init);
        visited.add(init);
        block1: while (!pending.isEmpty()) {
            ShuffleConfiguration c2 = (ShuffleConfiguration)pending.removeFirst();
            boolean good = true;
            for (int i1 = 0; i1 < ca2.size(); ++i1) {
                if (c2.ca_states[i1].accept) continue;
                good = false;
                break;
            }
            if (c2.a_state.accept) {
                good = false;
            }
            if (good) {
                StringBuilder sb = new StringBuilder();
                while (c2.prev != null) {
                    sb.append(c2.min);
                    c2 = c2.prev;
                }
                StringBuilder sb2 = new StringBuilder();
                for (int j2 = sb.length() - 1; j2 >= 0; --j2) {
                    sb2.append(sb.charAt(j2));
                }
                return sb2.toString();
            }
            Transition[] ta2 = a_transitions[c2.a_state.number];
            for (int i1 = 0; i1 < ca2.size(); ++i1) {
                if (c2.shuffle_suspended) {
                    i1 = c2.suspended1;
                }
                block6: for (Transition t1 : ca_transitions[i1][c2.ca_states[i1].number]) {
                    char min;
                    ArrayList<Transition> lt = new ArrayList<Transition>();
                    int j3 = Arrays.binarySearch(ta2, t1, tc);
                    if (j3 < 0) {
                        j3 = -j3 - 1;
                    }
                    if (j3 > 0 && ta2[j3 - 1].max >= t1.min) {
                        --j3;
                    }
                    while (j3 < ta2.length) {
                        Transition t2 = ta2[j3++];
                        min = t1.min;
                        char max = t1.max;
                        if (t2.min > min) {
                            min = t2.min;
                        }
                        if (t2.max < max) {
                            max = t2.max;
                        }
                        if (min > max) break;
                        ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min, max);
                        lt.add(new Transition(min, max, null));
                    }
                    Transition[] at2 = lt.toArray(new Transition[lt.size()]);
                    Arrays.sort(at2, tc);
                    min = t1.min;
                    for (int k2 = 0; k2 < at2.length && at2[k2].min <= min; ++k2) {
                        if (at2[k2].max >= t1.max) continue block6;
                        min = (char)(at2[k2].max + '\u0001');
                    }
                    ShuffleConfiguration nc = new ShuffleConfiguration(c2, i1, t1.to, min);
                    StringBuilder sb = new StringBuilder();
                    ShuffleConfiguration b2 = nc;
                    while (b2.prev != null) {
                        sb.append(b2.min);
                        b2 = b2.prev;
                    }
                    StringBuilder sb2 = new StringBuilder();
                    for (int m2 = sb.length() - 1; m2 >= 0; --m2) {
                        sb2.append(sb.charAt(m2));
                    }
                    if (c2.shuffle_suspended) {
                        sb2.append(BasicOperations.getShortestExample(nc.ca_states[c2.suspended1], true));
                    }
                    for (i1 = 0; i1 < ca2.size(); ++i1) {
                        if (c2.shuffle_suspended && i1 == c2.suspended1) continue;
                        sb2.append(BasicOperations.getShortestExample(nc.ca_states[i1], true));
                    }
                    return sb2.toString();
                }
                if (c2.shuffle_suspended) continue block1;
            }
        }
        return null;
    }

    private static void add(Character suspend_shuffle, Character resume_shuffle, LinkedList<ShuffleConfiguration> pending, Set<ShuffleConfiguration> visited, ShuffleConfiguration c2, int i1, Transition t1, Transition t2, char min, char max) {
        int HIGH_SURROGATE_BEGIN = 55296;
        int HIGH_SURROGATE_END = 56319;
        if (suspend_shuffle != null && min <= suspend_shuffle.charValue() && suspend_shuffle.charValue() <= max && min != max) {
            if (min < suspend_shuffle.charValue()) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min, (char)(suspend_shuffle.charValue() - '\u0001'));
            }
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, suspend_shuffle.charValue(), suspend_shuffle.charValue());
            if (suspend_shuffle.charValue() < max) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, (char)(suspend_shuffle.charValue() + '\u0001'), max);
            }
        } else if (resume_shuffle != null && min <= resume_shuffle.charValue() && resume_shuffle.charValue() <= max && min != max) {
            if (min < resume_shuffle.charValue()) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min, (char)(resume_shuffle.charValue() - '\u0001'));
            }
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, resume_shuffle.charValue(), resume_shuffle.charValue());
            if (resume_shuffle.charValue() < max) {
                ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, (char)(resume_shuffle.charValue() + '\u0001'), max);
            }
        } else if (min < '\ud800' && max >= '\ud800') {
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min, '\ud7ff');
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, '\ud800', max);
        } else if (min <= '\udbff' && max > '\udbff') {
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, min, '\udbff');
            ShuffleOperations.add(suspend_shuffle, resume_shuffle, pending, visited, c2, i1, t1, t2, '\udc00', max);
        } else {
            ShuffleConfiguration nc = new ShuffleConfiguration(c2, i1, t1.to, t2.to, min);
            if (suspend_shuffle != null && min == suspend_shuffle.charValue()) {
                nc.shuffle_suspended = true;
                nc.suspended1 = i1;
            } else if (resume_shuffle != null && min == resume_shuffle.charValue()) {
                nc.shuffle_suspended = false;
            }
            if (min >= '\ud800' && min <= '\ud800') {
                nc.shuffle_suspended = true;
                nc.suspended1 = i1;
                nc.surrogate = true;
            }
            if (!visited.contains(nc)) {
                pending.add(nc);
                visited.add(nc);
            }
        }
    }

    static class ShuffleConfiguration {
        ShuffleConfiguration prev;
        State[] ca_states;
        State a_state;
        char min;
        int hash;
        boolean shuffle_suspended;
        boolean surrogate;
        int suspended1;

        private ShuffleConfiguration() {
        }

        ShuffleConfiguration(Collection<Automaton> ca2, Automaton a2) {
            this.ca_states = new State[ca2.size()];
            int i2 = 0;
            for (Automaton a1 : ca2) {
                this.ca_states[i2++] = a1.getInitialState();
            }
            this.a_state = a2.getInitialState();
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration c2, int i1, State s1, char min) {
            this.prev = c2;
            this.ca_states = (State[])c2.ca_states.clone();
            this.a_state = c2.a_state;
            this.ca_states[i1] = s1;
            this.min = min;
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration c2, int i1, State s1, State s2, char min) {
            this.prev = c2;
            this.ca_states = (State[])c2.ca_states.clone();
            this.a_state = c2.a_state;
            this.ca_states[i1] = s1;
            this.a_state = s2;
            this.min = min;
            if (!this.surrogate) {
                this.shuffle_suspended = c2.shuffle_suspended;
                this.suspended1 = c2.suspended1;
            }
            this.computeHash();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ShuffleConfiguration) {
                ShuffleConfiguration c2 = (ShuffleConfiguration)obj;
                return this.shuffle_suspended == c2.shuffle_suspended && this.surrogate == c2.surrogate && this.suspended1 == c2.suspended1 && Arrays.equals(this.ca_states, c2.ca_states) && this.a_state == c2.a_state;
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        private void computeHash() {
            this.hash = 0;
            for (int i2 = 0; i2 < this.ca_states.length; ++i2) {
                this.hash ^= this.ca_states[i2].hashCode();
            }
            this.hash ^= this.a_state.hashCode() * 100;
            if (this.shuffle_suspended || this.surrogate) {
                this.hash += this.suspended1;
            }
        }
    }
}

