/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Transition;
import dk.brics.automaton.TransitionComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class State
implements Serializable,
Comparable<State> {
    static final long serialVersionUID = 30001L;
    boolean accept;
    Set<Transition> transitions;
    int number;
    int id;
    static int next_id;

    public State() {
        this.resetTransitions();
        this.id = next_id++;
    }

    final void resetTransitions() {
        this.transitions = new HashSet<Transition>();
    }

    public Set<Transition> getTransitions() {
        return this.transitions;
    }

    public void addTransition(Transition t2) {
        this.transitions.add(t2);
    }

    public void setAccept(boolean accept) {
        this.accept = accept;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public State step(char c2) {
        for (Transition t2 : this.transitions) {
            if (t2.min > c2 || c2 > t2.max) continue;
            return t2.to;
        }
        return null;
    }

    public void step(char c2, Collection<State> dest) {
        for (Transition t2 : this.transitions) {
            if (t2.min > c2 || c2 > t2.max) continue;
            dest.add(t2.to);
        }
    }

    void addEpsilon(State to) {
        if (to.accept) {
            this.accept = true;
        }
        this.transitions.addAll(to.transitions);
    }

    Transition[] getSortedTransitionArray(boolean to_first) {
        Transition[] e2 = this.transitions.toArray(new Transition[this.transitions.size()]);
        Arrays.sort(e2, new TransitionComparator(to_first));
        return e2;
    }

    public List<Transition> getSortedTransitions(boolean to_first) {
        return Arrays.asList(this.getSortedTransitionArray(to_first));
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append("state ").append(this.number);
        if (this.accept) {
            b2.append(" [accept]");
        } else {
            b2.append(" [reject]");
        }
        b2.append(":\n");
        for (Transition t2 : this.transitions) {
            b2.append("  ").append(t2.toString()).append("\n");
        }
        return b2.toString();
    }

    @Override
    public int compareTo(State s2) {
        return s2.id - this.id;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

