/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.ints;

import fleet.fastutil.ints.IntArrays;
import fleet.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\n\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0005\u001a$\u0010\t\u001a\u00020\u0007*\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u000bH\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0005\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0005*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0005*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0005\u001a\"\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0017\u001a\u0012\u0010\u001c\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0005\u001a-\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\u00022\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u001e0\u000b\u00a2\u0006\u0002\u0010 \"\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"containsAll", "", "Lfleet/fastutil/ints/IntList;", "elements", "", "", "ensureIndex", "", "index", "forEach", "action", "Lkotlin/Function1;", "contains", "element", "isEmpty", "isNotEmpty", "sum", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "(Lfleet/fastutil/ints/IntList;)Lkotlin/ranges/IntRange;", "length", "toArray", "", "indexOf", "from", "to", "a", "lastIndexOf", "firstNotNullOfOrNull", "R", "transform", "(Lfleet/fastutil/ints/IntList;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "fleet.fastutil"})
public final class IntListExtensionsKt {
    public static final boolean containsAll(@NotNull IntList $this$containsAll, @NotNull Collection<Integer> elements) {
        Intrinsics.checkNotNullParameter((Object)$this$containsAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterator<Integer> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            int element = ((Number)iterator2.next()).intValue();
            if (IntListExtensionsKt.contains($this$containsAll, element)) continue;
            return false;
        }
        return true;
    }

    public static final void ensureIndex(@NotNull IntList $this$ensureIndex, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureIndex, (String)"<this>");
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > $this$ensureIndex.getSize()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + $this$ensureIndex.getSize() + ")");
        }
    }

    public static final void forEach(@NotNull IntList $this$forEach, @NotNull Function1<? super Integer, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$forEach, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$forEach = false;
        IntRange intRange = IntListExtensionsKt.getIndices($this$forEach);
        int index = intRange.getFirst();
        int n2 = intRange.getLast();
        if (index <= n2) {
            while (true) {
                action.invoke((Object)$this$forEach.get(index));
                if (index == n2) break;
                ++index;
            }
        }
    }

    public static final boolean contains(@NotNull IntList $this$contains, int element) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        return IntListExtensionsKt.indexOf($this$contains, element) != -1;
    }

    public static final boolean isEmpty(@NotNull IntList $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return $this$isEmpty.getSize() == 0;
    }

    public static final boolean isNotEmpty(@NotNull IntList $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        return $this$isNotEmpty.getSize() != 0;
    }

    public static final int sum(@NotNull IntList $this$sum) {
        Intrinsics.checkNotNullParameter((Object)$this$sum, (String)"<this>");
        int sum2 = 0;
        IntRange intRange = IntListExtensionsKt.getIndices($this$sum);
        int i2 = intRange.getFirst();
        int n2 = intRange.getLast();
        if (i2 <= n2) {
            while (true) {
                sum2 += $this$sum.get(i2);
                if (i2 == n2) break;
                ++i2;
            }
        }
        return sum2;
    }

    @NotNull
    public static final IntRange getIndices(@NotNull IntList $this$indices) {
        Intrinsics.checkNotNullParameter((Object)$this$indices, (String)"<this>");
        return RangesKt.until((int)0, (int)$this$indices.getSize());
    }

    public static final int length(@NotNull IntList $this$length) {
        Intrinsics.checkNotNullParameter((Object)$this$length, (String)"<this>");
        return $this$length.getSize();
    }

    @NotNull
    public static final int[] toArray(@NotNull IntList $this$toArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toArray, (String)"<this>");
        int size = $this$toArray.getSize();
        if (size == 0) {
            return IntArrays.INSTANCE.getEMPTY_ARRAY();
        }
        int[] ret = new int[size];
        $this$toArray.toArray(0, ret, 0, size);
        return ret;
    }

    public static final int indexOf(@NotNull IntList $this$indexOf, int element) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        int n2 = $this$indexOf.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (element != $this$indexOf.get(i2)) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    public static final int[] toArray(@NotNull IntList $this$toArray, int from, int to, @NotNull int[] a2) {
        Intrinsics.checkNotNullParameter((Object)$this$toArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        int[] a3 = a2;
        if (a3.length < $this$toArray.getSize()) {
            int[] nArray = Arrays.copyOf(a3, $this$toArray.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            a3 = nArray;
        }
        $this$toArray.toArray(from, a3, 0, to);
        return a3;
    }

    public static final int lastIndexOf(@NotNull IntList $this$lastIndexOf, int element) {
        Intrinsics.checkNotNullParameter((Object)$this$lastIndexOf, (String)"<this>");
        int i2 = $this$lastIndexOf.getSize();
        while (i2-- != 0) {
            if (element != $this$lastIndexOf.get(i2)) continue;
            return i2;
        }
        return -1;
    }

    @Nullable
    public static final <R> R firstNotNullOfOrNull(@NotNull IntList $this$firstNotNullOfOrNull, @NotNull Function1<? super Integer, ? extends R> transform2) {
        Intrinsics.checkNotNullParameter((Object)$this$firstNotNullOfOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        IntRange intRange = IntListExtensionsKt.getIndices($this$firstNotNullOfOrNull);
        int index = intRange.getFirst();
        int n2 = intRange.getLast();
        if (index <= n2) {
            while (true) {
                Object result2;
                if ((result2 = transform2.invoke((Object)$this$firstNotNullOfOrNull.get(index))) != null) {
                    return (R)result2;
                }
                if (index == n2) break;
                ++index;
            }
        }
        return null;
    }
}

