/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.ints;

import fleet.fastutil.Arrays;
import fleet.fastutil.HashCommon;
import fleet.fastutil.ints.IntArrayList;
import fleet.fastutil.ints.IntIterator;
import fleet.fastutil.ints.IntList;
import fleet.fastutil.ints.IntListExtensionsKt;
import fleet.fastutil.ints.IntSet;
import fleet.fastutil.ints.IntSetExtensionsKt;
import fleet.fastutil.ints.MutableIntIterator;
import fleet.fastutil.ints.MutableIntSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 >2\u00020\u0001:\u0002=>B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nB!\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\fB\u001b\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000fB+\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\t\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0013J\b\u0010%\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020*H\u0002J\u0014\u0010+\u001a\u00020\u00182\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\u000e\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\tJ\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0010\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020\u0003H\u0002J\u0010\u00101\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u0003H\u0002J\b\u00102\u001a\u00020\u0018H\u0002J\u0010\u00103\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0011\u00104\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0003H\u0096\u0002J\u0006\u00105\u001a\u00020'J\u0010\u00106\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0003J\u0010\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020\u0003H\u0002J\u0013\u00109\u001a\u00020\u00182\b\u0010:\u001a\u0004\u0018\u00010;H\u0096\u0002J\b\u0010<\u001a\u00020\u0003H\u0016R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006?"}, d2={"Lfleet/fastutil/ints/IntOpenHashSet;", "Lfleet/fastutil/ints/MutableIntSet;", "expected", "", "f", "", "<init>", "(IF)V", "c", "Lfleet/fastutil/ints/IntList;", "(Lfleet/fastutil/ints/IntList;F)V", "", "(Ljava/util/Collection;F)V", "i", "Lfleet/fastutil/ints/IntIterator;", "(Lfleet/fastutil/ints/IntIterator;F)V", "a", "offset", "length", "(Lfleet/fastutil/ints/IntList;IIF)V", "key", "", "mask", "containsNull", "", "n", "maxFill", "minN", "size", "getSize", "()I", "setSize", "(I)V", "values", "Lfleet/fastutil/ints/MutableIntIterator;", "getValues", "()Lfleet/fastutil/ints/MutableIntIterator;", "realSize", "ensureCapacity", "", "capacity", "tryCapacity", "", "addAll", "elements", "add", "element", "shiftKeys", "pos", "removeEntry", "removeNullEntry", "remove", "contains", "clear", "trim", "rehash", "newN", "equals", "other", "", "hashCode", "SetIterator", "Companion", "fleet.fastutil"})
@SourceDebugExtension(value={"SMAP\nIntOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntOpenHashSet.kt\nfleet/fastutil/ints/IntOpenHashSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,548:1\n1#2:549\n*E\n"})
public final class IntOpenHashSet
implements MutableIntSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private int[] key;
    private int mask;
    private boolean containsNull;
    private int n;
    private int maxFill;
    private final int minN;
    private int size;
    private final float f;

    public IntOpenHashSet(int expected, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = HashCommon.INSTANCE.arraySize(expected, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, f2);
        this.key = new int[this.n + 1];
    }

    public /* synthetic */ IntOpenHashSet(int n2, float f2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n2 = 16;
        }
        if ((n3 & 2) != 0) {
            f2 = 0.75f;
        }
        this(n2, f2);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n2) {
        this.size = n2;
    }

    @Override
    @NotNull
    public MutableIntIterator getValues() {
        return new SetIterator();
    }

    public IntOpenHashSet(@NotNull IntList c2, float f2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        this(c2.getSize(), f2);
        this.addAll(c2);
    }

    public /* synthetic */ IntOpenHashSet(IntList intList, float f2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            f2 = 0.75f;
        }
        this(intList, f2);
    }

    public IntOpenHashSet(@NotNull Collection<Integer> c2, float f2) {
        Intrinsics.checkNotNullParameter(c2, (String)"c");
        this(c2.size(), f2);
        this.addAll(c2);
    }

    public /* synthetic */ IntOpenHashSet(Collection collection, float f2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            f2 = 0.75f;
        }
        this(collection, f2);
    }

    public IntOpenHashSet(@NotNull IntIterator i2, float f2) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        this(16, f2);
        while (i2.hasNext()) {
            this.add(i2.next());
        }
    }

    public /* synthetic */ IntOpenHashSet(IntIterator intIterator, float f2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            f2 = 0.75f;
        }
        this(intIterator, f2);
    }

    public IntOpenHashSet(@NotNull IntList a2, int offset, int length, float f2) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        this(length < 0 ? 0 : length, f2);
        Arrays.INSTANCE.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            this.add(a2.get(offset + i2));
        }
    }

    public /* synthetic */ IntOpenHashSet(IntList intList, int n2, int n3, float f2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            f2 = 0.75f;
        }
        this(intList, n2, n3, f2);
    }

    private final int realSize() {
        return this.containsNull ? this.getSize() - 1 : this.getSize();
    }

    private final void ensureCapacity(int capacity) {
        int needed = HashCommon.INSTANCE.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private final void tryCapacity(long capacity) {
        int needed = Math.min(0x40000000, Math.max(2, (int)HashCommon.INSTANCE.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    public final boolean addAll(@NotNull Collection<Integer> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(elements.size());
        } else {
            this.tryCapacity(this.getSize() + elements.size());
        }
        boolean retVal = false;
        Iterator<Integer> i2 = elements.iterator();
        while (i2.hasNext()) {
            if (!this.add(((Number)i2.next()).intValue())) continue;
            retVal = true;
        }
        return retVal;
    }

    public final boolean addAll(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(elements.getSize());
        } else {
            this.tryCapacity(this.getSize() + elements.getSize());
        }
        boolean modified = false;
        IntRange intRange = IntListExtensionsKt.getIndices(elements);
        int index = intRange.getFirst();
        int n2 = intRange.getLast();
        if (index <= n2) {
            while (true) {
                if (this.add(elements.get(index))) {
                    modified = true;
                }
                if (index == n2) break;
                ++index;
            }
        }
        return modified;
    }

    @Override
    public boolean add(int element) {
        int pos = 0;
        if (element == 0) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            block7: {
                int it;
                int n2;
                int curr = 0;
                int[] key = this.key;
                int n3 = n2 = HashCommon.INSTANCE.mix(element) & this.mask;
                int[] nArray = key;
                boolean bl2 = false;
                pos = it;
                it = n2 = nArray[n2];
                boolean bl3 = false;
                curr = it;
                if (n2 != 0) {
                    if (curr == element) {
                        return false;
                    }
                    do {
                        it = n2 = pos + 1 & this.mask;
                        nArray = key;
                        boolean bl4 = false;
                        pos = it;
                        it = n2 = nArray[n2];
                        boolean bl5 = false;
                        curr = it;
                        if (n2 == 0) break block7;
                    } while (curr != element);
                    return false;
                }
            }
            key[pos] = element;
        }
        int n4 = this.getSize();
        this.setSize(n4 + 1);
        if (n4 >= this.maxFill) {
            this.rehash(HashCommon.INSTANCE.arraySize(this.getSize() + 1, this.f));
        }
        return true;
    }

    private final void shiftKeys(int pos) {
        int pos2 = pos;
        int last = 0;
        int slot2 = 0;
        int curr = 0;
        int[] key = this.key;
        while (true) {
            int n2;
            int it = n2 = pos2;
            boolean bl2 = false;
            last = it;
            pos2 = n2 + 1 & this.mask;
            while (true) {
                it = n2 = key[pos2];
                boolean bl3 = false;
                curr = it;
                if (n2 == 0) {
                    key[last] = 0;
                    return;
                }
                slot2 = HashCommon.INSTANCE.mix(curr) & this.mask;
                if (last <= pos2 ? last >= slot2 || slot2 > pos2 : (pos2 + 1 <= slot2 ? slot2 <= last : false)) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last] = curr;
        }
    }

    private final boolean removeEntry(int pos) {
        int n2 = this.getSize();
        this.setSize(n2 + -1);
        this.shiftKeys(pos);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private final boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0;
        int n2 = this.getSize();
        this.setSize(n2 + -1);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(int element) {
        int it;
        int n2;
        if (element == 0) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n3 = n2 = HashCommon.INSTANCE.mix(element) & this.mask;
        int[] nArray = key;
        boolean bl2 = false;
        pos = it;
        it = n2 = nArray[n2];
        boolean bl3 = false;
        curr = it;
        if (n2 == 0) {
            return false;
        }
        if (element == curr) {
            return this.removeEntry(pos);
        }
        do {
            it = n2 = pos + 1 & this.mask;
            nArray = key;
            boolean bl4 = false;
            pos = it;
            it = n2 = nArray[n2];
            boolean bl5 = false;
            curr = it;
            if (n2 != 0) continue;
            return false;
        } while (element != curr);
        return this.removeEntry(pos);
    }

    @Override
    public boolean contains(int element) {
        int it;
        int n2;
        if (element == 0) {
            return this.containsNull;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n3 = n2 = HashCommon.INSTANCE.mix(element) & this.mask;
        int[] nArray = key;
        boolean bl2 = false;
        pos = it;
        it = n2 = nArray[n2];
        boolean bl3 = false;
        curr = it;
        if (n2 == 0) {
            return false;
        }
        if (element == curr) {
            return true;
        }
        do {
            it = n2 = pos + 1 & this.mask;
            nArray = key;
            boolean bl4 = false;
            pos = it;
            it = n2 = nArray[n2];
            boolean bl5 = false;
            curr = it;
            if (n2 != 0) continue;
            return false;
        } while (element != curr);
        return true;
    }

    public final void clear() {
        if (this.getSize() == 0) {
            return;
        }
        this.setSize(0);
        this.containsNull = false;
        ArraysKt.fill$default((int[])this.key, (int)0, (int)0, (int)0, (int)6, null);
    }

    public final boolean trim(int n2) {
        int l2 = HashCommon.INSTANCE.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (l2 >= this.n || this.getSize() > HashCommon.INSTANCE.maxFill(l2, this.f)) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (Throwable cantDoIt) {
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean trim$default(IntOpenHashSet intOpenHashSet, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = intOpenHashSet.getSize();
        }
        return intOpenHashSet.trim(n2);
    }

    private final void rehash(int newN) {
        int[] key = this.key;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int i2 = this.n;
        int pos = 0;
        int j2 = this.realSize();
        while (j2-- != 0) {
            int it;
            int n2;
            while (key[--i2] == 0) {
            }
            int n3 = n2 = HashCommon.INSTANCE.mix(key[i2]) & mask;
            int[] nArray = newKey;
            boolean bl2 = false;
            pos = it;
            if (nArray[n2] != 0) {
                do {
                    it = n2 = pos + 1 & mask;
                    nArray = newKey;
                    boolean bl3 = false;
                    pos = it;
                } while (nArray[n2] != 0);
            }
            newKey[pos] = key[i2];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof IntSet) {
            if (((IntSet)other).getSize() != this.getSize()) {
                return false;
            }
            return IntSetExtensionsKt.containsAll(this, (IntSet)other);
        }
        return false;
    }

    public int hashCode() {
        int h7 = 0;
        int[] key = this.key;
        int j2 = this.realSize();
        int i2 = 0;
        while (j2-- != 0) {
            while (key[i2] == 0) {
                ++i2;
            }
            h7 += key[i2];
            ++i2;
        }
        return h7;
    }

    public IntOpenHashSet() {
        this(0, 0.0f, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u000b\u001a\u00020\f\"\u00020\u0007\u00a8\u0006\r"}, d2={"Lfleet/fastutil/ints/IntOpenHashSet$Companion;", "", "<init>", "()V", "of", "Lfleet/fastutil/ints/IntOpenHashSet;", "e", "", "e0", "e1", "e2", "a", "", "fleet.fastutil"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntOpenHashSet of() {
            return new IntOpenHashSet(0, 0.0f, 3, null);
        }

        @NotNull
        public final IntOpenHashSet of(int e2) {
            IntOpenHashSet result2 = new IntOpenHashSet(1, 0.75f);
            result2.add(e2);
            return result2;
        }

        @NotNull
        public final IntOpenHashSet of(int e0, int e1) {
            IntOpenHashSet result2 = new IntOpenHashSet(2, 0.75f);
            result2.add(e0);
            if (!result2.add(e1)) {
                throw new IllegalArgumentException("Duplicate element: " + e1);
            }
            return result2;
        }

        @NotNull
        public final IntOpenHashSet of(int e0, int e1, int e2) {
            IntOpenHashSet result2 = new IntOpenHashSet(3, 0.75f);
            result2.add(e0);
            if (!result2.add(e1)) {
                throw new IllegalArgumentException("Duplicate element: " + e1);
            }
            if (!result2.add(e2)) {
                throw new IllegalArgumentException("Duplicate element: " + e2);
            }
            return result2;
        }

        @NotNull
        public final IntOpenHashSet of(int ... a2) {
            Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
            IntOpenHashSet result2 = new IntOpenHashSet(a2.length, 0.75f);
            for (int element : a2) {
                if (result2.add(element)) continue;
                throw new IllegalArgumentException("Duplicate element " + element);
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lfleet/fastutil/ints/IntOpenHashSet$SetIterator;", "Lfleet/fastutil/ints/MutableIntIterator;", "<init>", "(Lfleet/fastutil/ints/IntOpenHashSet;)V", "pos", "", "getPos", "()I", "setPos", "(I)V", "last", "getLast", "setLast", "c", "getC", "setC", "mustReturnNull", "", "getMustReturnNull", "()Z", "setMustReturnNull", "(Z)V", "wrapped", "Lfleet/fastutil/ints/IntArrayList;", "getWrapped", "()Lfleet/fastutil/ints/IntArrayList;", "setWrapped", "(Lfleet/fastutil/ints/IntArrayList;)V", "hasNext", "next", "remove", "", "shiftKeys", "fleet.fastutil"})
    @SourceDebugExtension(value={"SMAP\nIntOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntOpenHashSet.kt\nfleet/fastutil/ints/IntOpenHashSet$SetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,548:1\n1#2:549\n*E\n"})
    private final class SetIterator
    implements MutableIntIterator {
        private int pos;
        private int last;
        private int c;
        private boolean mustReturnNull;
        public IntArrayList wrapped;

        public SetIterator() {
            this.pos = IntOpenHashSet.this.n;
            this.last = -1;
            this.c = IntOpenHashSet.this.getSize();
            this.mustReturnNull = IntOpenHashSet.this.containsNull;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n2) {
            this.pos = n2;
        }

        public final int getLast() {
            return this.last;
        }

        public final void setLast(int n2) {
            this.last = n2;
        }

        public final int getC() {
            return this.c;
        }

        public final void setC(int n2) {
            this.c = n2;
        }

        public final boolean getMustReturnNull() {
            return this.mustReturnNull;
        }

        public final void setMustReturnNull(boolean bl2) {
            this.mustReturnNull = bl2;
        }

        @NotNull
        public final IntArrayList getWrapped() {
            IntArrayList intArrayList = this.wrapped;
            if (intArrayList != null) {
                return intArrayList;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"wrapped");
            return null;
        }

        public final void setWrapped(@NotNull IntArrayList intArrayList) {
            Intrinsics.checkNotNullParameter((Object)intArrayList, (String)"<set-?>");
            this.wrapped = intArrayList;
        }

        @Override
        public boolean hasNext() {
            return this.c != 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int next() {
            void it;
            int n2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n3 = this.c;
            this.c = n3 + -1;
            int[] key = IntOpenHashSet.this.key;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                this.last = IntOpenHashSet.this.n;
                return key[IntOpenHashSet.this.n];
            }
            do {
                this.pos += -1;
                if (this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                return this.getWrapped().get(-this.pos - 1);
            } while (key[this.pos] == 0);
            int n4 = n2 = this.pos;
            int[] nArray = key;
            boolean bl2 = false;
            this.last = it;
            return nArray[n2];
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.last == IntOpenHashSet.this.n) {
                IntOpenHashSet.this.containsNull = false;
                ((IntOpenHashSet)IntOpenHashSet.this).key[((IntOpenHashSet)IntOpenHashSet.this).n] = 0;
            } else if (this.pos >= 0) {
                this.shiftKeys(this.last);
            } else {
                IntOpenHashSet.this.remove(this.getWrapped().get(-this.pos - 1));
                this.last = -1;
                return;
            }
            int n2 = IntOpenHashSet.this.getSize();
            IntOpenHashSet.this.setSize(n2 + -1);
            this.last = -1;
        }

        private final void shiftKeys(int pos) {
            int pos2 = pos;
            int last = 0;
            int slot2 = 0;
            int curr = 0;
            int[] key = IntOpenHashSet.this.key;
            while (true) {
                int n2;
                int it = n2 = pos2;
                boolean bl2 = false;
                last = it;
                pos2 = n2 + 1 & IntOpenHashSet.this.mask;
                while (true) {
                    it = n2 = key[pos2];
                    boolean bl3 = false;
                    curr = it;
                    if (n2 == 0) {
                        key[last] = 0;
                        return;
                    }
                    slot2 = HashCommon.INSTANCE.mix(curr) & IntOpenHashSet.this.mask;
                    if (last <= pos2 ? last >= slot2 || slot2 > pos2 : (pos2 + 1 <= slot2 ? slot2 <= last : false)) break;
                    pos2 = pos2 + 1 & IntOpenHashSet.this.mask;
                }
                if (pos2 < last) {
                    if (this.wrapped == null) {
                        this.setWrapped(new IntArrayList(2));
                    }
                    this.getWrapped().add(key[pos2]);
                }
                key[last] = curr;
            }
        }
    }
}

